package biss.calendar;

import biss.DateLib;
import biss.FileLib;
import biss.VectorSorter;
import java.io.File;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class DateEntry
{
	int PaId;
	int State;
	String ItemText;
	int Category;
	String DetailFile;
	Date ADate = null;
	Date SDate = null;
	Date EDate = null;

void printOn ( PrintStream s ) {

	s.print( DateLib.toEDTFString(SDate)); s.print( ' ');
	s.print( DateLib.toEDTFString(EDate)); s.print( ' ');
	s.print( State);					   s.print( ' ');
	s.print( Category);					   s.print( ' ');
	s.print( PaId); 					   s.print( ' ');

	if ( DetailFile == null )  s.print( "- ");
	else                       s.print( DetailFile + ' ');

	if ( ADate != null){
		s.print( "a ");
		s.print( DateLib.toEDTFString(ADate));
	}
	else
		s.print( 'n');

	s.print( ' ');
	s.print( ItemText);
	s.println();
}

void setDetailFile ( String s ) {
	if ( ( s == null) || ( s.length() < 3 ) )
		DetailFile = null;
	else
		DetailFile = s;
}
}

class DateEntrySorter
  implements VectorSorter
{

public int compare ( Object a, Object b ) {
	Date da = ((DateEntry)a).SDate;
	Date db = ((DateEntry)b).SDate;

	if ( da.equals( db) )
		return 0;
	else if ( da.before( db) )
		return -1;
	else
		return 1;
}
}

class ViewEntry
{
	String Label = null;
	boolean VSep = false;
	Date EDate = null;
	Vector Dates = null;
	int ClashCount = 0;
	Vector Refs = null;

protected ViewEntry ( Date dt) {
	EDate = DateLib.clone( dt);
	setTimeLabel( dt);
}

protected ViewEntry ( DateEntry dt) {
	addDate( dt);
	setRangeLabel( dt);
}

protected ViewEntry ( String label) {
	Label = label;
	VSep = true;
}

void addDate ( DateEntry dt) {

	if ( Dates == null)
		Dates = new Vector( 3);

	if ( checkEntry( Dates, dt) || checkEntry( Refs, dt) )
		ClashCount++;

	Dates.addElement( dt);
}

void addRef ( DateEntry dt) {

	if ( Refs == null)
		Refs = new Vector( 3);

	if ( checkEntry( Dates, dt) || checkEntry( Refs, dt) )
		ClashCount++;

	Refs.addElement( dt);
}

static boolean checkEntry ( Vector v, DateEntry dt) {

	if ( v == null)
		return false;

	for ( Enumeration e = v.elements(); e.hasMoreElements(); ) {
		DateEntry de = (DateEntry)e.nextElement();
		if ( DateLib.intersects( de.SDate, de.EDate, dt.SDate, dt.EDate))
			return true;
	}

	return false;
}

boolean hasDates () {
	if ( (Dates == null) || (Dates.size() == 0) )
		return false;
	return true;
}

boolean hasRefs () {
	if ( (Refs == null) || (Refs.size() == 0) )
		return false;
	return true;
}

boolean isEmpty () {
	return ( !hasDates() && !hasRefs() );
}

int numDates () {
	if (Dates == null)
		return 0;
	return Dates.size();
}

void reset () {
	if ( Dates != null)
		Dates.removeAllElements();
	if ( Refs != null)
		Refs.removeAllElements();
	ClashCount = 0;
}

void setRangeLabel ( DateEntry de) {
	Label = DateLib.toHMString( de.SDate) + "-" + DateLib.toHMString( de.EDate);
}

void setTimeLabel ( Date dt) {
	if ( dt.getMinutes() == 0){
		VSep = true;
		Label = DateLib.toHMString( dt);
	}
	else
		Label = DateLib.toMString( dt);
}
}
