package biss;

import java.io.OutputStream;
import java.io.PrintStream;

/**
 * PrintStream which counts newlines while writing output
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class CLPrintStream
  extends PrintStream
{
	public int Line;

public CLPrintStream ( OutputStream os ) {
	super( os );
}

public CLPrintStream ( OutputStream os, boolean autoFlush ) {
	super( os, autoFlush );
}

public int getLine () {
	return Line;
}

public synchronized void write ( byte b[], int off, int len ) {

	int max = off+len;
	for ( int i=off; i<max; i++ )
		if ( b[i] == (byte)'\n' ) Line++;
	super.write( b, off, len);
}

public synchronized void write ( int b ) {
	if ( b == '\n' ) Line++;
	super.write( b);
}
}
