/**********************************************************
 * globals.h - definitions for qmon
 *
 * Written By: Lakhamraju R. Raju
 * Date: 11/03/93
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 **********************************************************/

#include "globals.h"
#include "qmonerrs.h"

static Widget           locqconf_popup;
static Widget           widget_locqconfrc;
static Widget           widget_locqconflabel;
static Widget           widget_locqconfframe;
static Widget           widget_locqconfmenu;
static Widget           widget_locqconfmain;
static Widget           widget_locqconfexec;
static Widget           widget_locqconfclear;
static Widget           widget_locqconfclose;
static Widget           widget_locqconfseparator;
static Widget           widget_locqconfopt;
static Widget		widget_locqconfinput;

struct optionstruct locqconfmenu[]={
  0,"Q_name      ",NULL,INPUTTYPE,NULL,NULL,
  0,"hostname    ",NULL,INPUTTYPE,NULL,NULL,
  0,"arc         ",NULL,INPUTTYPE,NULL,NULL,
  0,"group       ",NULL,INPUTTYPE,NULL,NULL,
  0,"type        ",NULL,INPUTTYPE,NULL,NULL,
  0,"quantity    ",NULL,INPUTTYPE,NULL,NULL,
  0,"subordinates",NULL,INPUTTYPE,NULL,NULL,
  0,"owners      ",NULL,INPUTTYPE,NULL,NULL,
  0,"users_file  ",NULL,INPUTTYPE,NULL,NULL,
  0,"xusers_File ",NULL,INPUTTYPE,NULL,NULL,
  0,"load_masg   ",NULL,INPUTTYPE,NULL,NULL,
  0,"load_alarm  ",NULL,INPUTTYPE,NULL,NULL,
  0,"act_hr      ",NULL,INPUTTYPE,NULL,NULL,
  0,"act_min     ",NULL,INPUTTYPE,NULL,NULL,
  0,"deact_hr    ",NULL,INPUTTYPE,NULL,NULL,
  0,"deact_min   ",NULL,INPUTTYPE,NULL,NULL,
  0,"Priority    ",NULL,INPUTTYPE,NULL,NULL,
  0,"seq_no      ",NULL,INPUTTYPE,NULL,NULL,
  0,"s_rt        ",NULL,INPUTTYPE,NULL,NULL,
  0,"h_rt        ",NULL,INPUTTYPE,NULL,NULL,
  0,"s_cpu       ",NULL,INPUTTYPE,NULL,NULL,
  0,"h_cpu       ",NULL,INPUTTYPE,NULL,NULL,
  0,"s_fsize     ",NULL,INPUTTYPE,NULL,NULL,
  0,"h_fsize     ",NULL,INPUTTYPE,NULL,NULL,
  0,"s_data      ",NULL,INPUTTYPE,NULL,NULL,
  0,"h_data      ",NULL,INPUTTYPE,NULL,NULL,
  0,"s_stack     ",NULL,INPUTTYPE,NULL,NULL,
  0,"h_stack     ",NULL,INPUTTYPE,NULL,NULL,
  0,"s_core      ",NULL,INPUTTYPE,NULL,NULL,
  0,"h_core      ",NULL,INPUTTYPE,NULL,NULL,
  0,"s_rss       ",NULL,INPUTTYPE,NULL,NULL,
  0,"h_rss       ",NULL,INPUTTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL, NULL
};


/***********************************************************
 * pb_locqconfexec - Activate callback for exec
 */
XtCallbackProc pb_locqconfexec(Widget w,caddr_t client_data,caddr_t call_data)
{
  char            command[MAX_STRING_SIZE];
  char            errmsg[MAX_STRING_SIZE];
  char            tmpfilename[MAX_STRING_SIZE];
  char            *ptr;
  int             ii;
  FILE            *fp;

  tmpnam(tmpfilename);
  if(!(fp=fopen(tmpfilename,"w"))) {
    sprintf(errmsg,ERROR_112,tmpfilename);
    logerr(errmsg);
    return;
  }

  for(ii=0;locqconfmenu[ii].name;ii++) {
    ptr=QmonTextGetString(locqconfmenu[ii].widgetid);
    fprintf(fp,"%s\t%s\n",locqconfmenu[ii].name,ptr);
  }

  fclose(fp);

  sprintf(command,"%s -cell %s -MQ %s",QCONF_BINARY,current_cell,tmpfilename);
  execit(command);
  sleep(1);
  unlink(tmpfilename);
  refreshicons();
}



/***********************************************************
 * pb_locqconfclear - Activate callback for clear
 */
XtCallbackProc pb_locqconfclear(Widget w,char *client_data,caddr_t call_data)
{
  char            buffer[MAX_STRING_SIZE];
  char            str1[MAX_STRING_SIZE];
  char            str2[MAX_STRING_SIZE];
  int             ii;
  FILE            *pfp;
  
  /*
   * We need to fill in the options with the default
   * values from qconf -sq
   */
  sprintf(buffer,"%s -cell %s -sq %s",QCONF_BINARY,current_cell,client_data);
  pfp=popen(buffer,"r");
  if(pfp) {
    ii=0;
    while(fgets(buffer,MAX_STRING_SIZE,pfp)) {
      sscanf(buffer,"%s %s",str1,str2);
      QmonTextSetString(locqconfmenu[ii].widgetid,str2);
      ii++;
    }
    pclose(pfp);
  }
  else {
    logerr("openwidget_locqconfsub: cannot do qconf -sq");
  }
}
/***********************************************************
 * pb_locqconfgetfile - Activate callback for getfile
 */
XtCallbackProc pb_locqconfgetfile(w,client_data,call_data)
Widget w;
caddr_t client_data,call_data;
{
  char            buffer[MAX_STRING_SIZE];
  char            str1[MAX_STRING_SIZE];
  char            str2[MAX_STRING_SIZE];
  int             ii;
  FILE            *pfp;
  char		  cmdline[1024];
  String          str3;
  
  /*
   * We need to fill in the options with the default
   * values from qconf -sq
   */
  str3=QmonTextGetString(widget_locqconfinput);
  sprintf(cmdline,"%s -cell %s -sq %s",QCONF_BINARY,current_cell,str3);
  pfp=popen(cmdline,"r");
  if(pfp) {
    ii=0;
    while(fgets(buffer,MAX_STRING_SIZE,pfp)) {
      sscanf(buffer,"%s %s",str1,str2);
      QmonTextSetString(locqconfmenu[ii].widgetid,str2);
      ii++;
    }
    pclose(pfp);
    if(ii==1) {
	printf("%s\n",buffer);
	pb_locqconfclear(w,NULL,NULL);
    }
  }
   else {
    logerr("openwidget_locqconfgetfile: cannot do qconf -sq");
  }
}


/*
 * pb_locqconfclose - Activate callback for close
 */
XtCallbackProc pb_locqconfclose(Widget w,caddr_t client_data,caddr_t call_data)
{
  closelocqconfmenuwin();
}


/***********************************************************
 * locqconfaction - Activate callback for action type menu
 */
XtCallbackProc locqconfaction(Widget w,caddr_t client_data,caddr_t call_data)
{
  int             ii;
  char            command[MAX_STRING_SIZE];

  for(ii=0;locqconfmenu[ii].name;ii++) {
    if(w==locqconfmenu[ii].widgetid) {
      sprintf(command,"%s -cell %s %s &",QCONF_BINARY,current_cell,locqconfmenu[ii].flag);
      execit(command);
      break;
    }
  }
}


/***********************************************************
 * create_locqconf_dialog - Create widgets used for the locqconf menu
 */
int create_locqconf_dialog(Widget w,char *client_data,XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        locqconf_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec,clear,close,getfile;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  locqconf_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w, args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  locqconf_form = XtCreateManagedWidget("form", formWidgetClass, locqconf_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_locqconflabel=
             XtCreateManagedWidget("Modify Q Configuration",labelWidgetClass,
					locqconf_form,args,ii);
  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_locqconflabel); ii++;
  widget_locqconfmain=XtCreateManagedWidget("box",formWidgetClass,locqconf_form,
                                        args,ii);
 exec=QmonAddButtonN(widget_locqconfmain,NULL,"Exec",(XtCallbackProc)pb_locqconfexec,NULL);
 clear=QmonAddButtonN(widget_locqconfmain,exec,"Clear",(XtCallbackProc)pb_locqconfclear,client_data);
 close=QmonAddButtonN(widget_locqconfmain,clear,"Close",(XtCallbackProc)pb_locqconfclose,NULL);

/*
  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  XtSetArg(args[ii], XtNfromVert, exec); ii++;
  widget_locqconflabel=
             XtCreateManagedWidget("Q Name",labelWidgetClass,
					widget_locqconfmain,args,ii);
  ii=0;
  XtSetArg(args[ii], XtNeditType, XawtextEdit); ii++;
  XtSetArg(args[ii], XtNstring, ""); ii++;
  XtSetArg(args[ii], XtNfromHoriz,widget_locqconflabel); ii++;
  XtSetArg(args[ii], XtNfromVert,clear); ii++;
  XtSetArg(args[ii], XtNresize,XawtextResizeBoth); ii++;
  XtSetArg(args[ii], XtNwidth,(Dimension)150); ii++;
  widget_locqconfinput=
  XtCreateManagedWidget("text",asciiTextWidgetClass,widget_locqconfmain,args,ii)
;
 getfile=
	QmonAddButtonN(widget_locqconfmain,widget_locqconfinput,"Get queue",pb_locqconfgetfile,NULL);

*/

  widget_locqconfopt=createmenuoptions(locqconf_form,widget_locqconfmain,locqconfmenu,(XtCallbackProc)locqconfaction);
  
}


/***********************************************************
 * openwidget_locqconfsub - Open the locqconf menu
 */
int openwidget_locqconfsub(Widget w,char *client_data,XtPointer call_data)
{
  char            buffer[MAX_STRING_SIZE];
  char            str1[MAX_STRING_SIZE];
  char            str2[MAX_STRING_SIZE];
  int             ii;
  FILE            *pfp;
  
 /* 
  * At present this is unimplimented in DQS3.0
  */
  
  create_sorry_dialog(w,NULL, NULL);
  openwidget_sorry();
  
  return 1 ;

  if(client_data != NULL) {
  	create_locqconf_dialog(w,client_data,NULL);
  	XtPopup(locqconf_popup,XtGrabNone);
  }
  else {
       printf(ERROR_113);
       return ;
   } 
  /*
   * We need to fill in the options with the default
   * values from qconf -sq
   */
  sprintf(buffer,"qconf -sq %s",client_data);
  pfp=popen(buffer,"r");
  if(pfp) {
    ii=0;
    while(fgets(buffer,MAX_STRING_SIZE,pfp)) {
      sscanf(buffer,"%s %s",str1,str2);
      QmonTextSetString(locqconfmenu[ii].widgetid,str2);
/*
      if(ii==0){QmonTextSetString(widget_locqconfinput,str2);}
*/
      ii++;
    }
    pclose(pfp);
  }
  else {
    logerr("openwidget_locqconfsub: cannot do qconf -sq");
  }
}


/***********************************************************
 * closewidget_locqconfsub - Close the locqconf menu
 */
int closewidget_locqconfsub()
{
  XtPopdown(locqconf_popup);
}



