static char dqs_setenv_rcsid[]="$Id: dqs_setenv.c,v 1.1.1.1 1998/08/18 14:39:13 green Exp $";

/*----------------------------------------------------
 * dqs_setenv.c Tom Green Mon Jan 31 10:43:02 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_setenv.c,v $
 * Revision 1.1.1.1  1998/08/18 14:39:13  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.2  1997/10/21 16:41:52  decker
 * Changed loop from 256 to 254.
 *
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.7  1997/03/13 12:04:21  nrl
 * removed a line which was supposed to be replaced by
 * a test for the existence of "value" to prevent a crash.
 *
 * Revision 3.6  1996/11/20 23:04:22  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.5  1996/03/22  04:21:15  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.4  1996/01/19  20:59:05  nrl
 * merged SCRI code and new job and queue structure changes
 *
 * Revision 3.3  1995/05/26  19:07:44  nrl
 * Cleaned up signal handling and the notify option with the
 * help of Ron Lee.
 *
 * Revision 3.2  1995/05/03  19:07:29  nrl
 * Bulletproofed case where environment variable is declared with no
 * associated value.
 *
 * Revision 3.1  1995/03/05  03:47:38  nrl
 * Included Axel Brandes job scheduling mechanism to keep one
 * user from hawging the queue.
 *
 * Revision 3.0  1994/03/07  04:14:34  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:47  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

extern char **environ;

/*****************************************************************************/
int dqs_setenv(name,value,overwrite)
     char *name;
     char *value;
     int  overwrite;
     
{
  int i = 0;
  int varlen;
  int myvarlen;
  int vallen;
  char tmpchar;
  
  DENTER_EXT((DQS_EVENT,"dqs_setenv"));
  
  /**** dummy  entry to diagnose compiler problems  */
  if(overwrite <0 ){
    DEXIT;
    return;
  }
  
  DPRINTF((DQS_EVENT,"dqs_setenv(%s,%s,%d)",name, value, overwrite));
  
  if ( name == NULL ){
    DPRINTF((DQS_EVENT,"NULL value submitted "));
    DEXITE;
  }
  
  
  varlen=strlen(name);
  
  
  if(value==NULL) vallen=0;
  else vallen= strlen(value);
  
  
  
  for (i = 0; environ[i] != NULL; i++) 
    {
      myvarlen= strlen(environ[i]);
      if( myvarlen< varlen) continue;
      tmpchar= environ[i][varlen];
      if ( (!strncmp(environ[i], name, varlen) )
	   && ( (tmpchar=='\0') || (tmpchar=='=') ) )
	{
	  environ[i]=dqs_realloc(environ[i],(varlen + vallen + 1));
	  strcpy(environ[i], name);
	  if ( value )strcat(environ[i], value);
	  DEXIT;
	  return;
	}
    }
  
  /*Suggested to 254 by Doug Gibson*/
  if(i>254) 
    environ = (char **) realloc(environ, sizeof (char *) * (i + 1));
  
  if (environ == NULL)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0471 error: realloc() failure"));
      DEXITE;
      exit(-1111);
    }
  
  environ[i]=dqs_malloc(varlen+vallen+1);
  
  strcpy(environ[i], name);
  
  if ( value )strcat(environ[i], value);
  
  environ[++i] = NULL;
  
  DEXIT;
}

