// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: basic.h,v 1.5 1998/08/27 04:09:30 jgg Exp $
/* ######################################################################

   BasicWidget - Base class for many of the widgets
   
   The Basic Widget provides many of the basic attributes that are found
   on all kinds of widgets from buttons to list boxes. It provides a 
   background colour, default draw function, border styles and handling
   as well as a uniform names for common things like 'Color'
   
   ##################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_BASIC_H
#define DEITY_BASIC_H

#ifdef __GNUG__
#pragma interface "deity/basic.h"
#endif

#include <deity/widget.h>

class BasicWidget : public Widget
{
   protected:

   // Basic widget colouring and style
   Color iBackground;
   Color iBorderUl;                  
   Color iBorderLr;
   Color iColor;
   SimpleFont iFont;
   Point iMargins;
   
   unsigned long iBorderWidth;
   unsigned long iBFlags;
   
   void BasicRender(CombinedGC &GC,bool Clear = true);
   virtual void Render(CombinedGC &GC) {BasicRender(GC,true);};
   
   public:

   enum BasicFlags {EtchBorder = (1 << 0)};
   
   virtual Point IdealSize();
      
   // BorderWidth
   void BorderWidth(unsigned long Width);
   inline unsigned long BorderWidth() const {return iBorderWidth;};

   // Flags
   inline bool IsBFlag(unsigned long F) const {return (iBFlags & F) == F;};
   void BFlag(unsigned long State, unsigned long F) {iBFlags = (iBFlags & (~F)) | State;};
   inline void BFlag(unsigned long F) {iBFlags |= F;};
   
   void Margins(Point Margins);
   inline Point const Margins() const {return iMargins;};
   
   inline SimpleFont Font() const {return iFont;};
   void Font(SimpleFont F) {iFont = F;Damage();};

   void Foreground(Color C);
   inline Color Foreground() const {return iColor;};
   void Background(Color C);
   inline Color Background() const {return iBackground;};
   inline void SwapBorderColors() {Color Tmp = iBorderUl;iBorderUl = iBorderLr;iBorderLr = Tmp;};
   
   BasicWidget(Widget *Parent = 0);
};

#endif
