/*
                 X J O Y S T I C K   C A L I B R A T O R

              Copyright (C) 1997, 1998, 1999, 2000 WolfPack

 */

#ifndef XJC_H
#define XJC_H


#include <stdio.h>
#include <db.h>
#include <sys/types.h>
#include <limits.h>

#ifdef JS_SUPPORT
# include <jsw.h>
#endif	/* JS_SUPPORT */

#include "../include/os.h"
#include "../include/osw-x.h"
#include "../include/widget.h"


/*
 *	Program name and version:
 */
#define PROG_NAME	"XJoystick Caliberator"
#define PROG_VERSION	"3.7"

#define PROG_VERSION_MAJOR	3
#define PROG_VERSION_MINOR	7


/*
 *	Usage information:
 */
#define PROG_USAGE_MESSAGE "\
Usage: xjscal [startup_device] [options] [GUI_options]\n\
\n\
    [starup_device] specifies the joystick device to open at\n\
    startup.\n\
\n\
    [options] can be any of the following:\n\
\n\
	-d <device>            Specifies the initial joystick device to\n\
                               open at startup.\n\
        -f <file>              Specifies the joystick caliberation file\n\
                               to open and save to.\n\
        --help                 Prints (this) help screen and exits.\n\
        --version              Prints version information and exits.\n\
\n\
    [GUI_options] can be any options standard to your GUI, consult\n\
    your GUI's manual for available options.\n\
\n"


/*
 *      Copyright information:
 */
#define PROG_COPYRIGHT	"\
Copyright (C) 1997, 1998, 1999, 2000 WolfPack Development Organization."



/*
 *	Menu op codes:
 */
#define JCW_MENU_CODE_NONE		0
#define JCW_MENU_CODE_OPEN_DEVICE	10
#define JCW_MENU_CODE_SAVE_CAL		11
#define JCW_MENU_CODE_SAVE_CAL_AS	12
#define JCW_MENU_CODE_EXIT		30

/*
 *	File browser op codes:
 */
#define FB_OP_CODE_NONE			0
#define FB_OP_CODE_OPEN_DEVICE		1
#define FB_OP_CODE_SAVE_AS		2


/*
 *	Runlevel:
 */
extern int runlevel;

/*
 *	Current time since midnight (in milliseconds):
 */
extern time_t cur_millitime;

/*
 *	Current systime (in seconds):
 */
extern time_t cur_systime;


/*
 *	Options:
 */
typedef struct {

	char cfgfmt;

} xjc_option_struct;
extern xjc_option_struct option;


/*
 *	Monitor images:
 */
typedef struct {

	image_t	*warning,
		*info,
		*error;
} xjc_image_struct;
extern xjc_image_struct xjc_image;


/*
 *	Draw amount codes:
 */
#define JCW_DRAW_AMOUNT_COMPLETE	0
#define JCW_DRAW_AMOUNT_AXISBARS	1
#define JCW_DRAW_AMOUNT_BUTTONSTATES	2
#define JCW_DRAW_AMOUNT_COORDINATES	3
#define JCW_DRAW_AMOUNT_STATUSBAR	4

/*
 *	Joystick Caliberator Window:
 */
/* Axis bar window array struct. */
typedef struct {

	int x, y;

	double pos;		/* Coefficient position, [-1, 1]. */
	int min, max, cur;

	prompt_window_struct	axis_num_prompt;

	win_t pos_win;
	pixmap_t pos_win_buf;

	toggle_button_struct	caliberate_tb;
        prompt_window_struct	null_zone_prompt;
	toggle_button_struct	flip_tb;	/* Flip axises. */

} axis_bar_struct;

typedef struct {

	char map_state;
	char is_in_focus;
	int x, y;
	unsigned int width, height;
	int visibility_state;

	char calib_file[PATH_MAX + NAME_MAX];	/* Caliberation file. */

	js_data_struct jsd;

	win_t toplevel;
	pixmap_t toplevel_buf;

	menu_bar_struct mb;

	win_t device_bar;

	prompt_window_struct device_prompt;

	pixmap_t axis_bar_bkg_pm;
	axis_bar_struct	**axis_bar;
	int total_axis_bars;

	prompt_window_struct	readout_x_axis_prompt,
				readout_y_axis_prompt;
	win_t readout_win;
	pixmap_t readout_bkg_pm;

	win_t status_bar_win;

} jcw_struct;

extern jcw_struct jcw;


/*
 *	Dialog widget:
 */
extern dialog_win_struct dialog;

/*
 *	File browser:
 */
extern fbrowser_struct file_browser;
extern int file_browser_op_code;	/* What is fb suppose to do. */



/* In jcfile.c */
extern int XJCDoSaveCaliberation(jcw_struct *j, char *path);

/* In jcwcb.c */
extern int JCFileBrowserCancelCB(char *path);
extern int JCFileBrowserOKCB(char *path);
extern int JCWMenuBarCB(void *ptr, int op_code);
extern int JCWDoOpenDevice(jcw_struct *j, char *device, char *calib_file);

/* In jcwmanage.c */
extern int AxisBarInit(
        axis_bar_struct *a,
        win_t parent,
        int x, int y,
        int axis_num,
        int flip
);
extern void AxisBarDraw(axis_bar_struct *a);
extern int AxisBarManage(axis_bar_struct *a, event_t *event);
extern void AxisBarMap(axis_bar_struct *a);
extern void AxisBarDestroy(axis_bar_struct *a);

extern int JCWInit(jcw_struct *j, int argc, char *argv[]);
extern void JCWDraw(jcw_struct *j, int amount);
extern int JCWManage(jcw_struct *j, event_t *event);
extern void JCWMap(jcw_struct *j);
extern void JCWUnmap(jcw_struct *j);
extern void JCWDestroy(jcw_struct *j);


/* In main.c */
extern void XJCSignalHandler(int s);
extern int XJCScrollBarCB(scroll_bar_struct *sb);

extern void XJCResetTimmers();

extern int XJCInit(int argc, char *argv[]);
extern void XJCManage();
extern void XJCShutdown();

/* In timming.c */
extern long MilliTime(void);


#endif /* XJC_H */
