/*
                      Program Primary Routines

	Functions:

	void XJCSignalHandler(int s)
	int XJCScrollBarCB(scroll_bar_struct *sb)

	void XJCResetTimmers()
	int XJCInit(int argc, char *argv[])
	void XJCManage()
	void XJCShutdown()

	int main(int argc, char *argv[])

	---

 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/stat.h>

#include "../include/strexp.h"
#include "../include/string.h"
#include "../include/disk.h"
#include "../include/os.h"
#include "../include/osw-x.h"
#include "../include/widget.h"

#include "xjc.h"

#include "config.h"

#include "../include/icons/error.h"
#include "../include/icons/info.h"
#include "../include/icons/warning.h"


int runlevel;
time_t cur_millitime;
time_t cur_systime;

xjc_option_struct option;
xjc_image_struct xjc_image;

jcw_struct jcw;

dialog_win_struct dialog;

fbrowser_struct file_browser;
int file_browser_op_code;



/*
 *	Signal handler.
 */
void XJCSignalHandler(int s)
{

	switch(s)
	{
          /* ****************************************************** */
          case SIGINT:
            runlevel = 1;
            break;

          /* ****************************************************** */
          case SIGTERM:
            runlevel = 1;
            break;

          /* ****************************************************** */
          case SIGQUIT:
            runlevel = 1;
            break;

          /* ****************************************************** */
          case SIGABRT:
            runlevel = 1;
            break;
            
          /* ****************************************************** */
          case SIGKILL:
            runlevel = 1;
            break;

          /* ****************************************************** */
          case SIGPIPE:
            signal(SIGPIPE, XJCSignalHandler);
            break;

          /* ****************************************************** */
          case SIGSEGV:
	    fprintf(stderr, "Segmentation fault.\n");
            runlevel = 1;
            break;

          /* ****************************************************** */
          case SIGCONT:
            signal(SIGCONT, XJCSignalHandler);
            break;

          /* ****************************************************** */
	  default:
	    break;
	}


	return;
}


/*
 *	Scroll bar callback handler.
 */
int XJCScrollBarCB(scroll_bar_struct *sb)
{
	return(0);
}


void XJCResetTimmers()
{
	return;
}


/*
 *	Program primary initializer.
 */
int XJCInit(int argc, char *argv[])
{
	int i, n, status;
	char *strptr;
	char cwd[PATH_MAX];


	cur_millitime = MilliTime();
	cur_systime = time(NULL);

	/* Get current working directory. */
        getcwd(cwd, PATH_MAX);
        cwd[PATH_MAX - 1] = '\0';

	/* Global options. */
	XJCResetTimmers();

	/* Set signal handler. */
        signal(SIGINT, XJCSignalHandler);
        signal(SIGTERM, XJCSignalHandler);
        signal(SIGQUIT, XJCSignalHandler);
        signal(SIGABRT, XJCSignalHandler);
        signal(SIGKILL, XJCSignalHandler);
        signal(SIGPIPE, XJCSignalHandler);
        signal(SIGSEGV, XJCSignalHandler);
        signal(SIGCONT, XJCSignalHandler);


	/* ******************************************************** */
	/* Parse arguments. */
	for(i = 1; i < argc; i++)
	{
	    if(argv[i] == NULL)
		continue;


	    /* Help. */
	    if(strcasepfx(argv[i], "--h") ||
               strcasepfx(argv[i], "-h") ||
               strcasepfx(argv[i], "-?")
            )
	    {
		printf(PROG_USAGE_MESSAGE);
		return(-4);
	    }
            /* Version. */
            else if(strcasepfx(argv[i], "--ver") ||
                    strcasepfx(argv[i], "-ver")
            )
            {
                printf(
		    "%s Version %s\n%s\n",
		    PROG_NAME,
		    PROG_VERSION,
		    PROG_COPYRIGHT
		);
                return(-4);
            }
	}


        /* Connect to GUI. */
        status = OSWGUIConnect(argc, argv);
        if(status)
            return(-1);

        /* Initialize widget globals. */  
        status = WidgetInitGlobals(argc, argv);
        if(status)
            return(-1);

	SBarSetNotifyFunction(XJCScrollBarCB);



        /* Dialog. */
        status = DialogWinInit(
                &dialog,
                osw_gui[0].root_win,
                0, 0,			/* Default width and height. */
                xjc_image.warning
        );
        if(status)
            return(-1);

        /* File browser. */
        status = FBrowserInit(
                &file_browser,
                0, 0,
                0, 0,
                cwd,                    /* Initial directory. */
                FB_STYLE_SINGLE_LIST,
                JCFileBrowserOKCB,      /* OK callback function. */
                JCFileBrowserCancelCB   /* Cancel callback function. */
        );
        if(status)
            return(-1);

	file_browser_op_code = FB_OP_CODE_NONE;


	/* Load images. */
        xjc_image.info = WidgetLoadImageFromTgaData(info_tga);
        xjc_image.error = WidgetLoadImageFromTgaData(error_tga);
        xjc_image.warning = WidgetLoadImageFromTgaData(warning_tga);

	/* Axis readout pixmaps rendered in JCWInit(). */


	/* Initialize joystick caliberator iwndow. */
	if(
	    JCWInit(&jcw, argc, argv)
	)
	    return(-1);

	JCWMap(&jcw);


	return(0);
}



void XJCManage()
{
	int i, axis_num;
	int events_handled = 0;
	int total_events_handled = 0;
	time_t t;
	event_t event;

	js_data_struct *jsd;
	axis_bar_struct *axis_bar;


	/* Update timming. */
	t = MilliTime();
	if(t < cur_millitime)
	{
	    XJCResetTimmers();
	}
	cur_millitime = t;

	cur_systime = time(NULL);


	/* ***************************************************** */
	/* Manage GUI events. */
        while((OSWEventsPending() > 0) &&
              (total_events_handled < 8)
	)
        {   
            /* Reset events counter. */
            events_handled = 0;
                 
            /* Get event. */
            OSWWaitNextEvent(&event);
                 
                
            /*   Let WidgetManage() see this event.
             *   It is not important if the event is handled or not, so
             *   the return value is disgarded.
             */
            WidgetManage(&event);


	    /* Manage joystick caliberation window. */
	    JCWManage(&jcw, &event);

            /* External widgets. */
            events_handled += DialogWinManage(
                &dialog,
                &event
            );
            events_handled += FBrowserManage(
                &file_browser,
                &event
            );


	    total_events_handled += events_handled;
	}


        /* ******************************************************* */
	/* Schedualed actions. */

	if(1)
	{
	    jsd = &jcw.jsd;

	    /* Check for joystick value change. */
	    if(JSUpdate(jsd) == JSGotEvent)
	    {
		/* Go through axis bars on jcw. */
		for(i = 0; i < jcw.total_axis_bars; i++)
		{
		    axis_bar = jcw.axis_bar[i];
		    if(axis_bar == NULL)
			continue;

		    /* Get axis number. */
		    axis_num = PromptGetI(&axis_bar->axis_num_prompt);
		    if(!JSIsAxisAllocated(jsd, axis_num))
			continue;

		    if(axis_bar->caliberate_tb.state)
		    {
			/* Caliberating. */
			if(jsd->axis[axis_num]->cur < axis_bar->min)
			{
			    axis_bar->min = jsd->axis[axis_num]->cur;
			    jsd->axis[axis_num]->min = jsd->axis[axis_num]->cur;
			}
                        else if(jsd->axis[axis_num]->cur > axis_bar->max)
                        {
                            axis_bar->max = jsd->axis[axis_num]->cur;
                            jsd->axis[axis_num]->max = jsd->axis[axis_num]->cur;
                        }

			jsd->axis[axis_num]->cen = jsd->axis[axis_num]->cur;
		    }
		    else
		    {

		    }

		    axis_bar->pos = JSGetAxisCoeff(jsd, axis_num);
		    axis_bar->cur = jsd->axis[axis_num]->cur;

		    AxisBarDraw(axis_bar);
                    JCWDraw(&jcw, JCW_DRAW_AMOUNT_COORDINATES);
		}
	    }
	}



	return;
}


void XJCShutdown()
{
        /* File browser and dialog widgets. */
        FBrowserDestroy(&file_browser);
        DialogWinDestroy(&dialog);

	/* JCWs. */
	JCWDestroy(&jcw);

	/* Images. */
        OSWDestroyImage(&xjc_image.error);
        OSWDestroyImage(&xjc_image.info);
        OSWDestroyImage(&xjc_image.warning);


        /*   Free widget globals after all client allocated widgets
         *   have been deallocated.
         */
        WidgetDestroyGlobals();

        /* Disconnect from the GUI. */
        OSWGUIDisconnect();


	return;
}



int main(int argc, char *argv[])
{
	runlevel = 1;

	switch(XJCInit(argc, argv))
	{
	  case 0:
	    break;

	  case -4:
            XJCShutdown();
            return(0);
	    break;

	  default:
	    XJCShutdown();
	    return(1);
	    break;
	}


	runlevel = 2;

        while(runlevel >= 2)
        {
            usleep(8000);

            /*   Must call WidgetManage() once per loop to let
             *   the widget set do what it needs to do.
             */
            WidgetManage(NULL);

            XJCManage();
        }


        runlevel = 1;
        XJCShutdown();


	return(0);
}
