#include <GL/gl.h>

#include "global.h"
#include "texture.h"
#include "model.h"
#include "walls.h"


Walls *firstwall = NULL;

static char buf[BUFSIZ];
static char line[LINESIZE];
static int pos = 0, bufcap = 0;


Private inline
int get_char(void *b)
{
  if (pos >= bufcap) {
    pos = 0;
    bufcap = httpRead(b, buf, sizeof(buf));
    if (bufcap == 0)
      return -1;
  }
  return buf[pos++];
}

Private
int get_line(void *b)
{
  int i = 0;
  
  while (1) {
    int c = get_char(b);

    if (c == '\n')
      break;
    if (c < 0) {
      line[i] = '\0';
      return -1;
    }
    line[i++] = c;
  }
  line[i++] = '\0';
  return 0;
}

Private
void wallsLoadHttp(void *va, void *ba)
{
  FILE *f;
  Walls *cur, *prev = NULL;
  float r, g, b, xs, xe, zs, ze, ys, ye;

  while (1) {
    get_line(ba);
    
    if (line[0] == '#') {
      continue;
    }
    if (sscanf(line, "%f %f %f %f %f %f  %f %f %f",
	       &xs, &xe, &ys, &ye, &zs, &ze, &r, &g, &b) <= 0)
      break;
    
    cur = (Walls *) malloc(sizeof(Walls));
    cur->xs = xs;
    cur->ys = ys;
    cur->zs = zs;
    cur->xe = xe;
    cur->ye = ye;
    cur->ze = ze;
    cur->r  = r;
    cur->g  = g;
    cur->b  = b;
    
    if (prev == NULL)
      firstwall = cur;
    else
      prev->next = cur;
    prev = cur;
  }
  cur->next = NULL;
}

Private inline
wallsDisplay(Walls *walls)
{
  glColor3f(walls->r, walls->g, walls->b);
  glBegin(GL_QUADS); {
    glVertex3f(walls->xs, walls->ys, walls->zs);
    glVertex3f(walls->xs, walls->ys, walls->ze);
    glVertex3f(walls->xe, walls->ye, walls->ze);
    glVertex3f(walls->xe, walls->ye, walls->zs);
  } glEnd();
}

Private inline
float comp_norm(V3 *a, V3 *b)
{
  float Rx = a->v[0] - b->v[0];
  float Ry = a->v[1] - b->v[1];
  float Rz = a->v[2] - b->v[2];

  return Rx * Rx + Ry * Ry + Rz * Rz;
}

Private inline
float scalair(float ax, float ay, float bx, float by)
{
  return ax * bx + ay * by;
}

Public
int Solid_intersect_Walls(V3 *bb_center, V3 *bb_size, V3 *norm)
{
  Walls *wall = firstwall;
  float oxmax, oxmin, oymax, oymin, ozmax, ozmin;
  V3 cur_norm;
  int first = 1;
  
  oxmin = bb_center->v[0] - bb_size->v[0];
  oxmax = bb_center->v[0] + bb_size->v[0];
  oymin = bb_center->v[1] - bb_size->v[1];
  oymax = bb_center->v[1] + bb_size->v[1];
  ozmin = bb_center->v[2] - bb_size->v[2];
  ozmax = bb_center->v[2] + bb_size->v[2];

  /* Now, we test the collision with all the walls */
  while (wall != NULL) {
    float wxmin = wall->xs < wall->xe ? wall->xs : wall->xe;
    float wxmax = wall->xs > wall->xe ? wall->xs : wall->xe;
    float wymin = wall->ys < wall->ye ? wall->ys : wall->ye;
    float wymax = wall->ys > wall->ye ? wall->ys : wall->ye;
    float wzmin = wall->zs < wall->ze ? wall->zs : wall->ze;
    float wzmax = wall->zs > wall->ze ? wall->zs : wall->ze;
    if ((((oxmin < wxmin) && (oxmax > wxmax)) ||
	 ((oxmin > wxmin) && (oxmax < wxmax)) ||
	 ((oxmax > wxmin) && (oxmax < wxmax)) ||
	 ((oxmin > wxmin) && (oxmin < wxmax)))
	&&
	(((oymin < wymin) && (oymax > wymax)) ||
	 ((oymin > wymin) && (oymax < wymax)) ||
	 ((oymax > wymin) && (oymax < wymax)) ||
	 ((oymin > wymin) && (oymin < wymax)))
	&&
	(((ozmin < wzmin) && (ozmax > wzmax)) ||
	 ((ozmin > wzmin) && (ozmax < wzmax)) ||
	 ((ozmax > wzmin) && (ozmax < wzmax)) ||
	 ((ozmin > wzmin) && (ozmin < wzmax)))) {
      cur_norm.v[2] = 0.0;
      if (wxmin == wxmax) {
	cur_norm.v[0] = 1.0;
	cur_norm.v[1] = 0.0;
      } else {
	cur_norm.v[1] = 1.0;
	cur_norm.v[0] = 0.0;
      }

      /* Test which normal we take.... */
      if (scalair(bb_center->v[0] - wxmin, bb_center->v[1] - wymin,
		cur_norm.v[0], cur_norm.v[1]) < 0.0) {
	cur_norm.v[0] = -cur_norm.v[0];
	cur_norm.v[1] = -cur_norm.v[1];
      }
      if (first) {
	*norm = cur_norm;
	first = 0;
      } else {
	if (comp_norm(&cur_norm, norm) > 0.01)
	  return 2;
      }
    }
    wall = wall->next;
  }
  if (first)
    return 0; /* No collisions */
  else
    return 1;
}


Public
void render_walls(void)
{
  Walls *wall = firstwall;
  
  glDisable(GL_LIGHTING);	/* No lighting on walls */
  glDisable(GL_CULL_FACE);	/* A wall = one facet => no culling */
  while (wall != NULL) {
    wallsDisplay(wall);
    wall = wall->next;
  }
  glEnable(GL_LIGHTING);
}

Public
void load_walls(char *url)
{
  httpOpen(url, (void *) wallsLoadHttp, NULL, NO_BLOCK);
}

Public
void delete_walls(void)
{
  /* Just freeing the list allocated in wallsLoadHttp callback (via httpOpen) */
  /* Not sure this is enough... */
  while (firstwall) {
    Walls * ptr = firstwall->next;
    free(ptr);
    firstwall = ptr;
  }
}

Public
void initWallsFuncList(void)
{
}
