#include "global.h"
#include "parse.h"


int wmgtlockstate;
WObject *plocaluser;
ObjectList stilllist, mobilelist, volatilelist;
Grid grid;
GeneralFuncList generalFuncList;
GeneralMethodList generalMethodList;
u_int8 propertiesnumber[TYPESNUMBER];
char methodname[BUTTONSNUMBER][HNAME_LEN];
float defmaxlasting[TYPESNUMBER];

static ObjectList todelete = NULL;


/* Update the World */
Public
int doWorldCalculation(long sec, long usec)
{
  ObjectList list;

  switch (wmgtlockstate) {
  case LOCK_TOBUILD:
    fatal("Wmgt: doWorldCalculation with wmgtlockstate = 1");
    return 0;
  case LOCK_DOWNLOADED:
    wmgtlockstate = LOCK_OK;
    plocaluser->secs = sec;
    plocaluser->usecs = usec;
    clearIspointedFlag(stilllist);
    clearIspointedFlag(mobilelist);
  case LOCK_OK:

    /*
     * do user motions
     */
    userMovement(sec, usec, plocaluser);

    /*
     * do volatile objects motions
     */
    for (list = mobilelist; list != NULL; list = list->next)
      objectMovement(sec, usec, list->pobject);

    /*
     * do permanent objects motions
     */
    for (list = mobilelist; list != NULL; list = list->next)
      objectPermanentMovement(sec, usec, list->pobject);

    /*
     * delete delayed deleted objects
     */
    ObjectsDelete();
  }
}

/* Signale au module Gestion du Monde le message envoye par l'utilisateur */
Public
void userWriting(char *usermsg)
{
  strcpy(plocaluser->ext.user.message, usermsg);
  plocaluser->ext.user.lastmess++;
  declareDelta(&(plocaluser->noh), USERPROPMSG);      /* message property */
}

/* call special methods for each object */
void specialAction(Solid solid, int method, long sec, long usec,...)
{
  WObject *pwoh;
  
  pwoh = (solid == NULL) ? plocaluser : getPobjectFromSolid(solid);
  if (generalMethodList[method][pwoh->noh.type].method != NULL)
    generalMethodList[method][pwoh->noh.type].method(pwoh, sec, usec);
}

/* permet au module utilisateur d'acceder a un nom
 * intelligible d'un objet (seul, le module Gestion du Monde
 * y a acces), ainsi qu'au nom des methodes
 */
void getObjectHumanName(Solid solid, char **h_name, char **pmethods)
{
  int i;
  WObject *pwoh;
  
  assert(solid);
  pwoh = getPobjectFromSolid(solid);
  *h_name = pwoh->h_name;
  *pmethods = (char *)methodname;

  for (i=0; generalMethodList[i][pwoh->noh.type].name[i] != '\0'; i++)
    strcpy(methodname[i], generalMethodList[i][pwoh->noh.type].name);
  methodname[i][0] = '\0';
}

Public
void ObjectsDelete()
{
  while (todelete != NULL) {
    ObjectList next;
    
    deleteObjectFromGrid(todelete->pobject);
    mobilelist = deleteObjectFromList(todelete->pobject, mobilelist);
    SolidDelete(todelete->pobject->soh);
    declareDeletion((NetObject*) todelete->pobject);
    deleteNetObject((NetObject*) todelete->pobject);
    selectedObjectDeletion(todelete->pobject->soh);
    free(todelete->pobject);
    next = todelete->next;
    free(todelete);
    todelete = next;
  }
}

Public
void ObjectDelete(WObject *pwoh)
{
  ObjectList tmp = todelete;

  while (tmp != NULL) {
    if (tmp->pobject == pwoh)
      break;
    tmp = tmp->next;
  }
  if (tmp == NULL)
    todelete = addObjectToList(pwoh, todelete);
}
