#include "global.h"
#include "parse.h"


/* wall parser */
Private
void wallParser(char *l, WObject *pwall)
{
  char *w;

  w = parseFileLine(l);
  w = parsePosition(w, pwall);
  pwall->soh = SolidParser(w);
}

/* wall creation from a file */
Private
void wallCreateFromFile(Fileline l)
{
  WObject *pwall;

  pwall = (WObject*) malloc(sizeof(WObject));
  memset(pwall, 0, sizeof(WObject));    
  pwall->noh.type = WALLTYPE;
  strcpy(pwall->h_name, WALLNAME);
  wallParser(l, pwall);
  updateObjectIn3D(pwall);
  setOptionalBuffer(pwall);
  updateBB(pwall);
  stilllist = addObjectToList(pwall, stilllist);
  insertObjectIntoGrid(pwall);
} 

/* object intersection: stop */
Private
void wallIntersect(WObject *pwoh, WObject *pwohold, WObject *pwall)
{
  if (pwoh->noh.type == BALLTYPE) {
    trace(DBG_FORCE, "bounce: pwoh->z=%f pwoh->ext.ball.origz=%f", pwoh->z, pwoh->ext.ball.origz);
    if (ABSF(pwoh->z - pwoh->ext.ball.origz) > 0.05) {
      WObject *pballold;

      pballold = copy_object(pwoh);
      pwoh->z = pwoh->ext.ball.origz / 4;
      pwoh->ext.ball.origz = pwoh->z;
      pwoh->ext.ball.remaint = BALLREMAINT;
      update_object(pwoh, pballold);
    }
    else {
      trace(DBG_FORCE, "end bounce: pwoh->z=%f pwoh->ext.ball.origz=%f", pwoh->z, pwoh->ext.ball.origz);
      copyPositionAndBB(pwohold, pwoh);
    }
  }
  else {
    copyPositionAndBB(pwohold, pwoh);
  }
}

/* functions initialization */
Public
void initWallFuncList(void)
{
  generalFuncList[WALLTYPE].createFromFileline = wallCreateFromFile;
  generalFuncList[WALLTYPE].whenIntersect = wallIntersect;
  
  propertiesnumber[WALLTYPE] = 0;
}
