#ifndef USER_H
#define USER_H


#define USERTYPE	1
#define USERNAME	"User"
#define	USERINIT	initUserFuncList

#include "keys.h"

#define USERPROPHNAME	0
#define USERPROPMAP	1
#define USERPROPMAP1	2
#define USERPROPXY	3
#define USERPROPZ	4
#define USERPROPA1	5
#define USERPROPA2	6
#define USERPROPMSG	7
#define USERPROPWORLD	8
#define USERPROPA3	9
#define USERPROPERTIES	10

#define MAXURLLENGTH	128

#define USERGEOMETRY	"0.08,0.13,0.85"
#define USERHALFSIZEX	"0.08"	/* depth = 16 cm */
#define USERHALFSIZEY	"0.13"	/* width = 26 cm */
#define USERHALFSIZEZ	"0.85"	/* height= 170 cm */
#define USERPOSZ	0.86	/* initial z position */
#define USERLSPEED	3	/* linear speed : 3 m/s */
#define USERASPEED	2.0	/* angular speed */
#define EXTUSERLSPEED	10
#define EXTUSERASPEED	5.0
#define USERDEFMAXLAST	0.015	/* 15 ms */
#define USERDELTAZ	0.02	/* 2 cm */
#define USERGOTHROUGH	0.05	/* 5 cm */
#define USERFOVY	26	/* 26 degrees */
#define USERNEAR	0.5	/* orig: 0.4 */
#define USERFAR		200	/* orig: 500 */
#define USERDENSITY	1.0

/* methods */
#ifndef BULLETCREAT
#define BULLETCREAT	0
#endif
#ifndef DARTCREAT
#define DARTCREAT	1
#endif
#define FOVYORIGINAL	2
#define FOVYLESS	3
#define FOVYGREATER	4

#ifndef OUILLESND
#define OUILLESND	"/usr/local/sounds/ouille.au"
#endif


typedef struct {
  char  message[MESS_LEN];
  char  urlface[URL_LEN];
  char  urlback[URL_LEN];
  int   lastmess;
  char  k_status[MAXKEYS];
  long  kb_s[MAXKEYS];
  long  kb_u[MAXKEYS];
  long  kd_s[MAXKEYS];
  long  kd_u[MAXKEYS];
  float lspeed;
  float aspeed;
  Move  move;
  void *interfacebuf;
  char  world[WORLD_LEN];
  char  cname[CNAME_LEN];
  char  name[USER_LEN];
  char  email[EMAIL_LEN];
  char  tool[TOOL_LEN];
  u_int8 hit;
  u_int8 density;
  u_int8 weight;
  /* Adding aura (=sphere) of user object... */
  float    aura_center[3]; /* center of sphere */
  float    aura_radius;    /* sphere's radius */
} User;


void USERINIT(void);


#endif /* USER_H */
