#include "global.h"
#include "user.h"
#include "move.h"
#include "audio.h"


/* update times array */
Private
void userUpdateTime2(long sec, long usec, float *lasting, WObject *puser)
{
  *lasting = (float)(sec - puser->ext.user.move.sec) +
    ((float)(usec - puser->ext.user.move.usec) / MILLION);
  if (*lasting < puser->ext.user.move.remaintime) {
    puser->ext.user.move.remaintime -= *lasting;
    puser->ext.user.move.sec = sec;
    puser->ext.user.move.usec = usec;
  }
  else {
    *lasting = puser->ext.user.move.remaintime;
    puser->ext.user.move.remaintime = 0;
    puser->ext.user.move.sec = 0;
    puser->ext.user.move.usec = 0;
  }
}

/* equations system handling permanent motions */
Private
void userChangePermanent(float lasting, WObject *puser)
{
  puser->z -= lasting * GRAVITY;
}

/* equations system handling imposed motions */
Private
void userChangePosition2(float lasting, WObject *puser)
{
  puser->x += lasting * puser->ext.user.move.deltap.v[0];
  puser->y += lasting * puser->ext.user.move.deltap.v[1];
  puser->z += lasting * puser->ext.user.move.deltap.v[2];
  puser->a1 += lasting * puser->ext.user.move.deltaa.v[0];
  puser->a2 += lasting * puser->ext.user.move.deltaa.v[1];
  puser->a3 += lasting * puser->ext.user.move.deltaa.v[2];
}

/* condition to do position modifications */
Private
int userChange(WObject *puser)
{
  puser->ext.user.hit = 0;
  return (puser->ext.user.move.remaintime > 0.0005) ? TRUE : FALSE;
}

/* create an user from the network */
Private
void createUserFromNetwork(WObject *puser, Payload *ppl)
{
  int nprop;
  char geometry[LINESIZE];

  clearKeyTab(puser);
  puser->ext.user.lastmess = 0;
  puser->ext.user.lspeed = EXTUSERLSPEED;	/* 10 */
  puser->ext.user.aspeed = EXTUSERASPEED;	/* 5.0 */
  puser->ext.user.move.remaintime = 0.0;

  /* hack to retrieve the name and the mapping */ 
  setProperty(&(puser->noh), USERPROPHNAME, ppl);
  setProperty(&(puser->noh), USERPROPMAP, ppl);
  setProperty(&(puser->noh), USERPROPMAP1, ppl);
  sprintf(geometry, "box,size=%s,tex_xp=%s,tex_xn=%s", USERGEOMETRY,
	  puser->ext.user.urlface, puser->ext.user.urlback);
  trace(DBG_WMGT, "external user: %s", geometry);

  puser->secs = -1.0;
  puser->changeflag = FALSE;
  puser->soh = SolidParser(geometry);
  updateObjectIn3D(puser);
  setOptionalBuffer(puser);

  updateBB(puser);
  insertObjectIntoGrid(puser);
  mobilelist = addObjectToList(puser, mobilelist);
  for (nprop = 3; nprop < propertiesnumber[puser->noh.type]; nprop++)
    setProperty(&(puser->noh), nprop, ppl);
#ifndef WANT_TCL
  puser->ext.user.interfacebuf = (void*) userLogging(puser->h_name);
  memberJoining(puser->h_name);
#endif
  /* updateMemberWorld(puser->h_name, puser->ext.user.world); */

#define NETACK	/* network ACK = sending fictive Delta (Ph. Dax - 1998) */
#ifdef NETACK
  /* Prevoir implosion des reponses -> random timer */

  if (strcmp(worldname, plocaluser->ext.user.world) == 0) {
    trace(DBG_WMGT, "netack: w/u=%s/%s", worldname, plocaluser->ext.user.world);
    declareDelta(&(plocaluser->noh), USERPROPXY);
    declareDelta(&(plocaluser->noh), USERPROPZ);
    declareDelta(&(plocaluser->noh), USERPROPA1);
    declareDelta(&(plocaluser->noh), USERPROPA2);
    declareDelta(&(plocaluser->noh), USERPROPA3);
  }
  updateObjectIn3D(puser);
#endif
} 

/* update an user on the network */
Private
int updateUserToNetwork(WObject *puser, WObject *polduser)
{
  int change = FALSE;
  
  if ((puser->x != polduser->x) || (puser->y != polduser->y)) {
    declareDelta(&(puser->noh), USERPROPXY); change = TRUE;
  }
  if (ABSF(puser->z - polduser->z) > USERDELTAZ) { /* if d < 2cm => not sent */
    declareDelta(&(puser->noh), USERPROPZ); change = TRUE;
  }
  if (puser->a1 != polduser->a1) {
    declareDelta(&(puser->noh), USERPROPA1); change = TRUE;
  }
  if (puser->a2 != polduser->a2) {
    declareDelta(&(puser->noh), USERPROPA2); change = TRUE;
  }
  if (puser->a3 != polduser->a3) {
    declareDelta(&(puser->noh), USERPROPA3); change = TRUE;
  }
  return change;
}

Private
void userIntersect(WObject *pwoh, WObject *pwohold, WObject *puser)
{
  if (pwoh->noh.type == ROCKETTYPE) {
    /* rocket intersects an user: hit */
    if (puser->ext.user.hit == 0) {
      notice("%s hits %s", pwoh->h_name, puser->h_name);
      puser->ext.user.hit = 1;
      playsound(OUILLESND);
    }
    /* To prevent infinite recursions ! */
    copyPositionAndBB(pwohold, pwoh);
    ObjectDelete(pwoh);
  }
  else if (pwoh->noh.type == BALLTYPE) {
    pwoh->x += BALLSHIFTX; /* ball shifts */
    pwoh->y += BALLSHIFTY; /* ball shifts */
    update_object(pwoh, pwohold);
  }
  else {
    /* user intersects an other user: slide */
#ifdef USERGOTHROUGH
    pwoh->x += USERGOTHROUGH; /* step to shift */
    pwoh->y += USERGOTHROUGH; /* step to shift */
    updateObjectIn3D(pwoh);
    updateBB(pwoh);
#else
    copyPositionAndBB(pwohold, pwoh);
#endif
  }
}

Public
void userWallIntersect(WObject *puser, WObject *polduser, V3 *norm)
{
  float Ax, Ay, Bx, By;
  float Vx, Vy, n;

  Vx = norm->v[0];
  Vy = norm->v[1];
  Ax = polduser->x;
  Ay = polduser->y;
  Bx = puser->x;
  By = puser->y;

  if ((Ax != Bx) || (Ay != By)) {
    n = Vx * Vx + Vy * Vy;
    puser->y = ((Vx * Vy) * (Ax - Bx) + Vy * Vy * Ay + Vx * Vx * By) / n;
    puser->x = ((Vx * Vy) * (Ay - By) + Vx * Vx * Ax + Vy * Vy * Bx) / n;

    /* Changed user position => need to update BBs */
    updateObjectIn3D(puser);
    updateBB(puser);
  }
  if (Solid_intersect_Walls(&(puser->bb_center), &(puser->bb_size), norm)) {
    copyPositionAndBB(polduser, puser);
  }
}

Private
void userMethode0(WObject *puser, long sec, long usec)
{
  if (generalMethodList[BULLETCREAT][ROCKETTYPE].method != NULL)
    generalMethodList[BULLETCREAT][ROCKETTYPE].method(puser, sec, usec);
}

Private
void userMethode1(WObject *puser, long sec, long usec)
{
  if (generalMethodList[DARTCREAT][ROCKETTYPE].method != NULL)
    generalMethodList[DARTCREAT][ROCKETTYPE].method(puser, sec, usec);
}

static float fovy = USERFOVY;
static float near = USERNEAR;

Private
void userMethode2(WObject *puser, long sec, long usec)
{
  fovy = USERFOVY;
  near = USERNEAR;
  ZLib_setCameraProjection(fovy, near, USERFAR);
}

Private
void userMethode3(WObject *puser, long sec, long usec)
{
  fovy -= 1.0;
  if (fovy <= 1.0) fovy = 1.0;
  near += 0.025;
  if (near >= 1.0) near = 1.0;
  ZLib_setCameraProjection(fovy, near, USERFAR);
}

Private
void userMethode4(WObject *puser, long sec, long usec)
{
  fovy += 1.0;
  if (fovy >= 45.0) fovy = 45.0;
  near -= 0.025;
  if (near <= 0.0) near = 0.0;
  ZLib_setCameraProjection(fovy, near, USERFAR);
}

/* user functions initialization */
Public
void initUserFuncList(void)
{
  generalFuncList[USERTYPE].createFromNetwork = createUserFromNetwork;
  generalFuncList[USERTYPE].change = userChange;
  generalFuncList[USERTYPE].updateToNetwork = updateUserToNetwork;
  generalFuncList[USERTYPE].updateTime = userUpdateTime2;
  generalFuncList[USERTYPE].changePosition = userChangePosition2;
  generalFuncList[USERTYPE].whenIntersect = userIntersect;
  generalFuncList[USERTYPE].whenWallIntersect = userWallIntersect;
  generalFuncList[USERTYPE].changePermanent= userChangePermanent;

  propertiesnumber[USERTYPE] = USERPROPERTIES;

  setFuncList[USERPROPXY][USERTYPE].pf = set_xy;
  setFuncList[USERPROPZ][USERTYPE].pf = set_z;
  setFuncList[USERPROPA1][USERTYPE].pf = set_a1;
  setFuncList[USERPROPA2][USERTYPE].pf = set_a2;
  setFuncList[USERPROPA3][USERTYPE].pf = set_a3;
  setFuncList[USERPROPHNAME][USERTYPE].pf = set_hname;
  setFuncList[USERPROPMAP][USERTYPE].pf = set_mapface;
  setFuncList[USERPROPMAP1][USERTYPE].pf = set_mapback;
  setFuncList[USERPROPMSG][USERTYPE].pf = set_msg;
  setFuncList[USERPROPWORLD][USERTYPE].pf = set_world;

  getFuncList[USERPROPXY][USERTYPE].pf = get_xy;
  getFuncList[USERPROPZ][USERTYPE].pf = get_z;
  getFuncList[USERPROPA1][USERTYPE].pf = get_a1;
  getFuncList[USERPROPA2][USERTYPE].pf = get_a2;
  getFuncList[USERPROPA3][USERTYPE].pf = get_a3;
  getFuncList[USERPROPHNAME][USERTYPE].pf = get_hname;
  getFuncList[USERPROPMAP][USERTYPE].pf = get_mapface;
  getFuncList[USERPROPMAP1][USERTYPE].pf = get_mapback;
  getFuncList[USERPROPMSG][USERTYPE].pf = get_msg;
  getFuncList[USERPROPWORLD][USERTYPE].pf = get_world;

  defmaxlasting[USERTYPE] = USERDEFMAXLAST;	/* 15 ms */

  strcpy(generalMethodList[BULLETCREAT][USERTYPE].name, "");
  generalMethodList[BULLETCREAT][USERTYPE].method = userMethode0;
  strcpy(generalMethodList[DARTCREAT][USERTYPE].name, "");
  generalMethodList[DARTCREAT][USERTYPE].method = userMethode1;
  strcpy(generalMethodList[FOVYORIGINAL][USERTYPE].name, "");
  generalMethodList[FOVYORIGINAL][USERTYPE].method = userMethode2;
  strcpy(generalMethodList[FOVYLESS][USERTYPE].name, "");
  generalMethodList[FOVYLESS][USERTYPE].method = userMethode3;
  strcpy(generalMethodList[FOVYGREATER][USERTYPE].name, "");
  generalMethodList[FOVYGREATER][USERTYPE].method = userMethode4;
}
