#include "global.h"
#include "parse.h"


/* lift parser */
Private
void liftParser(char *l, WObject *plift)
{
  char *w;
  Fileline str;

  l = parseName(l, plift->ext.lift.named, plift->ext.lift.name);
  w = parseFileLine(l);
  w = parsePosition(w, plift);
  plift->ext.lift.org_l = atoi(w); w = strtok(NULL, SEP);
  plift->ext.lift.levels = atoi(w); w = strtok(NULL, SEP);
  plift->ext.lift.height = (float) atof(w); w = strtok(NULL, SEP);
  plift->ext.lift.speed = (float) atof(w); w = strtok(NULL, SEP);
  strcpy(str, w);
  createNetObjectFromString(&(plift->noh), str, PERMANENT);
  w = strtok(NULL, SEP);
  plift->soh = SolidParser(w);  
  if (plift->ext.lift.named)
    setWObjectName(plift, plift->ext.lift.name);
}

Private
void liftCreate(WObject *plift)
{
  plift->changeflag = FALSE;
  setOptionalBuffer(plift);
  updateObjectIn3D(plift);
  updateBB(plift);
  mobilelist = addObjectToList(plift, mobilelist);
  insertObjectIntoGrid(plift);
} 

/* lift creation from a file */
Private
void createLiftFromFile(Fileline l)
{
  WObject *plift;

  plift = (WObject*) malloc(sizeof(WObject));
  memset(plift, 0, sizeof(WObject));    
  plift->noh.type = LIFTTYPE;
  liftParser(l, plift);
  strcpy(plift->h_name, LIFTNAME);
  liftCreate(plift);
}

/* lift creation from the network */
Private
void createLiftFromNetwork(WObject *plift, Payload *ppl)
{
  strcpy(plift->h_name, LIFTNAME);
  liftCreate(plift);
  setAllProperties((NetObject *) plift, ppl);
} 

/* lift update towards the network */
Private
int updateLiftToNetwork(WObject *plift, WObject *poldlift)
{
  int change = FALSE;
  
  if (plift->z != poldlift->z) {
    declareDelta(&(plift->noh), LIFTPROPZ);
    trace(DBG_WMGT, "declareDelta: z=%f", plift->z);
    poldlift->z = plift->z;
    change = TRUE;
  }
  return change;
}

/* lift up */
Private
void liftUp(WObject *plift, long sec, long usec)
{
  /*
     int level;
     level = ((plift->z - plift->ext.lift.org_h) / plift->ext.lift.height) +
     plift->ext.lift.org_l;
   */
  plift->ext.lift.des_height = plift->z + plift->ext.lift.height;
  trace(DBG_WMGT, "liftUp: z=%f des_height=%f", plift->z, plift->ext.lift.des_height);
}

/* lift down */
Private
void liftDown(WObject *plift, long sec, long usec)
{
  plift->ext.lift.des_height = plift->z - plift->ext.lift.height;
  trace(DBG_WMGT, "liftDown: z=%f des_height=%f", plift->z, plift->ext.lift.des_height);
}

/* object intersects: like step */
Private
void liftIntersect(WObject *pwoh, WObject *pwohold, WObject *plift)
{
  pwoh->z += STEPSIZE;
  trace(DBG_WMGT, "liftInter: obj=%f lift=%f", pwoh->z, plift->z);
  updateObjectIn3D(pwoh);
  updateBB(pwoh);
}

Private
int liftChange(WObject *plift)
{
  return (plift->ext.lift.des_height > plift->z + LIFTINCRZ) ||
    (plift->ext.lift.des_height < plift->z - LIFTINCRZ);
}

Private
void liftUpdateTime(long sec, long usec, float *lasting, WObject *plift)
{
  float ls = (plift->ext.lift.des_height - plift->z) / plift->ext.lift.speed;
  
  *lasting = (ls < 0.0) ? -ls : ls;
}

Private
void liftChangePosition(float lasting, WObject *plift)
{
  if (plift->ext.lift.des_height < plift->z)
    plift->z -= lasting * plift->ext.lift.speed;
  else
    plift->z += lasting * plift->ext.lift.speed;
  /* trace(DBG_WMGT, "liftChangePosition: plift->z=%f des_height=%f", plift->z, plift->ext.lift.des_height); */
}

/* lift functions initialization */
Public
void initLiftFuncList(void)
{
  generalFuncList[LIFTTYPE].createFromFileline = createLiftFromFile;
  generalFuncList[LIFTTYPE].createFromNetwork = createLiftFromNetwork;  
  generalFuncList[LIFTTYPE].change = liftChange;
  generalFuncList[LIFTTYPE].updateTime = liftUpdateTime;
  generalFuncList[LIFTTYPE].changePosition = liftChangePosition;
  generalFuncList[LIFTTYPE].updateToNetwork = updateLiftToNetwork;
  generalFuncList[LIFTTYPE].whenIntersect = liftIntersect;

  propertiesnumber[LIFTTYPE] = LIFTPROPERTIES;

  setFuncList[LIFTPROPZ][LIFTTYPE].pf = set_z;
  setFuncList[LIFTPROPHNAME][LIFTTYPE].pf = set_hname;
  getFuncList[LIFTPROPZ][LIFTTYPE].pf = get_z;
  getFuncList[LIFTPROPHNAME][LIFTTYPE].pf = get_hname;

  strcpy(generalMethodList[0][LIFTTYPE].name, "Up");
  generalMethodList[0][LIFTTYPE].method = liftUp;
  strcpy(generalMethodList[1][LIFTTYPE].name, "Down");
  generalMethodList[1][LIFTTYPE].method = liftDown;

  defmaxlasting[LIFTTYPE] = LIFTDEFMAXLAST;
}
