#include "global.h"
#include "col.h"


/* renvoie une constante pour decrire l'etat de l'intersection
 * des deux Bounding Boxs */
int interBBs (V3 center1, V3 size1, V3 center2, V3 size2)
{
  float dcx, dcy, dcz, sx1, sx2, sy1, sy2, sz1, sz2;

  dcx = ABSF(center2.v[0] - center1.v[0]);
  dcy = ABSF(center2.v[1] - center1.v[1]);
  dcz = ABSF(center2.v[2] - center1.v[2]);
  sx1 = ABSF(size1.v[0]);
  sx2 = ABSF(size2.v[0]);
  sy1 = ABSF(size1.v[1]);
  sy2 = ABSF(size2.v[1]);
  sz1 = ABSF(size1.v[2]);
  sz2 = ABSF(size2.v[2]);
  
  if (dcx >= sx1 + sx2  ||  dcy >= sy1 + sy2  ||  dcz >= sz1 + sz2)
    return INTER_OUT;	/* doesn't intersect */
  if (dcx + sx1 <= sx2  &&  dcy + sy1 <= sy2  && dcz + sz1 <= sz2)
    return INTER_1IN2;
  if (dcx + sx2 <= sx1  &&  dcy + sy2 <= sy1  &&  dcz + sz2 <= sz1)
    return INTER_2IN1;
  return INTER_INTERSECT;
}

/* renvoie la liste des pointeurs sur les objets touchant
 * la case des grilles intersectees par la BB englobante des 2 objets
 */
ObjectList vicinityObject(WObject *pwoh, WObject *pwohold)
{
  int i, x, y, z;
  int imin[3], imax[3];
  float pmin[3], pmax[3];
  ObjectList objectlist = NULL;

  for (i = 0; i < 3; i++) {
    pmin[i] = MINI(pwoh->bb_center.v[i] - pwoh->bb_size.v[i], 
		  pwohold->bb_center.v[i] - pwohold->bb_size.v[i]);
    pmax[i] = MAXI(pwoh->bb_center.v[i] + pwoh->bb_size.v[i], 
		  pwohold->bb_center.v[i] + pwohold->bb_size.v[i]);
  }
  calculateCoordinatesIntoGrid(pmin, imin);
  calculateCoordinatesIntoGrid(pmax, imax);
  for (x = imin[0]; x <= imax[0]; x++)
    for (y = imin[1]; y <= imax[1]; y++)
      for (z = imin[2]; z <= imax[2]; z++)
        objectlist = addObjectListToList(grid[x][y][z], pwoh, objectlist);
  clearIspointedFlag(objectlist);
  return objectlist;
}  

/* general function to handle intersections */
Public
void generalIntersect(WObject *pwoh, WObject *pwohold, ObjectList vicinitylist)
{
  WObject *pother;
  ObjectList tmplist = vicinitylist;
  int detectloop = 0;
  V3 norm;
  
  /* walls */
  if (Solid_intersect_Walls(&(pwoh->bb_center), &(pwoh->bb_size), &norm)) {
    if (generalFuncList[pwoh->noh.type].whenWallIntersect != NULL) {
      generalFuncList[pwoh->noh.type].whenWallIntersect(pwoh, pwohold, &norm);
    }
    else {
      copyPositionAndBB(pwohold, pwoh);
    }
    return;
  }
 
  while (tmplist) {
    pother = tmplist->pobject;
    if (interBBs(pwoh->bb_center, pwoh->bb_size,
                 pother->bb_center, pother->bb_size) != INTER_OUT &&
        interBBs(pwohold->bb_center, pwohold->bb_size,
                 pother->bb_center, pother->bb_size) == INTER_OUT) {
      /* current object intersects and old object doesn't intersect */

      if (generalFuncList[pother->noh.type].whenIntersect != NULL) {
        generalFuncList[pother->noh.type].whenIntersect(pwoh, pwohold, pother);
        tmplist = vicinitylist;
      }
      else if (pother->noh.type == AOITYPE) {
        /* 2 cases: local avatar or another mobile object */
        if (pwoh == plocaluser) {
          if (currentAoi != &(pother->ext.aoi))
            enterAoi(&(pother->ext.aoi)); /* avatars: change mcast address */
        }
        else {
          /* others mobile objects: problem of property transfert */
          notice("Object %s enters %s (ie. %s)",
                  pwoh->h_name, pother->ext.aoi.id, pother->ext.aoi.chan_str);
        }
        break;     /* avoids the folowing warning */
      }
    }
    else
      tmplist = tmplist->next;
  }
}

/* projete le mouvement de l'objet mobile parallelement a l'objet statique
 * quand la normale sera fournie par la 3D
 */
void projectMovementOnObject(WObject *pmb_object, WObject st_object)
{
  /* TODO */
  /*********
  float dx, dy, dz;
  float sp;
  V3 normal;

  dx = pmb_object->x - pmb_object->oldpos.v[0];
  dy = pmb_object->y - pmb_object->oldpos.v[1];
  dz = pmb_object->z - pmb_object->oldpos.v[2];

  calculateNormalObjectToObject(*pmb_object, st_object, &normal);
  sp =  normal.v[0] * dx + normal.v[1] * dy + normal.v[2] * dz;
  pmb_object->x = pmb_object->x - sp * normal.v[0];
  pmb_object->y = pmb_object->y - sp * normal.v[1];
  pmb_object->z = pmb_object->z - sp * normal.v[2];
  *********/
  /* Thanxs to Rouss */
}

/* 3D stub for solids intersections */
int Solid_intersect_2D(Solid s_handle1, Solid s_handle2)
{
  return INTER_INTERSECT;
}
