#include "global.h"
#include "parse.h"


/* cauldron parser  */
Private
void cauldronParser(char *l, WObject *pcauldron)
{
  char *w;

  w = parseFileLine(l);
  w = parsePosition(w, pcauldron);
  pcauldron->soh = SolidParser(w);
}

/* initialisation a partir d'une ligne de fichier */
Private
void createCauldronFromFile(Fileline l)
{
  WObject *pcauldron;

  pcauldron = (WObject*) malloc(sizeof(WObject));
  memset(pcauldron, 0, sizeof(WObject));    
  pcauldron->noh.type = CAULDRONTYPE;
  cauldronParser(l, pcauldron);
  strcpy(pcauldron->h_name, CAULDRONNAME);
  updateObjectIn3D(pcauldron);
  setOptionalBuffer(pcauldron);
  updateBB(pcauldron);
  stilllist = addObjectToList(pcauldron, stilllist);
  insertObjectIntoGrid(pcauldron);
} 

/* creation: see ball */
Private
void cauldronMethode0(WObject *pcauldron, long sec, long usec)
{
  if (generalMethodList[BALLCREAT][BALLTYPE].method != NULL)
    generalMethodList[BALLCREAT][BALLTYPE].method(pcauldron, sec, usec);
}

/* object intersects: up or down */
Private
void cauldronIntersect(WObject *pwoh, WObject *pwohold, WObject *pcauldron)
{
  if (pwoh->noh.type != USERTYPE)
    pwoh->z -= pcauldron->bb_size.v[2] / 4;
  else
    pwoh->z += CAULDRONDELTAZ;
  updateObjectIn3D(pwoh);
  updateBB(pwoh);
}

/* cauldron functions initialization */
Public
void initCauldronFuncList(void)
{
  generalFuncList[CAULDRONTYPE].createFromFileline = createCauldronFromFile;
  generalFuncList[CAULDRONTYPE].whenIntersect = cauldronIntersect;
  
  propertiesnumber[CAULDRONTYPE] = 0;

  strcpy(generalMethodList[0][CAULDRONTYPE].name, "Ball");
  generalMethodList[0][CAULDRONTYPE].method = cauldronMethode0;
}
