#include "global.h"
#include "parse.h"
#include "names.h"


/* button parser */
Private
void buttonParser(char *l, WObject *pbutton)
{
  char *w;
  Fileline str;

  w = parseFileLine(l);
  w = parsePosition(w, pbutton);
  pbutton->ext.button.state = atoi(w); w = strtok(NULL, SEP);
  pbutton->ext.button.obj_name = strdup(w); w = strtok(NULL, SEP);
  pbutton->ext.button.method0 = atoi(w); w = strtok(NULL, SEP);
  pbutton->ext.button.method1 = atoi(w); w = strtok(NULL, SEP);
  strcpy(str, w);
  createNetObjectFromString(&(pbutton->noh), str, PERMANENT);
  w = strtok(NULL, SEP);
  pbutton->soh = SolidParser(w);  
}

/* create a button from the network */
Private
void createButtonFromNetwork(WObject *pbutton, Payload *ppl)
{
  strcpy(pbutton->h_name, BUTTONNAME);
  pbutton->changeflag = FALSE;
  setOptionalBuffer(pbutton);
  updateObjectIn3D(pbutton);
  updateBB(pbutton);
  mobilelist = addObjectToList(pbutton, mobilelist);
  insertObjectIntoGrid(pbutton);
  setAllProperties((NetObject *) pbutton, ppl);
} 

/* create a button from a fileline */
Private
void createButtonFromFile(Fileline l)
{
  WObject *pbutton;

  pbutton = (WObject*) malloc(sizeof(WObject));
  memset(pbutton, 0, sizeof(WObject));    
  pbutton->noh.type = BUTTONTYPE;
  buttonParser(l, pbutton);
  strcpy(pbutton->h_name, BUTTONNAME);
  pbutton->changeflag = FALSE;
  updateObjectIn3D(pbutton);
  setOptionalBuffer(pbutton);
  updateBB(pbutton);
  mobilelist = addObjectToList(pbutton, mobilelist);
  insertObjectIntoGrid(pbutton);
} 

/* update a button towards the network */
Private
int updateButtonToNetwork(WObject *pbutton, WObject *pbuttonold)
{
  int change = FALSE;
  
  if (pbutton->ext.button.state != pbuttonold->ext.button.state) {
    declareDelta(&(pbutton->noh), BUTTONPROPSTATE);
    change = TRUE;
  }
  return change;
}

Private
void buttonSwitch(WObject *pbutton, long sec, long usec)
{
  WObject *premote;
  struct timeval te;
  int method;
  
  if (pbutton->ext.button.state == 0)
    method = pbutton->ext.button.method0;
  else
    method = pbutton->ext.button.method1;
  pbutton->ext.button.state = 1 - pbutton->ext.button.state;
  SolidSetFrame(pbutton->soh, pbutton->ext.button.state);

  if ((premote = getWObjectFromName(pbutton->ext.button.obj_name)) != NULL) {
    gettimeofday(&te, NULL);
    if ((method < TYPESNUMBER) &&
	(generalMethodList[method][premote->noh.type].method != NULL))
      generalMethodList[method]
	[premote->noh.type].method(premote,te.tv_sec, te.tv_usec);
    else
      warning("Button: object named %s has no method %d",
	      pbutton->ext.button.obj_name, method);
  }
  else
    warning("Button: no object named %s", pbutton->ext.button.obj_name);
}

/* object intersects: stop */
Private
void buttonIntersect(WObject *pwoh, WObject *pwohold, WObject *pbutton)
{
  copyPositionAndBB(pwohold, pwoh);
  buttonSwitch(pbutton, 0, 0);
}

Private
int buttonChange(WObject *pbutton)
{
  return FALSE;
}

Private
void buttonUpdateTime(long sec, long usec, float *lasting, WObject *pbutton)
{
  *lasting = 0.0;
}

Private
void buttonChangePosition(float lasting, WObject *pbutton)
{
}

Public
void set_bstate(WObject *pbutton, Payload *ppl)
{
  WObject *pbuttonold;
  
  pbuttonold = copy_object(pbutton);
  scanPayload(ppl, "d", &(pbutton->ext.button.state));
  update_object(pbutton, pbuttonold);
}

Public
void get_bstate(WObject *pbutton, Payload *ppl)
{
  writePayload(ppl, "d", pbutton->ext.button.state);
}

/* button functions initialization */
Public
void initButtonFuncList(void)
{
  generalFuncList[BUTTONTYPE].createFromFileline = createButtonFromFile;
  generalFuncList[BUTTONTYPE].createFromNetwork = createButtonFromNetwork;  
  generalFuncList[BUTTONTYPE].change = buttonChange;
  generalFuncList[BUTTONTYPE].updateTime = buttonUpdateTime;
  generalFuncList[BUTTONTYPE].changePosition = buttonChangePosition;
  generalFuncList[BUTTONTYPE].updateToNetwork = updateButtonToNetwork;
  generalFuncList[BUTTONTYPE].whenIntersect = buttonIntersect;

  propertiesnumber[BUTTONTYPE] = BUTTONPROPERTIES;

  setFuncList[BUTTONPROPSTATE][BUTTONTYPE].pf = set_bstate;
  getFuncList[BUTTONPROPSTATE][BUTTONTYPE].pf = get_bstate;

  strcpy(generalMethodList[0][BUTTONTYPE].name, "Switch");
  generalMethodList[0][BUTTONTYPE].method = buttonSwitch;

  defmaxlasting[BUTTONTYPE] = BUTTONDEFMAXLAST;
}
