#include "global.h"
#include "parse.h"
#include "audio.h"
#include "channel.h"
#include "net_global.h"

/* Note:
 * Intersection with AoI object must be manage by VREng general intersection
 * procedure (see move.c).  That's why AoI does not need any 
 * "whenIntersect" function.  Therefore, the procedure initAoiFuncList 
 * below sets this member to NULL.  The main reason for this is that AoI
 * are objects we want to be able to go through. The only event we are 
 * interested in is when a collision occur.
 */

Aoi * currentAoi;  /* Points to current AoI we're in */


/* AoI parser */
Private
void aoiParser(char *l, WObject *paoi)
{
  char *w;

  w = parseFileLine(l);
  w = parsePositionXYZ(w, paoi);
  strcpy(paoi->ext.aoi.id, w); w = strtok(NULL, SEP);
  strcpy(paoi->ext.aoi.chan_str, w); w = strtok(NULL, SEP);
  paoi->soh = SolidParser(w);
  trace(DBG_WMGT, "AoI %s at ( %.2f , %.2f , %.2f )",
	    paoi->ext.aoi.id, paoi->x, paoi->y, paoi->z);
}

/* AoI creation from file */
Private
void createAoiFromFile(Fileline l)
{
  WObject *paoi;

  paoi = (WObject*) malloc(sizeof(WObject));
  memset(paoi, 0, sizeof(WObject));    
  paoi->noh.type = AOITYPE;
  aoiParser(l, paoi);
  strcpy(paoi->h_name, AOINAME);
  updateObjectIn3D(paoi);
  setOptionalBuffer(paoi);
  /* AoI are not visible stuf */
#define VISIBLE_AOI /* to be uncommented if hard debugging time */
#ifndef VISIBLE_AOI
  SolidSetVisibilty(paoi->soh, FALSE);
#endif
  updateBB(paoi);
  stilllist = addObjectToList(paoi, stilllist);
  insertObjectIntoGrid(paoi);
} 

/*
 * Function enterAoi:
 *
 * Perform action to be done while entering a new Area of Interest:
 *  - leaving previous one with quitAoi() call
 *  - initializing the network on new AoI's mcast chan_str
 *  - initializing the only mobile object we know for now in 
 *      this AoI: local user's avatar
 *
 * Unique callee is generalIntersect() (move.c) 
 */
Public
void enterAoi(Aoi * newAoi)
{
  Channel *pchan;
  
  notice("Local user \"%s\" enters %s (ie. %s)",
	  plocaluser->h_name, newAoi->id, newAoi->chan_str);
  
  /* Quit current AoI (network shutdown) */
  quitAoi();

  /* Make new AoI the current one */
  currentAoi = newAoi;

  /* Initializing network with new AoI's mcast group (cf. channel.c vreng.c) */
  if ((pchan = ChannelAlloc()) == NULL)
    return;
  if ((cnt_fd = ChannelOpen(pchan, currentAoi->chan_str, &tab_fd)) <= 0)
    return;

  /* Initializing local user's avatar */
  createNetObject((NetObject *) plocaluser, VOLATILE);
  updateObjectIn3D(plocaluser);
  /* plocaluser->secs = -1.0; /* Do not remove gravity... (???) */
  plocaluser->ext.user.move.remaintime = 0.0;
  updateBB(plocaluser);
  mobilelist = addObjectToList(plocaluser, mobilelist);
  insertObjectIntoGrid(plocaluser);

  /* Showing other VREng processes we are there (no latency) */
  declareCreation(&(plocaluser->noh));

  /* To do here: broadcast a query on new AoI to see who is there with
   * minimal latency.  In the current solution, we discover
   * other mobile objets in the new AoI only thanks to heart beats,
   * which may be quite long for AoI uses (however it may be
   * ok when entering a World).
   */

  /* Interface stuff */
  updateMemberWorld(plocaluser->h_name, worldname);
  updateObjectIn3D(plocaluser);
  updateCameraFromObject(plocaluser);
}

/*
 * Function quitAoi
 *
 * Perform actions to be done while leaving an Area of Interest:
 *  - Remove all mobile object from network (leaving only static ones)
 *  - Shutdown the network
 *
 * Unique callee is enterAoi() ... (see above)
 */
Public
void quitAoi(void)
{
  ObjectList list;   /* a local var for code reading convienience */

  /* Freeing only mobile object we're responsible for */
  for (list = mobilelist; list; ) {
    ObjectList next = list->next; /* handling next obj while freeing list */

    /* Skipping local user object (as we do not want to remove it) */
    if (list->pobject == plocaluser) {
      list = next;
      continue;
    }
    /* Deleting mobile object from grid */
    deleteObjectFromGrid(list->pobject);

    /* Closing 3D */
    SolidDelete(list->pobject->soh);

    /* Closing interface */
    if (list->pobject->noh.type == USERTYPE) {
      userLoggingOut(list->pobject->ext.user.interfacebuf);
      updateMemberWorld(list->pobject->ext.user.interfacebuf, NULL);
    }
    selectedObjectDeletion(list->pobject->soh);

    /* Closing network part of object */
    trace(DBG_WMGT, "quitaoi %s", list->pobject->h_name);
    if (!(list->pobject->noh.permanent))
      declareDeletion(&(list->pobject->noh));
    deleteNetObject((NetObject*) (list->pobject));

    /* Perform some clean up */
    memset(list->pobject, 0, sizeof(WObject)); /* Being very clean ! */
    free(list->pobject);
    free(list);

    /* Managing loop */
    list = next;
  }
  mobilelist = NULL;

  /* Explicit declaration to network so that there is minimal latency
     on other VREng processes to see user leaving previous AoI */
  declareDeletion(&(plocaluser->noh));
  deleteNetObject(&(plocaluser->noh));

  /* Ok to close multicast socket now as we do not need it anymore */
  ChannelClose(channels_list);
}

Private
void aoiIntersect(WObject *pwoh, WObject *pwohold, WObject *paoi)
{
  /* 2 cases: local avatar or another mobile object */
  if (pwoh == plocaluser) {
    if (currentAoi != &(paoi->ext.aoi))
      enterAoi(&(paoi->ext.aoi)); /* avatars: change multicast address */
  }
  else {
    /* others mobile objects: problem of property transfert */
    notice("Object %s enters %s (ie. %s)",
            pwoh->h_name, paoi->ext.aoi.id, paoi->ext.aoi.chan_str);
  }
}

/* AoI functions initialization  */
Public
void initAoiFuncList(void)
{
  currentAoi = 0;

  generalFuncList[AOITYPE].createFromFileline = createAoiFromFile;
  generalFuncList[AOITYPE].whenIntersect = NULL;

  propertiesnumber[AOITYPE] = 0;
}

