#ifndef NET_SHM_H
#define NET_SHM_H

#include "net_global.h"
#include "net_decls.h"
#include "payload.h"
  

/*** Mcast ***/
/* int createMcastRecvSocket(Channel *, u_int16); */
int createMcastRecvSocket(Channel *, struct sockaddr_in *);
int createMcastSendSocket(u_int8);
int setLoopback(int, u_int8);
void closeMcastSocket(Channel *);

/*** Dates ***/
double diffDates(struct timeval, struct timeval);
void addToDate(struct timeval *, double);
void resetDates(Property *);

/*** Pkt ***/
/* int sendPacket(const struct sockaddr_in *, const Payload *); */
/* int recvPacket(int, struct sockaddr_in *, const Payload *); */
int sendRTCPPacket(Channel *, struct sockaddr_in *, u_int8);
int recvRTCPPacket(Channel *, struct sockaddr_in *, u_int8 *, int);

/*** Time ***/
/* struct timeval unixtime(); */
/* u_int32 ntptime(struct timeval); */
/* ntp64 ntp64time(struct timeval); */

/*** Random ***/
unsigned int random32(int type);

/*** Gestion des noid/headers ***/
NetObject* getNetObjectId(NetObjectId);
/* returns NULL if object doesn't exist
 * header vers noid se fait en lisant directement dans la struct 
 * Le nommage se fait par createNetObject ou createNetObjectFromString.
 */

void insertNetObject(NetObject *);

int equalNetObjectId(NetObjectId, NetObjectId);
/* returns 0 if different, other if equal */

char * nameByID(NetObjectId);

/*** Memoire partagee (exports vers w_mgt) ***/
void createNetObject(NetObject *, u_int8);
/* Cree un nouveau nom d'objet et baptise ainsi l'objet 
 * Des la sortie, on peut faire un getNetObjectId
 * et deckareDelta. 
 * Il est souhaitable (perfs) de faire un declareCreation
 * des que toutes les proprietes sont initialisees.
 */

void createNetObjectFromString(NetObject *, const char*, u_int8);
/* Fabrique un nom d'objet a partir de la chaine et baptise ainsi
 * l'objet. Des la sortie, on peut faire un getNetObjectId et
 * declareDelta. 
 * Un declareCreation sur un tel objet entraine un fatal().
 */

void deleteNetObject(NetObject *);
/* Detruit le nom d'objet. Apres cet appel, un getNetObjectId et un
 * declarexxxx echoueront. A faire absolument avant le free()
 * final.
 */

void declareCreation(NetObject *);
/* Devrait (perfs) etre appelee apres le nommage d'un nouvel objet
 * (createNetObject) et l'initialisation des proprietes.  
 */

void declareDelta(NetObject *, u_int8 prop_id );
/* A appeler apres changement de valeur de la propriete */ 

void declareDeletion(NetObject *);
/* A appeler quand on veut detruire l'objet, juste avant de faire
 * un deleteNetObject puis le free() final.
 */

void deleteObject(NetObject *);
/* obsolete, alias sur la precedente */

/*** Gestion (exports vers interface) ***/

int networkTimeout();
/* Reveille le reseau suite a un timeout.
 * On renvoie le delai apres lequel on veut etre reveille (en ms)
 */

void incoming(int);
/* Reveille le reseau suite a l'arrivee de donnees sur le fd "on"
 */


#endif /* NET_SHM_H */

