/*
   File     : widget3D.c
   Author   : Lionel ULMER
   Creation : 04/12/96
   
   Fichier contenant les fonctions de gestion de la zone 3D: que
   faire en cas d'appui sur le boutton, de click souris, d'expose,
   etc...
*/

#include "global.h"

/* Fichiers ncessaire  Xt */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/MenuButton.h>
/* Fichiers d'include public des widgets utiliss */
/* Includes prement X */
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#ifdef MOTIF
#include <Xm/XmAll.h>
#include "GLwMDrawA.h"
#else
#include "GLwDrawA.h"
#endif


/* Fichier des variables globales du module Interface */
#include "initui.h"
#include "initfuncs.h"
#include "supportfuncs.h"
#include "widget.h"


/* Variables globales */
XEvent popev;			/* L'evt qui a provoqu l'apparition du popup */
int grabactive = 0;
int firstrs = 0;
int glInitialized = GL_FALSE;
GLXContext glxc;
XVisualInfo *glvisual;
GC gcwhite3D, gcblack3D;	/* Graphic Context to display images 3D */
Solid csobject, pobject;	/* selectioned object */
Widget popm, popline, popbutton[BUTTONSNUMBER];


void resize3D(Widget w, XtPointer clientData, XtPointer callData)
{
  GLwDrawingAreaCallbackStruct *resize;
  
  if (glInitialized) {
    resize = (GLwDrawingAreaCallbackStruct *) callData;
    RenderSetWindow(resize->width, resize->height);
  }
}

Public
void init3D(Widget w, XtPointer clientData, XtPointer callData)
{
  /* here, we call ZLib initialization */
  glInitialized = GL_TRUE;
  GLwDrawingAreaMakeCurrent(w, glxc);
  RenderInit(gl_quality);
  zlibinit = 1;
  RenderSetWindow(width3D, height3D);
}

void expose3D(Widget w, XtPointer clientData, XtPointer callData)
{
  /* nothing to do */
}

/* Fonction redraw3D : fait le redraw de la zone 3D en cas d'expose
   (ie quand la zone est de nouveau visible aprs un obscurcissement).
   Pour l'instant, redessine tout. */
void redraw3D(Widget w,XEvent *ev,String *s,Cardinal *c)
{
  XEvent ne;
  
  /* S'il n'y a encore rien  afficher, retourne. Servira aussi si le frame
     rate > 10 images secondes, plus la peine de grer les Exposes */
  if (todisp)
    return ;
  
  trace(DBG_W3D, "expose");
  /* while events are there */
  while (XtAppPending(appContext) == XtIMXEvent) {
    /* take the event on the top of stack */
    XtAppPeekEvent(appContext,&ne);
    /* if it's an expose for this window */
    if ((ev->type == ne.type) && (ev->xany.window == ne.xany.window))
      /* destroy it */
      XtAppNextEvent(appContext,&ne);
    else
      break;
  }
  /* Draw rectangle */
  XDrawRectangle(display, XtWindow(w), gcwhite3D, startX-1, startY-1,
		 width3D+1, height3D+1);
}

/* called when we enter or exit from the window (to fix bugs) */
void focusWin3D(Widget w, XEvent *ev, String *s, Cardinal *c)
{
  trace(DBG_W3D, "Focus: %s", *s);
  if (*s[0] == 'e') {
    /* enter into the widget */
    if (grabactive) {
      XtUngrabKeyboard(w, CurrentTime);
      grabactive = 0;
    }
    XAutoRepeatOff(display);
  }
}

/* called when button 1 or 3 of the mouse changes status in the window */
void button13D(Widget w, XEvent *ev, String *s, Cardinal *c)
{
  XButtonEvent e;
  char *blist, *name, buf[256], *pm = "popumenu";
  int x, y, i, dmenu;
  
  /* get coord */
  e = ev->xbutton;
  x = e.x;
  y = e.y;

  if (*s[0] == 'u') {	/* Button 1 Up */
    cpopup = (cpopup+1) % 256;
    trace(DBG_W3D, "Button up: %d %d %d %d", e.x,e.y,x,y);
    cbutton = 0;
  }
  else { /* display menu ? */
    dmenu = 0;
    /* required for button 3 popup */
    pobject = csobject;
    csobject = RenderGetSelection(x, y);
    trace(DBG_W3D, "Current: %p Previous: %p", csobject, pobject);

    if (*s[0] == 'd') {
      if ((cbutton == 1) && (ev->xany.send_event == True)) {
	cbutton = 0;
	dmenu = 1;
      }
      else {	/* Button 1 down */
	trace(DBG_W3D, "Button down: %d %d %d %d", e.x,e.y,x,y);
	updateButtonBar();
	if (csobject != NULL) {      
	  XtAppAddTimeOut(appContext, 250, TimeOut,
			  (XtPointer) (POPUPTO | cpopup));
	  popev = *ev;
	}
	cbutton = 1;
      }
    }
    else { /* Button 3 Down */
      if (csobject == NULL)
	return;
      dmenu = 1;
      cbutton = 3;
    }
    if (dmenu) {      
      trace(DBG_W3D, "-> Popup appeared");
      
      /* get the object name */
      getObjectHumanName(csobject, &name, &blist);
      
      /* create the popup-menu */
      popm = XtVaCreatePopupShell(pm, simpleMenuWidgetClass, topLevel,
			     XtNbackingStore, NotUseful, XtNlabel, name,
			     XtNsensitive, True, NULL);
      XtAddCallback(popm, XtNpopdownCallback, menuPopDown, NULL);
      popline = XtVaCreateManagedWidget(buf, smeLineObjectClass, popm, NULL);
      
      /* Dcodage des mthodes et ajout des nouveaux boutons */
      for (i=0; (i < BUTTONSNUMBER) && (*blist != '\0'); i++) {
	sprintf(buf, "button%d", i);
	popbutton[i] = XtVaCreateManagedWidget(buf, smeBSBObjectClass, popm,
					     XtNlabel, blist, NULL);
	XtAddCallback(popbutton[i], XtNcallback, ButtonAction,
		      (XtPointer) -(i+1));
	blist += HNAME_LEN;
      }
      popbutton[i] = NULL;
      
      XtCallActionProc(w,"XawPositionSimpleMenu", ev, &pm, 1);
      XtCallActionProc(w,"MenuPopup", ev, &pm, 1);
    }
  }
}

