/*
   File     : menus.c
   Author   : Philippe Dax
   Creation : 17/12/97

   Virtual Reality ENGine

   PopUP Menus
*/

#include "global.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/MenuButton.h>
#ifdef MOTIF
#include <Xm/XmAll.h>
#endif

#include "initui.h"
#include "initfuncs.h"
#include "supportfuncs.h"
#include "members.h"
#include "audio.h"
#include "video.h"
#include "whiteboard.h"
#include "browsers.h"
#include "xterm.h"
#include "menus.h"
#include "net_global.h"


static Widget quit, pref, audio, video, whiteboard, members, home, stats, help;
static Widget menupref, menuaudio, menuvideo, menuwhiteboard, menumembers;
static Widget popvat, poprat, popfphone, popvic, popwb, popwbd, popnt, popnetscape, popmMosaic, popwebspace, popvrweb, popssh, poptelnet;
static Widget popaudioon, popaudiooff, popvideoon, popvideooff, popwhiteboardon, popwhiteboardoff, popmemberson, popmembersoff;


void initMenuBar()
{
  Widget padding;

  /*******************
   * Init bouton Quit
   */
#ifdef MOTIF
  quit = XmCreatePushButton(panedMenu, "quit", NULL, 0);
  XtManageChild(quit);
  XtAddCallback(quit, XmNactivateCallback, Quit, NULL);
#else
  quit = XtVaCreateManagedWidget("quit", commandWidgetClass, panedMenu,
	 XtNlabel, "Quit", NULL);
  XtAddCallback(quit, XtNcallback, Quit, NULL);
#endif

  /*******************
   * Init bouton Home
   */
  home = XtVaCreateManagedWidget("home", commandWidgetClass, panedMenu,
	 XtNlabel, "Home", NULL);
  XtAddCallback(home, XtNcallback, Home, NULL);
  
  /*******************
   * Init bouton Pref
   */
#ifdef MOTIF
  pref = XmCreatePulldownMenu(panedMenu, "Pref", NULL, 0);
  XtManageChild(pref);
  XtAddCallback(pref, XmNactivateCallback, menuStick, pref);
  initMenuPref(pref);
#else
  pref = XtVaCreateManagedWidget("pref", menuButtonWidgetClass, panedMenu,
	 XtNlabel, "Pref", XtNmenuName, "menupref", NULL);
  menupref = XtVaCreatePopupShell("menupref", simpleMenuWidgetClass, pref,
            XtNbackingStore, NotUseful, XtNsensitive, True, NULL);
  XtAddCallback(pref, XtNcallback, menuStick, menupref);

  /*********************
   * popdown pref tools
   */
  initMenuPref(menupref);
#endif

  /********************
   * Init bouton Audio
   */
#ifdef WITHAUDIO
#ifdef MOTIF
  audio = XmCreatePulldownMenu(panedMenu, "Audio", NULL, 0);
  XtManageChild(audio);
  XtAddCallback(audio, XmNactivateCallback, menuStick, audio);
  initMenuAudio(audio);
#else
  audio = XtVaCreateManagedWidget("audio", menuButtonWidgetClass, panedMenu,
	  XtNlabel, "Audio", XtNmenuName, "menuaudio", NULL);
  menuaudio = XtVaCreatePopupShell("menuaudio", simpleMenuWidgetClass, audio,
            XtNbackingStore, NotUseful, XtNsensitive, True, NULL);
  XtAddCallback(audio, XtNcallback, menuStick, menuaudio);
  initMenuAudio(menuaudio);
#endif
#endif
  
  /********************
   * Init bouton Video
   */
#ifdef WITHVIDEO
  video = XtVaCreateManagedWidget("video", menuButtonWidgetClass, panedMenu,
	  XtNlabel, "Video", XtNmenuName, "menuvideo", NULL);
  menuvideo = XtVaCreatePopupShell("menuvideo", simpleMenuWidgetClass, video,
            XtNbackingStore, NotUseful, XtNsensitive, True, NULL);
  XtAddCallback(video, XtNcallback, menuStick, menuvideo);
  initMenuVideo(menuvideo);
#endif
  
  /*************************
   * Init bouton Whiteboard
   */
#ifdef WITHWHITEBOARD
  whiteboard=XtVaCreateManagedWidget("whiteboard",menuButtonWidgetClass, panedMenu,
	     XtNlabel, "Whiteboard", XtNmenuName, "menuwhiteboard", NULL);
  menuwhiteboard = XtVaCreatePopupShell("menuwhiteboard", simpleMenuWidgetClass, whiteboard,
            XtNbackingStore, NotUseful, XtNsensitive, True, NULL);
  XtAddCallback(whiteboard, XtNcallback, menuStick, menuwhiteboard);
  initMenuWhiteboard(menuwhiteboard);
#endif
 
  /**********************
   * Init bouton Members
   */
  members = XtVaCreateManagedWidget("members", menuButtonWidgetClass, panedMenu,
	  XtNlabel, "Members", XtNmenuName, "menumembers", NULL);
  menumembers = XtVaCreatePopupShell("menumembers", simpleMenuWidgetClass, members,
            XtNbackingStore, NotUseful, XtNsensitive, True, NULL);
  XtAddCallback(members, XtNcallback, menuStick, menumembers);
  initMenuMembers(menumembers);
  
  /********************
   * Init bouton Stats
   */
  stats = XtVaCreateManagedWidget("stats", commandWidgetClass, panedMenu,
	 XtNlabel, "Stats", NULL);
  XtAddCallback(stats, XtNcallback, Stats, NULL);
  
  /***************
   * Init padding
   */
  padding = XtVaCreateManagedWidget("padding", labelWidgetClass, panedMenu,
				 XtNlabel, " ", NULL);
}

void initMenuPref(Widget w)
{
  Widget separator;

#ifdef WITHAUDIO

  /**************
   * audio tools
   */
#ifdef WITHVAT
  popvat = XtVaCreateManagedWidget("vat", smeBSBObjectClass, w,
	   XtNlabel, "Vat", NULL);
  XtAddCallback(popvat, XtNcallback, Pref, (XtPointer) VAT_TOOL);
#endif
#ifdef WITHRAT
  poprat = XtVaCreateManagedWidget("rat", smeBSBObjectClass, w,
	   XtNlabel, "Rat", NULL);
  XtAddCallback(poprat, XtNcallback, Pref, (XtPointer) RAT_TOOL);
#endif
#ifdef WITHFPHONE
  popfphone = XtVaCreateManagedWidget("fphone", smeBSBObjectClass, w,
	   XtNlabel, "Fphone", NULL);
  XtAddCallback(popfphone, XtNcallback, Pref, (XtPointer) FPHONE_TOOL);
#endif
  separator = XtVaCreateManagedWidget("separator", smeLineObjectClass, w, NULL);

#endif /* WITHAUDIO */

#ifdef WITHVIDEO
  /**************
   * video tools
   */
#ifdef WITHVIC
  popvic = XtVaCreateManagedWidget("vic", smeBSBObjectClass, w,
	   XtNlabel, "Vic", NULL);
  XtAddCallback(popvic, XtNcallback, Pref, (XtPointer) VIC_TOOL);
#endif
  separator = XtVaCreateManagedWidget("separator", smeLineObjectClass, w, NULL);
#endif /* WITHVIDEO */

  /*******************
   * whiteboard tools
   */
#ifdef WITHWB
  popwb = XtVaCreateManagedWidget("wb", smeBSBObjectClass, w,
	   XtNlabel, "Wb", NULL);
  XtAddCallback(popwb, XtNcallback, Pref, (XtPointer) WB_TOOL);
#endif
#ifdef WITHWBD
  popwbd = XtVaCreateManagedWidget("wbd", smeBSBObjectClass, w,
	   XtNlabel, "Wbd", NULL);
  XtAddCallback(popwbd, XtNcallback, Pref, (XtPointer) WBD_TOOL);
#endif
#ifdef WITHNT
  popnt = XtVaCreateManagedWidget("nt", smeBSBObjectClass, w,
	   XtNlabel, "Nt", NULL);
  XtAddCallback(popnt, XtNcallback, Pref, (XtPointer) NT_TOOL);
#endif
  separator = XtVaCreateManagedWidget("separator", smeLineObjectClass, w, NULL);

  /****************
   * browser tools
   */
#ifdef WITHNETSCAPE
  popnetscape = XtVaCreateManagedWidget("netscape", smeBSBObjectClass, w,
	   XtNlabel, "Netscape", NULL);
  XtAddCallback(popnetscape, XtNcallback, Pref, (XtPointer) NETSCAPE_TOOL);
#endif
#ifdef WITHMMOSAIC
  popmMosaic = XtVaCreateManagedWidget("mMosaic", smeBSBObjectClass, w,
	   XtNlabel, "mMosaic", NULL);
  XtAddCallback(popmMosaic, XtNcallback, Pref, (XtPointer) MMOSAIC_TOOL);
#endif
  separator = XtVaCreateManagedWidget("separator", smeLineObjectClass, w, NULL);

  /*************
   * vrml tools
   */
#ifdef WITHWEBSPACE
  popwebspace = XtVaCreateManagedWidget("webspace", smeBSBObjectClass, w,
	   XtNlabel, "Webspace", NULL);
  XtAddCallback(popwebspace, XtNcallback, Pref, (XtPointer) WEBSPACE_TOOL);
#endif
#ifdef WITHVRWEB
  popvrweb = XtVaCreateManagedWidget("vrweb", smeBSBObjectClass, w,
	   XtNlabel, "Vrweb", NULL);
  XtAddCallback(popvrweb, XtNcallback, Pref, (XtPointer) VRWEB_TOOL);
#endif
  separator = XtVaCreateManagedWidget("separator", smeLineObjectClass, w, NULL);

  /**************
   * xterm tools
   */
#ifdef WITHSSH
  popssh = XtVaCreateManagedWidget("ssh", smeBSBObjectClass, w,
	   XtNlabel, "Ssh", NULL);
  XtAddCallback(popssh, XtNcallback, Pref, (XtPointer) SSH_TOOL);
#endif
#ifdef WITHTELNET
  poptelnet = XtVaCreateManagedWidget("telnet", smeBSBObjectClass, w,
	   XtNlabel, "Telnet", NULL);
  XtAddCallback(poptelnet, XtNcallback, Pref, (XtPointer) TELNET_TOOL);
#endif
  separator = XtVaCreateManagedWidget("separator", smeLineObjectClass, w, NULL);
}

void initMenuAudio(Widget w)
{
#ifdef WITHAUDIO
  popaudioon = XtVaCreateManagedWidget("on", smeBSBObjectClass, w,
	   XtNlabel, "On", NULL);
  XtAddCallback(popaudioon, XtNcallback, Audio, (XtPointer) 1);
  popaudiooff = XtVaCreateManagedWidget("off", smeBSBObjectClass, w,
	   XtNlabel, "Off", NULL);
  XtAddCallback(popaudiooff, XtNcallback, Audio, (XtPointer) 0);
#endif
}

void initMenuVideo(Widget w)
{
#ifdef WITHVIDEO
  popvideoon = XtVaCreateManagedWidget("on", smeBSBObjectClass, w,
	   XtNlabel, "On", NULL);
  XtAddCallback(popvideoon, XtNcallback, Video, (XtPointer) 1);
  popvideooff = XtVaCreateManagedWidget("off", smeBSBObjectClass, w,
	   XtNlabel, "Off", NULL);
  XtAddCallback(popvideooff, XtNcallback, Video, (XtPointer) 0);
#endif
}

void initMenuWhiteboard(Widget w)
{
#ifdef WITHWHITEBOARD
  popwhiteboardon = XtVaCreateManagedWidget("on", smeBSBObjectClass, w,
	   XtNlabel, "On", NULL);
  XtAddCallback(popwhiteboardon, XtNcallback, Whiteboard, (XtPointer) 1);
  popwhiteboardoff = XtVaCreateManagedWidget("off", smeBSBObjectClass, w,
	   XtNlabel, "Off", NULL);
  XtAddCallback(popwhiteboardoff, XtNcallback, Whiteboard, (XtPointer) 0);
#endif
}

void initMenuMembers(Widget w)
{
  popmemberson = XtVaCreateManagedWidget("on", smeBSBObjectClass, w,
	   XtNlabel, "On", NULL);
  XtAddCallback(popmemberson, XtNcallback, Members, (XtPointer) 1);
  popmembersoff = XtVaCreateManagedWidget("off", smeBSBObjectClass, w,
	   XtNlabel, "Off", NULL);
  XtAddCallback(popmembersoff, XtNcallback, Members, (XtPointer) 0);
}

/* Fonction Quit : callback du boutton quit */
void Quit(Widget w, XtPointer cld, XtPointer cad)
{
  QuitVreng(0);
  exit(0);
}

/* Fonction menuPrefPopDown : dtruit le popup-menu Pref */
void menuPrefPopDown(Widget w, XtPointer cld, XtPointer cad)
{
  trace(DBG_WIN, "menuPrefPopDown");
  XtDestroyWidget(menupref);
}

/* Fonction Pref: callback d'un des boutons pref */
void Pref(Widget w, XtPointer cld, XtPointer cad)
{
  int tool;
  int pm = 0;

  tool = (int) cld;
  if (tool > 0) {
    pm = 1;
  }
  /* Si sortie de Popup sans choix de methodes */
  if (pm == 0 && cbutton == 3)
    return;
  trace(DBG_WIN, "Selected tool: %d", tool);
#ifdef WITHAUDIO
  if (tool & AUDIO_MASK)
  	audiotool = tool;
#endif
#ifdef WITHVIDEO
  if (tool & VIDEO_MASK)
  	videotool = tool;
#endif
#ifdef WITHWB
  if (tool & WHITEBOARD_MASK)
  	whiteboardtool = tool;
#endif
#ifdef WITHHTML
  if (tool & HTML_MASK)
  	browsertool = tool;
#endif
#ifdef WITHVRML
  if (tool & VRML_MASK)
  	vrmltool = tool;
#endif
  XtPopdown(menupref);
}

/* Fonction menuStick: callback des boutons tools */
void menuStick(Widget w, XtPointer wmenu, XtPointer cad)
{
  Position xtop, ytop, x, y;
  Dimension h;

  XtVaGetValues(topLevel, XtNx, &xtop, XtNy, &ytop, NULL);
  XtVaGetValues(w, XtNx, &x, XtNy, &y, XtNheight, &h, NULL);
  x += xtop;
  y += ytop;
  XtVaSetValues(wmenu, XtNx, x, XtNy, y+h, NULL);
  XtPopup(wmenu, XtGrabExclusive);
}

/* Fonction Audio : callback du bouton audio */
void Audio(Widget w, XtPointer cld, XtPointer cad)
{
  XtPopdown(menuaudio);
#ifdef WITHAUDIO
  if (cld) {
    audiobusy = 1;
    startaudio(curr_chan);
  }
  else {
    quitaudio();
    audiobusy = 0;
  }
#endif
}

/* Fonction Video : callback du bouton video */
void Video(Widget w, XtPointer cld, XtPointer cad)
{
  XtPopdown(menuvideo);
#ifdef WITHVIDEO
  if (cld) {
    startvideo(curr_chan);
  }
  else
    quitvideo();
#endif
}

/* Fonction Whiteboard : callback du bouton whiteboard */
void Whiteboard(Widget w, XtPointer cld, XtPointer cad)
{
  XtPopdown(menuwhiteboard);
#ifdef WITHWHITEBOARD
  if (cld) {
    startwhiteboard(curr_chan);
  }
  else
    quitwhiteboard();
#endif
}

static Widget popmembers, textmembers;

/* Fonction DismissMembers : callback du bouton DismissMembers */
static void DismissMembers(Widget w, XtPointer cld, XtPointer cad)
{
  /* XtPopdown(popmembers); */
  XtDestroyWidget(popmembers);
  popmembers = NULL;
}

/* Fonction updateMembers */
void updateMembers()
{
  MemberList *ml;
  char *membersstring = 0;

  if (textmembers != NULL) {
    membersstring = (char *) malloc(MAXPLAYERLIST);
    for (ml = mlist; ml && ml->next; ml = ml->next)
	;
    membersstring[0] = '\0';
    for (; ml != NULL; ml = ml->prev) {
      strcat(membersstring, ml->worldname);
      strcat(membersstring, ": ");
      strcat(membersstring, ml->netname);
      strcat(membersstring, "\n");
    }
    trace(DBG_WIN, "membersstring: %s", membersstring);
    XtVaSetValues(textmembers, XtNstring, membersstring, NULL);
    free(membersstring);
  }
}

/* Fonction Members : callback du bouton Members */
void Members(Widget w, XtPointer cld, XtPointer cad)
{
  if (cld) {
    Widget contmembers, dismissmembers;
    Position xtop, ytop;
    Dimension height, width;
    MemberList *ml;
    char *membersstring = 0;

    if (popmembers) {
       XtPopup(popmembers, XtGrabNone);
       return;
    }
    membersstring = (char *) malloc(MAXPLAYERLIST);
    for (ml = mlist; ml && ml->next; ml = ml->next)
	;
    membersstring[0] = '\0';
    for (; ml != NULL; ml = ml->prev) {
      strcat(membersstring, ml->worldname);
      strcat(membersstring, ": ");
      strcat(membersstring, ml->netname);
      strcat(membersstring, "\n");
    }
    XtVaGetValues(topLevel, XtNx, &xtop, XtNy, &ytop, XtNwidth, &width,
		  NULL);
    popmembers = XtVaCreatePopupShell("VReng Members", transientShellWidgetClass,
	          topLevel, NULL);
    contmembers = XtVaCreateManagedWidget("contmembers", panedWidgetClass,
                  popmembers, XtNorientation, XtorientVertical, NULL);
    textmembers = XtVaCreateManagedWidget("textmembers", asciiTextWidgetClass,
                  contmembers,
		  XtNheight, height3D/2,
		  XtNwidth, 150,
		  XtNeditType, XawtextRead,
		  XtNscrollVertical, XawtextScrollWhenNeeded,
		  XtNstring, membersstring,
		  NULL);
    dismissmembers = XtVaCreateManagedWidget("dismiss", commandWidgetClass,
                  contmembers, NULL);
    XtAddCallback(dismissmembers, XtNcallback, DismissMembers, NULL);
    free(membersstring);
    XtPopup(popmembers, XtGrabNone);
    XtMoveWidget(popmembers, xtop+width+10, ytop);
  }
  else {
    if (popmembers) {
      XtDestroyWidget(popmembers);
      popmembers = NULL;
      textmembers = NULL;
    }
  }
}

/* Fonction Home : callback du bouton Home */
void Home(Widget w, XtPointer cld, XtPointer cad)
{
  char chan[CHAN_LEN];

  sprintf(chan, "%s/%u/%d", groupinitial, portinitial, ttlorigin);
  trace(DBG_IPMC, "Wmgt: go to %s at %s", urlinitial, chan);
  quitWorld();
  /* quitChannel(); */
  quitChannel(channels_list);
  newChannel(chan);
  newWorld(urlinitial);
#ifdef WITHAUDIO
  if (audiobusy)
    startaudio(chan);
#endif
}

/* Fonction Stats : callback du bouton Stats */
void Stats(Widget w, XtPointer cld, XtPointer cad)
{
}

/* Fonction Help : callback du bouton Help */
void Help(Widget w, XtPointer cld, XtPointer cad)
{
}
