/*
 * Copyright (c) 1991-1993 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the Computer Systems
 *	Engineering Group at Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#) $Header: ss.h,v 1.10 96/03/16 13:12:53 van Exp $ (LBL)
 */

#ifndef vat_ss_h
#define vat_ss_h

#include <sys/types.h>
#ifdef WIN32
#include <winsock.h>
#endif
#include <memory.h>
#undef resource_h

#define ULAW_ZERO 0x7f
#define MEAN_FILTER 3

class SampleStream {
    public:
	SampleStream(int, int, int, int lvl = 0);
	SampleStream(const SampleStream&);
	void Mix(int delta, const u_char* in, int len);
	inline u_char *CurBlk() const { return &samples[now]; }
	inline u_char *BlkBack(u_int nsamp) const
			{
				if (nsamp > now)
					nsamp -= totsize;
				return (&samples[now - nsamp]);
			}
	inline u_int Clock() const { return sclock; }
	inline int BlkSize() const { return blksize; }
	inline int MaxSamp() const { return maxsamp; }
	inline void Advance()
			{
				sclock += blksize;
				now += blksize;
				if (now >= totsize)
					now = 0;
				// clear out the oldest discardable frame
				int i = int(now  - past);
				if (i < 0)
					i += totsize;
				memcpy(&samples[i], zero, blksize);
			}
	inline int Mean() const { return (smean); }
	inline int LTMean() const { return (sltmean); }
	inline int Silent(int t = 0) const {
		return (((smax - sltmean) >> MEAN_FILTER) < ssthresh_ + t);
	}
	inline int Max() const { return (smax); }
	void Compute();
	inline u_int Now() const { return now; }
	inline int Scale() const { return bias; }
	void SetScale(int s) { bias = s; }
	inline void AdjustScale(int s)
			{
				int b = bias + s;
				if (b < 32 && b > -32)
					bias = b;
			}
	inline int AGC() const { return (doAGC); }
	inline void DoAGC(int v)
			{
				doAGC = v? 1 : 0;
				if (doAGC == 0) {
					oldbias = bias;
					bias = 0;
				} else {
					bias = oldbias;
					deadtime = sclock;
				}
			}
	inline void UpdateAGC()
			{
				if (doAGC)
					_UpdateAGC();
			}
	inline int AGCLevel() const { return (AGClevel); }
	inline void SetAGCLevel(int v) { AGClevel = v; }
	inline void ssthresh(int v) { ssthresh_ = v; }
    private:
	void _UpdateAGC();
	u_char *samples;
	const u_char *zero;
	u_int now;
	u_int sclock;
	const int past;
	const u_int blksize;
	const u_int totsize;
	const int maxsamp;

	int sltmean;
	int smean;
	int smax;

	int doAGC;
	int bias;
	int oldbias;
	int AGClevel;
	int AGCerr;
	u_int deadtime;
	int ssthresh_;
};

#endif
