/*
 * bsd.h - tuXeyes figure definition for the (open)bsd daemon
 *
 * Copyright (c) 1999 Ivo van der Wijk
 * 
 * The tux image is (c) Larry Ewing (lewing@isc.tamu.edu)
 * The dustpuppy image is (c) Illiad (http://www.userfriendly.org)
 * The bsd daemon ("Chuck") is (c) Eric Green
 * The luxus image is (c) Urs M. E. Streidl (http://www.gigaperls.org/linux/)
 * 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef BSD_H
#define BSD_H

#include <qapplication.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qimage.h>

#include "figure.h"

/*
 * Include pixmaps. Masks will be converted to bitmaps
 */
#include "bsdaemon/bsd_main.xpm"
#include "bsdaemon/bsd_mask.xpm"
#include "bsdaemon/bsd_leftpupil.xpm"
#include "bsdaemon/bsd_rightpupil.xpm"
#include "bsdaemon/bsd_eyes.xpm"
#include "bsdaemon/bsd_eyesmask.xpm"
#include "bsdaemon/bsd_leftpupilmask.xpm"
#include "bsdaemon/bsd_rightpupilmask.xpm"

class	bsd: public figure
{
public:
	bsd(): figure()
	{
		loadImage(tuxOrig, bsd_main);
		loadImage(tuxMaskXPM, bsd_mask);
		loadImage(leftPupilOrig, bsd_leftpupil);
		loadImage(rightPupilOrig, bsd_rightpupil);
		loadImage(eyeRegionOrig, bsd_eyes);
		loadImage(eyeMaskXPM, bsd_eyesmask);
		loadImage(rightPupilMaskXPM, bsd_rightpupilmask);
		loadImage(leftPupilMaskXPM, bsd_leftpupilmask);

		// these values have to determined by examining the picture
		leftEyeX = 140;
		leftEyeY = 77;
		rightEyeX = 174;
		rightEyeY = 80;
		leftPupilRadius = 7;
		rightPupilRadius = 6;
		eyeXOffset = 113;
		eyeYOffset = 53;
	}
	~bsd() {}
private:
};

#endif // BSD_H
