/*
 * GNOME QuickRes Applet - Change the X11 display mode from the GNOME taskbar
 * Copyright (C) 1999  Vicente Aguilar <vaguilar@retemail.es>
 * http://members.es.tripod.de/~bisente/gquickres
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/* Ok, the code is a mess, I know ... :)      */
/* But, what did you spected from a           */
/* Quick-And-Dirty-Hack(tm) of other applets? */
/* It works, that's enough for me. ;)         */


#include <gnome.h>
#include <applet-widget.h>
#include <locale.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <X11/Xlib.h>
#include <X11/extensions/xf86dga.h>
#include <X11/extensions/xf86vmode.h>
#include <stdio.h>
#include "small_icon.xpm"
#include "list_icon.xpm"
#include "plus_sign.xpm"
#include "minus_sign.xpm"

#ifdef ENABLE_NLS
#    include <libintl.h>
#    define _(String) gettext (String)
#    ifdef gettext_noop
#        define N_(String) gettext_noop (String)
#    else
#        define N_(String) (String)
#    endif
#else
/* Stubs that do something close enough.  */
#    define textdomain(String) (String)
#    define gettext(String) (String)
#    define dgettext(Domain,Message) (Message)
#    define dcgettext(Domain,Message,Type) (Message)
#    define bindtextdomain(Domain,Directory) (Domain)
#    define _(String) (String)
#    define N_(String) (String)
#endif
/* </gettext_stuff> */


static gint button_press (GtkWidget*);
void on_destroy (void);
static void cb_properties_dialog(AppletWidget*, gpointer);

/* The Property box */
GtkWidget *prop;
GtkWidget *applet;
GtkWidget *quickres;

Display *dpy;
XF86VidModeModeInfo **vm_modelines; 
int vm_count;

typedef struct {
	gboolean show_tooltips;
	gboolean invert_order;
	gboolean use_pictures_in_list;
	gboolean show_dotclock;
} qr_properties;

qr_properties properties, props_config;

typedef enum { PREVIOUS_MODE=-1, NEXT_MODE=+1 } switch_mode_action;


/* Functions to change the applet backgrond when the panel bg is changed */

static void
applet_set_default_back()
{
	g_return_if_fail (quickres != NULL);

	gtk_widget_set_rc_style(quickres);
	gtk_widget_queue_draw(GTK_WIDGET(quickres));
}

static void
applet_set_back_color(GdkColor *color)
{
	GtkStyle *ns;

	ns = gtk_style_copy(quickres->style);
	gtk_style_ref(ns);

	ns->bg[GTK_STATE_NORMAL] = *color;
	ns->bg[GTK_STATE_NORMAL].pixel = 1; /* bogus */

	if(ns->bg_pixmap[GTK_STATE_NORMAL]) {
		gdk_imlib_free_pixmap(ns->bg_pixmap[GTK_STATE_NORMAL]);
		ns->bg_pixmap[GTK_STATE_NORMAL] = NULL;
	}

	gtk_widget_set_style(quickres, ns);

	gtk_style_unref(ns);

	gtk_widget_queue_draw(GTK_WIDGET(quickres));

}


static void
applet_set_back_pixmap(gchar *pixmap)
{
	GdkImlibImage *im;
	GdkPixmap *p;
	GtkStyle *ns;

	if(!pixmap || strcmp(pixmap,"")==0) {
		ns = gtk_style_copy(quickres->style);
		gtk_style_ref(ns);

		p = ns->bg_pixmap[GTK_STATE_NORMAL];
		if(p)
			gdk_imlib_free_pixmap (p);
		ns->bg_pixmap[GTK_STATE_NORMAL] = NULL;

		gtk_widget_set_style(quickres, ns);

		gtk_style_unref(ns);

		return;
	}

	if (!g_file_exists (pixmap))
		return;

	im = gdk_imlib_load_image (pixmap);
	if (!im)
		return;

	gdk_imlib_render (im, im->rgb_width, im->rgb_height);

	p = gdk_imlib_move_image (im);

	ns = gtk_style_copy(quickres->style);
	gtk_style_ref(ns);

	if(ns->bg_pixmap[GTK_STATE_NORMAL])
		gdk_imlib_free_pixmap (ns->bg_pixmap[GTK_STATE_NORMAL]);
	ns->bg_pixmap[GTK_STATE_NORMAL] = p;

	gtk_widget_set_style(quickres, ns);

	gtk_style_unref(ns);


	gdk_imlib_destroy_image (im);
}


static void
applet_back_change(GtkWidget *w,
		   PanelBackType type,
		   gchar *pixmap,
		   GdkColor *color,
		   gpointer data)
{
	if(type == PANEL_BACK_PIXMAP)
		applet_set_back_pixmap(pixmap);
	else if(type == PANEL_BACK_COLOR)
		applet_set_back_color(color);
	else
		applet_set_default_back();
}


static void change_mode(int mode)
{

	int new_mode = mode;
	XF86VidModeSwitchToMode(dpy,XDefaultScreen(dpy),vm_modelines[new_mode]);
   	XFlush(dpy);

}

static void about_cb(AppletWidget *widget, gpointer data)
{ 

	GtkWidget *about;
	static const gchar *author[]= {
		"Vicente Aguilar <vaguilar@retemail.es>" , NULL };
	char about_text[1024];
	sprintf(about_text,
	        _("Change the X11 display mode from the GNOME taskbar.\n"
	          "Compiled by %s on %s using %s."),
	        WHO,DATE,CCVER);

	about = gnome_about_new (
		_("GNOME QuickRes Applet"), 
		VERSION,
		"Copyright (C) Vicente Aguilar 1999",
		author,
		about_text,
		NULL
	);

	gtk_widget_show(about);
	
}


static gint button_press (GtkWidget *widget)
{
	  
	int i;
	char mode_name[50];
	
	GtkWidget *menu_items;
	GtkWidget *menu;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *current;

	gboolean found=FALSE;
	int dotclock;
	XF86VidModeModeLine modeline; 

	/* Get the current mode */
	XF86VidModeGetModeLine(dpy,XDefaultScreen(dpy),&dotclock,&modeline);

	/* BEGIN WITH THE GTK WIDGETS */
	menu = gtk_menu_new();
	
	/* PRINT THE LIST OF MODES FOUND */
	for(i=0; i < vm_count; i++) {

		hbox = gtk_hbox_new(FALSE, FALSE);

		if( !found && 
		    dotclock             ==  vm_modelines[i]->dotclock    &&
		    modeline.hdisplay    ==  vm_modelines[i]->hdisplay    &&
		    modeline.hsyncstart  ==  vm_modelines[i]->hsyncstart  &&
		    modeline.hsyncend    ==  vm_modelines[i]->hsyncend    &&
		    modeline.htotal      ==  vm_modelines[i]->htotal      &&
		    modeline.vdisplay    ==  vm_modelines[i]->vdisplay    &&
		    modeline.vsyncstart  ==  vm_modelines[i]->vsyncstart  &&
		    modeline.vsyncend    ==  vm_modelines[i]->vsyncend    &&
		    modeline.vtotal      ==  vm_modelines[i]->vtotal      &&
		    modeline.flags       ==  vm_modelines[i]->flags ) {
		    
		    if( properties.use_pictures_in_list )
			    current = gnome_pixmap_new_from_xpm_d(list_icon_xpm);
			else
				current = gtk_label_new("*");
			found = TRUE;

		} else
				current = gtk_label_new(" ");

		gtk_widget_set_usize(current, 12, 12);
		gtk_box_pack_start(GTK_BOX(hbox), current, FALSE, TRUE, 1);

		if(properties.show_dotclock)
			sprintf(mode_name,"%dx%d@%d",
			        vm_modelines[i]->hdisplay,
			        vm_modelines[i]->vdisplay, 
			        vm_modelines[i]->dotclock);
		else
			sprintf(mode_name,"%dx%d",
			        vm_modelines[i]->hdisplay,
			        vm_modelines[i]->vdisplay);
		label = gtk_label_new(mode_name);
		gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 1);
		
		menu_items = gtk_menu_item_new();
		gtk_container_add(GTK_CONTAINER(menu_items), hbox);
		gtk_menu_item_right_justify(GTK_MENU_ITEM(menu_items));
		
		gtk_menu_append(GTK_MENU(menu), menu_items);
		gtk_signal_connect_object(GTK_OBJECT(menu_items),"activate",
						GTK_SIGNAL_FUNC(change_mode),
						(gpointer) i);
		
		gtk_widget_show_all(menu_items);
								
	}

	if( !found ) 
		g_print(_("Can't guess which mode you're in!!\n"));

	gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, 0);
	return 0;

}


static void switch_mode_cb( int action )
{
	int new_mode;

	if( action == NEXT_MODE && properties.invert_order == FALSE ||
	    action == PREVIOUS_MODE && properties.invert_order == TRUE )
		new_mode = NEXT_MODE;
	else
		new_mode = PREVIOUS_MODE;

	XF86VidModeSwitchMode(dpy,XDefaultScreen(dpy),new_mode);
 	XFlush(dpy);

}


void on_destroy(void) {

	XFree(vm_modelines);
	exit(0);

}



GtkWidget *quickres_widget()
{ 

    GtkWidget *fixed;
	GtkWidget *hbox;
	GtkWidget *vbox;
	GtkWidget *button_screen;
	GtkWidget *button_next;
	GtkWidget *button_previous;
	GtkWidget *pixmap_screen;
	GtkWidget *pixmap_next;
	GtkWidget *pixmap_previous;


    fixed = gtk_fixed_new();


    button_screen = gtk_button_new();
	gtk_widget_set_usize(button_screen, 24, 24);
    GTK_WIDGET_UNSET_FLAGS(button_screen, GTK_CAN_DEFAULT);
    GTK_WIDGET_UNSET_FLAGS(button_screen, GTK_CAN_FOCUS);
	gtk_button_set_relief(GTK_BUTTON(button_screen), GTK_RELIEF_NONE);
    pixmap_screen = gnome_pixmap_new_from_xpm_d(small_icon_xpm);
	gtk_container_add(GTK_CONTAINER(button_screen), pixmap_screen);
    
    gtk_signal_connect(GTK_OBJECT(button_screen), "button_press_event",
                       GTK_SIGNAL_FUNC(button_press), NULL);


	vbox = gtk_vbox_new(FALSE, FALSE);
	hbox = gtk_hbox_new(FALSE, FALSE);


	button_next = gtk_button_new();
    GTK_WIDGET_UNSET_FLAGS(button_next, GTK_CAN_DEFAULT);
    GTK_WIDGET_UNSET_FLAGS(button_next, GTK_CAN_FOCUS);
	gtk_button_set_relief(GTK_BUTTON(button_next), GTK_RELIEF_NONE);
    pixmap_next = gnome_pixmap_new_from_xpm_d(plus_sign_xpm);
    gtk_container_add(GTK_CONTAINER(button_next), pixmap_next);
	gtk_box_pack_start(GTK_BOX(hbox), button_next, FALSE, TRUE, 1);

    gtk_signal_connect_object( GTK_OBJECT(button_next), 
                               "button_press_event",
                               GTK_SIGNAL_FUNC(switch_mode_cb), 
                               (gpointer)NEXT_MODE
                             );


	button_previous = gtk_button_new();
    GTK_WIDGET_UNSET_FLAGS(button_previous, GTK_CAN_DEFAULT);
    GTK_WIDGET_UNSET_FLAGS(button_previous, GTK_CAN_FOCUS);
	gtk_button_set_relief(GTK_BUTTON(button_previous), GTK_RELIEF_NONE);
    pixmap_previous = gnome_pixmap_new_from_xpm_d(minus_sign_xpm);
    gtk_container_add(GTK_CONTAINER(button_previous), pixmap_previous);
	gtk_box_pack_start(GTK_BOX(hbox), button_previous, FALSE, TRUE, 2);

    gtk_signal_connect_object( GTK_OBJECT(button_previous), 
                               "button_press_event",
                               GTK_SIGNAL_FUNC(switch_mode_cb), 
                               (gpointer)PREVIOUS_MODE
                             );


	gtk_box_pack_start(GTK_BOX(vbox), button_screen, FALSE, TRUE, 2);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 2);
	gtk_fixed_put (GTK_FIXED(fixed), vbox, 0, 0);


	applet_widget_register_stock_callback(
		APPLET_WIDGET(applet),
		"about",
		GNOME_STOCK_MENU_ABOUT,
		_("About..."),
		about_cb,
		NULL
	);

	applet_widget_register_stock_callback (
	  	APPLET_WIDGET (applet),
		"properties",
		GNOME_STOCK_MENU_PROP,
		_ ("Properties..."),
		cb_properties_dialog, 
		NULL);


	gtk_widget_show_all(fixed);
	return (fixed);

}


void qr_set_tooltip()
{
	
	if( properties.show_tooltips )

		applet_widget_set_tooltip( APPLET_WIDGET(applet),
		  _("Click on the screen icon to select a mode from the list, or use "
		    "the '+' and '-' icons to switch to the next or previous mode.") );

	else
		applet_widget_set_tooltip( APPLET_WIDGET(applet), NULL );

}


/* Callback for apply */
static gboolean
cb_apply (GtkWidget *widget, gint page, gpointer data)
{

	memcpy (&properties, &props_config, sizeof (qr_properties));
	qr_set_tooltip();

	return FALSE;

}


/* Callback for check buttons */
static gboolean
cb_check_button (GtkWidget *widget, gboolean *data)
{

	gnome_property_box_changed (GNOME_PROPERTY_BOX (prop));
	*data = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget));
	return FALSE;

}
 

/* Create a check button */
GtkWidget *
create_check_button (gchar *name, gboolean *change_value)
{

	GtkWidget *checkbutton;

	checkbutton = gtk_check_button_new_with_label (name);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton), *change_value);
	gtk_signal_connect (GTK_OBJECT (checkbutton), "toggled",
			    GTK_SIGNAL_FUNC (cb_check_button), change_value);
	return checkbutton;

}


void set_tooltip (GtkWidget * w, const gchar * tip)
{
	GtkTooltips *t = gtk_tooltips_new ();
	gtk_tooltips_set_tip (t, w, tip, NULL);
}

    
void create_general_page (void)
{

	GtkWidget *vbox, *frame;
	GtkWidget *miscbox, *taskbox;
	GtkWidget *radio;
	GtkWidget *button;
	GSList *taskgroup = NULL;

	vbox = gtk_vbox_new (FALSE, GNOME_PAD_SMALL);
	
	frame = gtk_frame_new (_("Applet Behaviour"));
	gtk_container_border_width (GTK_CONTAINER (frame), GNOME_PAD_SMALL);
	gtk_box_pack_start_defaults (GTK_BOX (vbox), frame);

	taskbox = gtk_vbox_new (FALSE, GNOME_PAD_SMALL);
	gtk_container_add (GTK_CONTAINER (frame), taskbox);

	button = create_check_button (_("Show tooltip"), 
	                              &props_config.show_tooltips );
	set_tooltip(button,_("Show tooltips in the panel icon."));
	gtk_box_pack_start (GTK_BOX (taskbox), button, FALSE, TRUE, 0);

	button = create_check_button (_("Invert switching order"), 
	                              &props_config.invert_order );
	set_tooltip(button,
		_("Invert the videomode switching order of the '+' and '-' buttons."));
	gtk_box_pack_start (GTK_BOX (taskbox), button, FALSE, TRUE, 0);

	frame = gtk_frame_new (_("VideoMode List"));
	gtk_container_border_width (GTK_CONTAINER (frame), GNOME_PAD_SMALL);
	gtk_box_pack_start_defaults (GTK_BOX (vbox), frame);
	
	miscbox = gtk_vbox_new (FALSE, GNOME_PAD_SMALL);
	gtk_container_add (GTK_CONTAINER (frame), miscbox);

	button = create_check_button (_("Mark with icon"), 
	                              &props_config.use_pictures_in_list );
	set_tooltip(button,
		_("Use an icon to mark the current mode. Else use an asterisk ('*')."));
	gtk_box_pack_start (GTK_BOX (miscbox), button, FALSE, TRUE, 0);

	button = create_check_button (_("Show dotclock"), 
	                              &props_config.show_dotclock );
	set_tooltip(button, _("Also show the dotclock in the video mode list."));
	gtk_box_pack_start (GTK_BOX (miscbox), button, FALSE, TRUE, 0);

    gnome_property_box_append_page (GNOME_PROPERTY_BOX (prop), vbox,
	                                gtk_label_new (_("General")));
                        
}


/* Display property dialog */
static void cb_properties_dialog(AppletWidget *widget, gpointer data)
{

	memcpy (&props_config, &properties, sizeof (qr_properties));

	prop = gnome_property_box_new ();
	gtk_window_set_title (GTK_WINDOW (prop), _("QuickRes Applet Properties"));
	gtk_signal_connect (GTK_OBJECT (prop), "apply",
			    GTK_SIGNAL_FUNC (cb_apply), NULL);

	create_general_page ();
	gtk_widget_show_all (prop);

}


void read_config(void)
{

	gnome_config_push_prefix (APPLET_WIDGET (applet)->privcfgpath);
	properties.show_tooltips = 
		gnome_config_get_bool ("quickres/show_tooltips=true");
	properties.invert_order = 
		gnome_config_get_bool ("quickres/invert_order=false");
	properties.use_pictures_in_list = 
		gnome_config_get_bool ("quickres/use_pictures=true");
	properties.show_dotclock = 
		gnome_config_get_bool ("quickres/show_dotclock=false");
       
}


gboolean write_config ( const gchar *privcfgpath )
{

	gnome_config_push_prefix (privcfgpath
	                          ? privcfgpath
	                          : APPLET_WIDGET (applet)->privcfgpath);
                                                              
	gnome_config_set_bool ("quickres/show_tooltips", 
	                       properties.show_tooltips );
	gnome_config_set_bool ("quickres/invert_order", 
	                       properties.invert_order );
	gnome_config_set_bool ("quickres/use_pictures", 
	                       properties.use_pictures_in_list );
	gnome_config_set_bool ("quickres/show_dotclock", 
	                       properties.show_dotclock );

	gnome_config_sync ();
	gnome_config_pop_prefix ();

	return FALSE;

}


static gint applet_save_session (GtkWidget * widget, gchar * privcfgpath,
                                 gchar * globcfgpath, gpointer data)
{
	write_config (privcfgpath);
	return FALSE;
}

                                  
int main (int argc, char **argv)
{

	/* initialize i18n stuph */
	bindtextdomain(PACKAGE, LOCALE);
	textdomain(PACKAGE);
	
	applet_widget_init("quickres_applet",VERSION,argc,argv,NULL,0,NULL);
	
	applet = applet_widget_new("quickres_applet");
	if(!applet) {
		g_print(_("Cannot create applet!\n"));
		_exit(127);
	}
	
	dpy = XOpenDisplay("");   
	/* GET LIST OF MODES FOUND */
	XF86VidModeGetAllModeLines(dpy,XDefaultScreen(dpy),&vm_count,&vm_modelines);
	
	if(!(vm_count)) {
		g_print(_("gtkmodes error: could not find any modes!\n"));
		exit(1);
	}

	gtk_widget_realize(applet);

	quickres = quickres_widget();
	gtk_widget_show(quickres);

	gtk_signal_connect(GTK_OBJECT(applet),"back_change",
			   GTK_SIGNAL_FUNC(applet_back_change),
			   quickres);

	gtk_signal_connect (GTK_OBJECT (applet), "save_session",
	                    GTK_SIGNAL_FUNC (applet_save_session), NULL);

	applet_widget_add(APPLET_WIDGET(applet),quickres);
	gtk_widget_show(applet);

	read_config();

	qr_set_tooltip();

	applet_widget_gtk_main();
	
	return 0;

}
