/*****************************************************************************
Get the DES transform data into a format I like ...



Saleem N. Bhatti
February 1993
*****************************************************************************/

#include <stdio.h>

typedef unsigned long Word;

Word ipMatrix[64] =
{58, 50, 42, 34, 26, 18, 10,  2, 60, 52, 44, 36, 28, 20, 12, 4,
 62, 54, 46, 38, 30, 22, 14,  6, 64, 56, 48, 40, 32, 24, 16, 8,
 57, 49, 41, 33, 25, 17,  9,  1, 59, 51, 43, 35, 27, 19, 11, 3,
 61, 53, 45, 37, 29, 21, 13,  5, 63, 55, 47, 39, 31, 23, 15, 7};

Word fpMatrix[64] =
{40,  8, 48, 16, 56, 24, 64, 32, 39,  7, 47, 15, 55, 23, 63, 31,
 38,  6, 46, 14, 54, 22, 62, 30, 37,  5, 45, 13, 53, 21, 61, 29,
 36,  4, 44, 12, 52, 20, 60, 28, 35,  3, 43, 11, 51, 19, 59, 27,
 34,  2, 42, 10, 50, 18, 58, 26, 33,  1, 41,  9, 49, 17, 57, 25};

Word eMatrix[48] =
{32,  1,  2,  3,  4,  5,  4,  5,  6,  7,  8,  9,
  8,  9, 10, 11, 12, 13, 12, 13, 14, 15, 16, 17,
 16, 17, 18, 19, 20, 21, 20, 21, 22, 23, 24, 25,
 24, 25, 26, 27, 28, 29, 28, 29, 30, 31, 32,  1};

Word sBoxes[8][4][16] =
{{{14,  4, 13,  1,  2, 15, 11,  8,  3, 10,  6, 12,  5,  9,  0,  7},
  { 0, 15,  7,  4, 14,  2, 13,  1, 10,  6, 12, 11,  9,  5,  3,  8},
  { 4,  1, 14,  8, 13,  6,  2, 11, 15, 12,  9,  7,  3, 10,  5,  0},
  {15, 12,  8,  2,  4,  9,  1,  7,  5, 11,  3, 14, 10,  0,  6, 13}},

  {{15,  1,  8, 14,  6, 11,  3,  4,  9,  7,  2, 13, 12,  0,  5, 10},
   { 3, 13,  4,  7, 15,  2,  8, 14, 12,  0,  1, 10,  6,  9, 11,  5},
   { 0, 14,  7, 11, 10,  4, 13,  1,  5,  8, 12,  6,  9,  3,  2, 15},
   {13,  8, 10,  1,  3, 15,  4,  2, 11,  6,  7, 12,  0,  5, 14,  9}},

  {{10,  0,  9, 14,  6,  3, 15,  5,  1, 13, 12,  7, 11,  4,  2,  8},
   {13,  7,  0,  9,  3,  4,  6, 10,  2,  8,  5, 14, 12, 11, 15,  1},
   {13,  6,  4,  9,  8, 15,  3,  0, 11,  1,  2, 12,  5, 10, 14,  7},
   { 1, 10, 13,  0,  6,  9,  8,  7,  4, 15, 14,  3, 11,  5,  2, 12}},

  {{ 7, 13, 14,  3,  0,  6,  9, 10,  1,  2,  8,  5, 11, 12,  4, 15},
   {13,  8, 11,  5,  6, 15,  0,  3,  4,  7,  2, 12,  1, 10, 14,  9},
   {10,  6,  9,  0, 12, 11,  7, 13, 15,  1,  3, 14,  5,  2,  8,  4},
   { 3, 15,  0,  6, 10,  1, 13,  8,  9,  4,  5, 11, 12,  7,  2, 14}},

  {{ 2, 12,  4,  1,  7, 10, 11,  6,  8,  5,  3, 15, 13,  0, 14,  9},
   {14, 11,  2, 12,  4,  7, 13,  1,  5,  0, 15, 10,  3,  9,  8,  6},
   { 4,  2,  1, 11, 10, 13,  7,  8, 15,  9, 12,  5,  6,  3,  0, 14},
   {11,  8, 12,  7,  1, 14,  2, 13,  6, 15,  0,  9, 10,  4,  5,  3}},

  {{12,  1, 10, 15,  9,  2,  6,  8,  0, 13,  3,  4, 14,  7,  5, 11},
   {10, 15,  4,  2,  7, 12,  9,  5,  6,  1, 13, 14,  0, 11,  3,  8},
   { 9, 14, 15,  5,  2,  8, 12,  3,  7,  0,  4, 10,  1, 13, 11,  6},
   { 4,  3,  2, 12,  9,  5, 15, 10, 11, 14,  1,  7,  6,  0,  8, 13}},

  {{ 4, 11,  2, 14, 15,  0,  8, 13,  3, 12,  9,  7,  5, 10,  6,  1},
   {13,  0, 11,  7,  4,  9,  1, 10, 14,  3,  5, 12,  2, 15,  8,  6},
   { 1,  4, 11, 13, 12,  3,  7, 14, 10, 15,  6,  8,  0,  5,  9,  2},
   { 6, 11, 13,  8,  1,  4, 10,  7,  9,  5,  0, 15, 14,  2,  3, 12}},

  {{13,  2,  8,  4,  6, 15, 11,  1, 10,  9,  3, 14,  5,  0, 12,  7},
   { 1, 15, 13,  8, 10,  3,  7,  4, 12,  5,  6, 11,  0, 14,  9,  2},
   { 7, 11, 4,   1,  9, 12, 14,  2,  0,  6, 10, 13, 15,  3,  5,  8},
   { 2,  1, 14,  7,  4, 10,  8, 13, 15, 12,  9,  0,  3,  5,  6, 11}}};

Word pc1Matrix[56] =
{57, 49, 41, 33, 25, 17,  9,  1, 58, 50, 42, 34, 26, 18,
 10,  2, 59, 51, 43, 35, 27, 19, 11,  3, 60, 52, 44, 36,
 63, 55, 47, 39, 31, 23, 15,  7, 62, 54, 46, 38, 30, 22,
 14,  6, 61, 53, 45, 37, 29, 21, 13,  5, 28, 20, 12,  4};

Word pc2Matrix[48] =
{14, 17, 11, 24,  1,  5,  3, 28, 15,  6, 21, 10,
 23, 19, 12,  4, 26,  8, 16,  7, 27, 20, 13,  2,
 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48,
 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};

Word pMatrix[32] =
{16,  7, 20, 21,
 29, 12, 28, 17,
  1, 15, 23, 26,
  5, 18, 31, 10,
  2,  8, 24, 14,
 32, 27,  3,  9,
 19, 13, 30,  6,
 22, 11,  4, 25};

int left[16] =  {1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1}; /* Unused */
int right[16] = {0, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1}; /* Unused */

char typeStr[] = "static\nWord ";

Word m_64_2[64][2];  /* for IP, FP, PC1 and PC2 */
Word m_32[32];       /* for P */
Word m_64[64];       /* for S_P */

/* Set up m_32 before using this! */
#define P(ip, op) \
{ \
    register unsigned int z; \
    op = 0; \
    for(z = 0; z < 32; ++z) op |= (ip & ((Word) 0x80000000 >> z) ? m_32[z] : 0); \
}

main()
{
    Word v, i, j, n, m, value, index, bitpos, shiftNum;

    char shiftStr[20];

    printf("#if !defined(_qfDES_aux_c_)\n");
    printf("#define _qfDES_aux_c_\n\n");

    for(i = 0; i < 32; ++i)
        printf("#define B%02d 0x%08x\n", i, (Word) 0x80000000 >> i);

    printf("\n");

    printf("#define INITIAL_PERMUTATION_AUX(_i0, _i1, _o0, _o1) \\\n");
    printf("{ \\\n");
    printf("_o0 = _o1 = 0; \\\n");
    for(i = 0; i < 64; ++i) {
        index = ipMatrix[i] > 32 ? 1 : 0;
        bitpos = ipMatrix[i] - ((index * 32) + 1);

        m = i % 32;
        shiftNum = bitpos > m ? (bitpos - m) : (m - bitpos);
        if (shiftNum == 0)
            sprintf(shiftStr, "     ");
        else
            sprintf(shiftStr, "%s %2d", bitpos > m ? "<<" : ">>", shiftNum);

        printf("_o%d |= (_i%d & B%02d) %s; /* %2d */ \\\n", i > 31 ? 1 : 0,
               index, bitpos, shiftStr, ipMatrix[i]);

    }
    printf("}\n\n");

    printf("#define FINAL_PERMUTATION_AUX(_i0, _i1, _o0, _o1) \\\n");
    printf("{ \\\n");
    printf("_o0 = _o1 = 0; \\\n");
    for(i = 0; i < 64; ++i) {
        index = fpMatrix[i] > 32 ? 1 : 0;
        bitpos = fpMatrix[i] - ((index * 32) + 1);

        m = i % 32;
        shiftNum = bitpos > m ? (bitpos - m) : (m - bitpos);
        if (shiftNum == 0)
            sprintf(shiftStr, "     ");
        else
            sprintf(shiftStr, "%s %2d", bitpos > m ? "<<" : ">>", shiftNum);

        printf("_o%d |= (_i%d & B%02d) %s; /* %2d */ \\\n", i > 31 ? 1 : 0,
               index, bitpos, shiftStr, fpMatrix[i]);
    }
    printf("}\n\n");

    printf("/* 64b -> 2x28b */\n");
    printf("#define PC1_AUX(_i0, _i1, _o0, _o1) \\\n");
    printf("{ \\\n");
    printf("_o0 = _o1 = 0; \\\n");
    for(i = 0; i < 56; ++i) {
        index = pc1Matrix[i] > 32 ? 1 : 0;
        bitpos = pc1Matrix[i] - ((index * 32) + 1);

        m = i % 28;
        shiftNum = bitpos > m ? (bitpos - m) : (m - bitpos);
        if (shiftNum == 0)
            sprintf(shiftStr, "     ");
        else
            sprintf(shiftStr, "%s %2d", bitpos > m ? "<<" : ">>", shiftNum);

        printf("_o%d |= (_i%d & B%02d) %s; /* %2d */ \\\n", i > 27 ? 1 : 0,
               index, bitpos, shiftStr, pc1Matrix[i]);
    }
    printf("}\n\n");
    
    printf("/* 2x28b -> 8x6b */\n");
    j = 0;
    printf("#define PC2_AUX(_i0, _i1, _o0, _o1) \\\n");
    printf("{ \\\n");
    printf("_o0 = _o1 = 0; \\\n");
    for(i = 0; i < 48; ++i) {
        index = pc2Matrix[i] > 28 ? 1 : 0;
        bitpos = pc2Matrix[i] - ((index * 28) + 1);

        if ((i > 0) && ((i % 6) == 0)) j += 2;
        if (i == 24) j = 0;
        m = (i % 24) + j + 2;
        shiftNum = bitpos > m ? (bitpos - m) : (m - bitpos);
        if (shiftNum == 0)
            sprintf(shiftStr, "     ");
        else
            sprintf(shiftStr, "%s %2d", bitpos > m ? "<<" : ">>", shiftNum);

        printf("_o%d |= (_i%d & B%02d) %s; /* %2d */ \\\n", i > 23 ? 1 : 0,
               index, bitpos, shiftStr, pc2Matrix[i]);
    }
    printf("}\n\n");

    /* Evaluate P */
    for(i = 0; i < 32; ++i)
        m_32[(pMatrix[i] - 1)] = ((Word) 0x80000000) >> i;

    /* Evaluate & Print */
    for(i = 0; i < 8; ++i) {
      
        for(j = 0; j < 64; ++j) {

            n = ((j >> 4) & 2) | (j & 1);
            m = (j >> 1) & 0x0f;

            v = sBoxes[i][n][m] << (4 * (7 - i));
            P(v, value);

            m_64[j] = value;
        }

        printf("%ss_p%d[64] =\n", typeStr, i);
        printf("{ /* Combined S-Box%d and permutation P */\n", i + 1);
        for(j = 0; j < 64; ++j)
            printf("0x%08x%s%s", m_64[j], (j < 63 ? "," : ""),
                   (j + 1) % 4 ? " " : "\n");
        printf("};\n\n");
    }

    printf("#endif /* !_qfDES_aux_c_ */\n");

    return 0;
}
