//
//  Login.app
// 
//  Copyright (c) 1997, 1998 Per Liden
// 
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "Input.h"


Input::Input()
{
    NameBuffer[0] = '\0';
    PasswdBuffer[0] = '\0';
    HiddenPasswdBuffer[0] = '\0';
    Field = GET_NAME;
    Action = WAIT;
}


Input::~Input()
{
    // Does nothing
}


char Input::Key(char ascii, KeySym keysym)
{
    char tmp = 0;

    if(keysym == XK_Return)
    {
	if(!strcmp(NameBuffer, ""))
		return tmp;
	
	// Check for special command (console, halt, reboot, exit)
	int special = SpecialWanted();

	if(Field == GET_NAME)
	{
	    // Move to next field
	    Field = GET_PASSWD;

	    // Check for special command (console, exit)
	    if(special == CONSOLE || special == EXIT)
		Action = special;
	}
	else
 	{
	    // Check for special command (halt, reboot)
	    if(special == REBOOT || special == HALT)
		Action = SpecialCorrect(special);
	    
	    // Regular login
	    else
	    {
		if(Correct())		
		    Action = LOGIN;
		else
		    Action = FAIL;
	    }
	}
    }
    else if(keysym == XK_Delete || keysym == XK_BackSpace)    
	tmp = DeleteLast();    
    else if(isprint(ascii))
	if(keysym < XK_Shift_L || keysym > XK_Hyper_R)    
		Add(ascii);

    return tmp;
}


int Input::GetAction()
{
    return Action;
}


int Input::GetField()
{
    return Field;
}


char* Input::GetName()
{    
    return NameBuffer;
}


char* Input::GetHiddenPasswd()
{
    return HiddenPasswdBuffer;
}


struct passwd* Input::GetPasswdStruct()
{
    struct passwd* pw = getpwnam(NameBuffer);
    endpwent();
    return pw;
}


void Input::Add(char ascii)
{
    char tmp[2];
    tmp[0] = ascii;
    tmp[1] = '\0';

    switch(Field)
    {
    case GET_NAME:
	if(strlen(NameBuffer) < INPUT_MAXLENGTH_NAME-1)
	    strcat(NameBuffer, tmp);
	break;
    case GET_PASSWD:
	if(strlen(PasswdBuffer) < INPUT_MAXLENGTH_PASSWD-1) 
	{
	    strcat(PasswdBuffer, tmp);
	    tmp[0] = '*';
	    strcat(HiddenPasswdBuffer, tmp);	    
	}
	break;
    }
}


char Input::DeleteLast()
{
    char tmp = 0;
    int len = 0;
    
    switch(Field)
    {
    case GET_NAME:
	len = strlen(NameBuffer) - 1;
	tmp = NameBuffer[len];
	NameBuffer[len] = '\0';	
	break;
    case GET_PASSWD:
	len = strlen(PasswdBuffer) - 1;
	tmp = '*';
	PasswdBuffer[len] = '\0';	
	HiddenPasswdBuffer[len] = '\0';	
	break;
    }
    
    return tmp;
}


void Input::Reset()
{
    NameBuffer[0] = '\0';
    PasswdBuffer[0] = '\0';
    HiddenPasswdBuffer[0] = '\0';
    Field = GET_NAME;
    Action = WAIT;
}


int Input::Correct()
{
    char *unencrypted, *encrypted, *correct;
    struct passwd *pw;

    pw = getpwnam(NameBuffer);
    endpwent();
    if(pw == 0)
	return 0;

#ifdef SHADOW_PASSWD
    struct spwd *sp = getspnam(pw->pw_name);    
    endspent();
    if(sp)
	correct = sp->sp_pwdp;
    else
#endif
	correct = pw->pw_passwd;
    
    if(correct == 0 || correct[0] == '\0')
	return 1;
    
    unencrypted = PasswdBuffer;
    encrypted = crypt(unencrypted, correct);
    memset(unencrypted, 0, strlen (unencrypted));
    return (strcmp(encrypted, correct) == 0);
}


int Input::SpecialWanted()
{
    int result;

    if(!strcmp(NameBuffer, CONSOLE_STR))
	result = CONSOLE;
    else if(!strcmp(NameBuffer, HALT_STR))
	result = HALT;
    else if(!strcmp(NameBuffer, REBOOT_STR))
	result = REBOOT;
    else if(!strcmp(NameBuffer, EXIT_STR))
	result = EXIT;
    else
	result = 0;

    return result;
}


int Input::SpecialCorrect(int special)
{
    int result, c;
    char tmp[INPUT_MAXLENGTH_NAME];

    strcpy(tmp, NameBuffer);    
    strcpy(NameBuffer, "root");
    c = Correct();    
    strcpy(NameBuffer, tmp);

    if(c)
	result = special;
    else
	result = FAIL;       

    return result;
}

