/* mktmp.c */
/* this program will create a unique file in /tmp, touch the file, print the
   name of the file to stdout, and exit */
/* similar to the BSD mktemp, but different, because I can't get mktemp to
   work, and it might not be on all systems */
/* Copyright (C) 1999 Matthew Grossman <mattg@oz.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include<stdio.h>
#include<stdlib.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>

int
main(int argc, char *argv[])
{
  char *s = NULL;
  int rv = EXIT_SUCCESS;

  s = (char *)malloc(sizeof(char) * L_tmpnam + 1);
  if(!s) {
    fprintf(stderr, "malloc failed");
    goto ERROR;
  }
  if(!tmpnam(s)) {
    perror("tmpnam");
    goto ERROR;
  }
  if(creat(s, S_IRUSR | S_IWUSR) < 0) {
    perror("creat");
    goto ERROR;
  }
  printf("%s", s);

 DONE:
  if(s)
    free(s);
  exit(rv);

 ERROR:
  rv = EXIT_FAILURE;
  goto DONE;
}
    
