/*
    main.h - Provide the main window and related routines
    Copyright (c) 1999  Martin Schulze <joey@infodrom.north.de>

    This file is part of the Gerstensaft package.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.
*/

#ifndef __MAIN_H__
#define __MAIN_H__

#include <gtk/gtk.h>
#include "io.h"

struct s_main_data {
  char *dir;	/* Current directory */
  int numfiles;		/* Number of files */
  int *selected;	/* Array of selected entries */
  int numstored;	/* Number of already stored files */
  char **stored;	/* Array of already stored files */
  unsigned long int *size;	/* Array of sizes for stored */
  GtkWidget *listbox;
  GtkWidget *dirinput;
  GtkWidget *filebox;
  GtkWidget *sendbutton;
  GtkWidget *clearbutton;
};

void main_window();

extern GdkPixmap *dir_pixmap, *doc_pixmap;
extern GdkBitmap *dir_mask, *doc_mask;

void main_clear (gpointer data);

#endif /* __MAIN_H__ */
