/*
** 1998-09-15 -	Header for the buttons module.
** 1999-05-01 -	Huge changes to incorporate the new multi-function button.
*/

#include "widgets/odemilbutton.h"
#include "xmlutil.h"

typedef struct _Button		Button;
typedef struct _ButtonRow	ButtonRow;
typedef struct _ButtonSheet	ButtonSheet;

/* Each button has BTN_FACES different "faces", accessible to the user in
** parallel. This is implemented by the ODEmilButton (no, I didn't name it
** myself!) using the left and middle mouse buttons to access the primary
** and secondary fields.
*/
typedef enum {	BTN_PRIMARY   = OD_EMIL_BUTTON_PRIMARY,
		BTN_SECONDARY = OD_EMIL_BUTTON_SECONDARY,
		BTN_FACES } BtnFace;

/* ----------------------------------------------------------------------------------------- */

/* These are the flags available in each Button. Use the btn_button_XXX_flags() calls
** to access these (a good idea, since nothing else is possible :).
*/
#define	BTF_NARROW		(1<<0)		/* Is the button narrow? */
#define	BTF_SHOW_TOOLTIP	(1<<1)		/* Does the button show its tooltip string? */

/* ----------------------------------------------------------------------------------------- */

void		btn_buttoninfo_default(MainInfo *min, ButtonInfo *bti);
void		btn_buttoninfo_copy(ButtonInfo *dst, ButtonInfo *src);
void		btn_buttoninfo_add_sheet(ButtonInfo *bti, ButtonSheet *bsh);
void		btn_buttoninfo_destroy(ButtonInfo *bti);

void		btn_buttoninfo_save(MainInfo *min, ButtonInfo *bti, FILE *out, const gchar *tag);
void		btn_buttoninfo_load(MainInfo *min, ButtonInfo *bti, XmlNode *node);

/* Main button allocation routine. Probably not useful outside of the buttons module... */
Button *	btn_button_new(Button *base, guint num);

/* Set/get functions for per-face properties. */

/* This (semi-obsolete) function sets only primary face properties. */
void		btn_button_init(Button *btn, const gchar *label, const gchar *cmd, const gchar *key);
void		btn_button_set_label(Button *btn, BtnFace face, const gchar *label);
void		btn_button_set_label_widget(GtkWidget *widget, BtnFace face, const gchar *label);
void		btn_button_set_cmdseq(Button *btn, BtnFace face, const gchar *seq);
void		btn_button_set_key(Button *btn, BtnFace face, const gchar *key);
void		btn_button_set_colors(Button *btn, BtnFace face, const GdkColor *bg, const GdkColor *fg);
void		btn_button_set_color_bg(Button *btn, BtnFace face, const GdkColor *bg);
void		btn_button_set_color_bg_widget(GtkWidget *widget, BtnFace face, const GdkColor *bg);
void		btn_button_set_color_fg(Button *btn, BtnFace face, const GdkColor *fg);
void		btn_button_set_color_fg_widget(GtkWidget *widget, BtnFace face, const GdkColor *fg);

/* Get definition from widget instance. */
Button *	btn_button_get(GtkWidget *wid);

const gchar *	btn_button_get_label(Button *btn, BtnFace face);
const gchar *	btn_button_get_cmdseq(Button *btn, BtnFace face);
const gchar *	btn_button_get_key(Button *btn, BtnFace face);
gboolean	btn_button_get_color_bg(Button *btn, BtnFace face, GdkColor *bg);	/* Returns FALSE if color not valid. */
gboolean	btn_button_get_color_fg(Button *btn, BtnFace face, GdkColor *fg);

void		btn_button_set_tooltip(Button *btn, const gchar *tip);
const gchar *	btn_button_get_tooltip(Button *btn);

void		btn_button_set_flags(Button *btn, guint32 flags);
guint32		btn_button_get_flags(Button *btn);
void		btn_button_set_flags_boolean(Button *btn, guint32 mask, gboolean value);
gboolean	btn_button_get_flags_boolean(Button *btn, guint32 mask);

gboolean	btn_button_is_blank(Button *btn);

void		btn_button_clear(Button *btn);
void		btn_button_swap(Button *a, Button *b);
void		btn_button_copy(Button *dst, Button *src);
void		btn_button_copy_colors(Button *dst, Button *src);
void		btn_button_destroy(Button *b);

ButtonRow *	btn_buttonrow_new(gint width);
ButtonRow *	btn_buttonrow_default(MainInfo *min);
ButtonRow *	btn_buttonrow_copy(ButtonRow *src);
void		btn_buttonrow_set_width(ButtonRow *brw, guint width);
guint		btn_buttonrow_get_width(ButtonRow *brw);
void		btn_buttonrow_destroy(ButtonRow *brw);

ButtonSheet *	btn_buttonsheet_new(const gchar *label);
ButtonSheet *	btn_buttonsheet_default(MainInfo *min);
ButtonSheet *	btn_buttonsheet_copy(ButtonSheet *src);
void		btn_buttonsheet_append_row(ButtonSheet *bsh, ButtonRow *brw);
void		btn_buttonsheet_insert_row(ButtonSheet *bsh, ButtonRow *brw, gint width);
void		btn_buttonsheet_delete_row(ButtonSheet *bsh, ButtonRow *brw);
void		btn_buttonsheet_move_row(ButtonSheet *bsh, ButtonRow *brw, int delta);
guint		btn_buttonsheet_get_height(ButtonSheet *bsh);
ButtonSheet *	btn_buttonsheet_get(ButtonInfo *bti, char *label);
GtkWidget *	btn_buttonsheet_build(MainInfo *min, ButtonInfo *bti, const char *label, gint partial, GtkSignalFunc func, gpointer user);
void		btn_buttonsheet_built_add_keys(MainInfo *min, GtkContainer *sheet, gpointer user);
void		btn_buttonsheet_destroy(ButtonSheet *bsh);


