# class which stores and manipulates a variable
package Var;
use Tk;

@widget_classes = qw (Scale Entry Radiobutton Checkbutton);

sub new {
    my $self;
    my($class)= shift;
    $self={};
    bless $self,$class;
#    print STDERR "cre $class\n";
    $self->{MaxStore} = 10;
    $self->set_value(undef);
    $self->{PanelWidgetClass} = 'None';
    $self->{Store} = [];
    $self->set_value(shift) if @_;
    $self->set_panel_widget_class(shift)  if @_;
    $self->set_prefix('');
    return $self;
}

sub set_name_title {
    my $self = shift;
    ($self->{Name},$self->{Title}) = @_;
}

sub get_name_title {
    my $self = shift;
    return($self->{Name},$self->{Title});
}

sub set_name {
    my $self = shift;
    ($self->{Name}) = @_;
}


sub get_name {
     my $self = shift;
    return($self->{Name});
}
   

# leading and trailing whitespace
sub prune {
    my $self = shift;
    return unless defined $self->get_value();
    ${$self->get_value_ref} =~ s/^\s*//;
    ${$self->get_value_ref} =~ s/\s*$//;
}    

# a value of zero is ok
sub is_set {
    my $self = shift;
    return(1) if defined $self->get_value() and $self->get_value() ne '';
    return undef;
}



# push old values on a stack ?
sub set_value{
    my $self = shift;
    die "set_value must be called with one argument." unless @_ == 1;
    my $newvalue = shift;
    if ( not defined $newvalue ) {
	$newvalue = '';
    }
# try adding this to get rid of setting nothing. Will it break something ?
# take it out, need it to 'unset' a value
#    return if $newvalue =~ /^\s*$/;
    my $old = $self->get_value();
#    return unless defined $old;
    if( not defined $old or $old  ne $newvalue) {
	my $flag = 0;
	my $i;
	for($i=0;$i<@{$self->{Store}};$i++) { 
	    $flag = $i if $self->{Store}->[$i] eq $newvalue;}
	if($flag == 0) {
	    unshift @{$self->{Store}}, $newvalue;
	}
	else {
	    $self->pop_value($flag);
	}
    }
#    $self->{Value}=$newvalue ;
#    &main::debug(0,join ":",@{$self->{Store}});
    $self->prune;
    $self->trim_store()
}

#sub set_value_no_store {
#    my $self = shift;  
#    $self->{Value} = shift;
#    $self->prune;
#}

sub trim_store {
    my $self = shift;
    return unless @{$self->{Store}};
#    print STDERR "$self:st: '$self->{MaxStore}' " . scalar (@{$self->{Store}}) . ";\n";
#    print STDERR $self->{Name}, "\n";
    while (@{$self->{Store}} > $self->{MaxStore}) {
	pop @{$self->{Store}}
    }
}


sub set_store_size {
    my $self = shift;
    return unless $_[0] > 0; #partly to check if a number, hopefully
    $self->{MaxStore} = shift;
}

sub get_value{
    my $self=shift;
    return $self->{Store}->[0];
}

sub get_value_ref {
    my $self=shift;
    return \$self->{Store}->[0];
}



sub get_store{
    my $self=shift;
    return @{$self->{Store}};
}

sub get_one_store {
    my $self=shift;
    my $i = shift;
    return $self->{Store}->[$i];
}

sub pop_value {
    my $self=shift;
    my $i = shift;
    my $tmp = splice @{$self->{Store}},$i,1;
    unshift @{$self->{Store}},$tmp;
#    $self->{Value} = $tmp;
    $self->prune();
}

sub delete_from_store {
    my $self=shift;
    my $i = shift;
    splice @{$self->{Store}},$i,1;
}

sub clear_store {
    my $self=shift;
    
}

sub reset {
    my $self=shift;
#    $self->{Value} = undef;
    $self->{Store} = [];
}

sub get_command {
    my $self = shift;
    $self->prune;
    return undef unless $self->is_set;
# try assuming empty value is turned off
    my $val = $self->get_value();
    return undef unless defined $val and not $val=~ /^\s*$/;
    return $self->{Prefix} . '  ' . $self->get_value();
}

sub set_prefix {
    my $self = shift;
    $self->{Prefix} = shift;
}

sub get_prefix {
    my $self = shift;
    $self->{Prefix}
}


sub dump_value {
    my $self = shift;
    die "dump_value: requires a filehandle as an argument." unless @_ == 1;
    my $hand = shift;
    print $hand $self->{Name},"  ",$self->get_value(),"\n";
}

sub check_panel_widget_class {
    my $self = shift;
    my $f;
    foreach(@widget_classes) {
	if ($_ eq  $self->{PanelWidgetClass}) { $f=1;}
    }    
    return undef unless defined $f;
    return 1;
}

sub set_panel_widget_class {
    my $self = shift;
    die "set_panel_widget_class: requires one arg" unless @_ == 1;
    my $widget = shift;
    die "set_panel_widget_class takes a string, not a reference"
	if defined $$widget;
    $self->{PanelWidgetClass} = $widget;
    die "set_panel_widget_class: Var does not know widget type $widget" 
	unless $self->check_panel_widget_class;
    $self->set_store_size(1) unless $widget eq 'Entry';
    return 1;
}

sub get_panel_widget_class {
    my $self = shift;
    return $self->{PanelWidgetClass};
}

sub initialize_panel {
    my $self = shift;
    die "Panel widget class not set." unless defined $self->{PanelWidgetClass};
    die "Unknown widget class" unless $self->check_panel_widget_class;
    $self->{PanelTemp} = undef;
    $self->{PanelTemp} = $self->get_value() if defined $self->get_value();
    return 1;
}

sub set_panel_toplevel {
    my $self = shift;
    my $t = shift;
    die "Bad arg to set_panel_toplevel" unless
	defined $t and Exists $t;
    $self->{PanelToplevel} = $t;
}

sub toplevel_q {
    my $self = shift;
    return 1 if exists $self->{PanelToplevel}
       and Exists $self->{PanelToplevel};
    return undef;
}


sub put_value_on_panel {
    my $self = shift;
    if ($self->{PanelWidgetClass} eq 'Entry') {
	if (Exists($self->{WidgetRef})) {
	    $self->{WidgetRef}->delete('0','end');
	    $self->{WidgetRef}->insert('0',$self->get_value());   
	    $self->{WidgetRef}->xview('end');
	}
    }
    elsif($self->{PanelWidgetClass} eq 'Radiobutton' or
       $self->{PanelWidgetClass} eq 'Scale' or 
	  $self->{PanelWidgetClass} eq 'Checkbutton') {
	$self->{PanelTemp}=$self->get_value();
    }
    return 1;
}
 
sub  get_value_from_panel {
    my $self = shift;
#    print STDERR "PanelWidgetClass: $self->{PanelWidgetClass}\n";
    if ($self->{PanelWidgetClass} eq  'Entry') {
	$self->set_value($self->{WidgetRef}->get());
    }
    else {
	$self->set_value($self->{PanelTemp});;
    }
}


sub get_panel_ref {
    my $self=shift;
    $self->initialize_panel();
    return \$self->{PanelTemp};
}

sub put_panel_ref {
    my $self=shift;
    my $reflist;
    if ($self->{PanelWidgetClass} eq 'Entry') {
     $self->{WidgetRef} = shift;
     die "put_panel_ref: Non-Existent Widget reference" unless Exists $self->{WidgetRef};	
     $self->{WidgetRef}->bind('<Shift-1>' => sub{ &main::pop_tool($self);});
     $self->{WidgetRef}->bind('<Return>' => 
		sub{ &main::set($self,$self->{WidgetRef}->get() );});
     $self->{WidgetRef}->bind('<Button-3>' =>
			     sub{ &main::history_list($self);});
	return 1;
    }
    if ($self->{PanelWidgetClass} eq 'Radiobutton') {
#    print STDERR "Ready for Radiobutton\n";
      $reflist = shift;
      die "Radiobutton needs ref to array of widget refs" unless
	defined @$reflist;
      $self->initialize_panel();
      foreach (@$reflist ) {
#	    print STDERR "configuring one\n";

	      $_->configure(-variable => \$self->{PanelTemp});
        $_->bind('<3>' =>
			     sub{ &main::history_list($self);});
	}
	return 1;
    }
    if ($self->{PanelWidgetClass} eq 'Checkbutton') {
	$self->{WidgetRef} = shift;
	$self->initialize_panel();
	$self->{WidgetRef}->configure(-variable => \$self->{PanelTemp});
	return 1;
    }
    die "put_panel_ref: $self->{PanelWidgetClass} not a valid widget class" .
	" for this method";
}

sub has_widget {
    my $self=shift;
    return 1 if exists $self->{WidgetRef} and Exists $self->{WidgetRef};
    return undef;
}

1;

