/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include "MwmUtil.h"
#include "gtkhelp.h"

#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#else
#include <wait.h>
#endif

#include <sys/signal.h>
#include <sys/types.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <string.h>
#include <stdlib.h>
#include "shell.h"
#include "global.h"
#include "iconmanager.h"
#include "filemanager.h"
#include "namedemultiplexer.h"
#include "iwc.h"

pid_t process;

int shellexitvar;
int killed;

GtkWidget *shell_window;
GtkWidget *shell_table;
GtkWidget *shell_obj_info;
GtkWidget *prgobj;

char* sourcename;
char* destname;
int init=0;
int numberof=0;
int thisnumber;

void KillCallback(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  killed=True;
  shellexitvar=1;
  if (process!=0)
    kill(process,SIGTERM);
  gtk_main_quit ();
}

void KillCallback2(GtkWidget *widget, gpointer data)
{
  killed=True;
  shellexitvar=1;
  if (process!=0)
    kill(process,SIGTERM);
  gtk_main_quit ();
}

void sigchildren()
{
  shellexitvar=1;
  /*gtk_main_quit ();*/
}

void ShellWindowInit(int nof)
{
  GtkWidget *obj;

  sourcename=NULL;
  destname=NULL;
  numberof=nof;
  
  process=0;
  killed=False;
  init=0;

  shell_window = gtk_window_new (GTK_WINDOW_DIALOG);
  shell_table=mygtk_setwindowsize(shell_window,300,80);
  
  shell_obj_info = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(shell_obj_info), "---" );
  gtk_entry_set_editable( GTK_ENTRY(shell_obj_info),False);
  mygtk_setposition(shell_table,shell_obj_info,0,0,300,30);

  obj = gtk_button_new_with_label ("Stop...");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (KillCallback2), (gpointer) "Stop...");
  mygtk_setposition(shell_table,obj,0,50,300,30);

  prgobj = gtk_progress_bar_new ();
  gtk_progress_bar_update (GTK_PROGRESS_BAR (prgobj), 0.0);
  mygtk_setposition(shell_table,prgobj,0,30,300,20);

  gtk_signal_connect (GTK_OBJECT (shell_window), "delete_event",
                      GTK_SIGNAL_FUNC (KillCallback), NULL);
}

void ShellWindowInfo(char *namet,char *names,char *named,int this)
{
  thisnumber=this;
  free(sourcename);
  free(destname);
  init=0;
  sourcename=strdup(names);
  if (sourcename[0]=='~' && sourcename[1]=='/')
    sourcename[0]='.';
  destname=strdup(named);
  if (destname[0]=='~' && destname[1]=='/')
    destname[0]='.';
  gtk_entry_set_text( GTK_ENTRY(shell_obj_info), names );
  gtk_window_set_title(GTK_WINDOW(shell_window),namet);
}

int ShellWindowUpdate()
{
  return killed;
}

void timeoutcall(gpointer data)
{
  gfloat range;
  static struct stat infos;
  struct stat infod;
  if (destname!=NULL && sourcename!=NULL) {
  if (init==0) {
    stat(sourcename,&infos);
    init++;
  }
  if (stat(destname,&infod)==0) {
  range=(gfloat)thisnumber;
  if (sourcename[strlen(sourcename)-1]=='/') {
    if (infos.st_nlink<=2 || infod.st_nlink==1)
      range+=0.5;
    else if (infod.st_nlink!=0)
      range+=(2.0*((gfloat)infod.st_nlink-2.0)+1.0)/
             (2.0*((gfloat)infos.st_nlink-1.0));
  } else
    range+=(gfloat)infod.st_size/(gfloat)infos.st_size;
  gtk_progress_bar_update (GTK_PROGRESS_BAR (prgobj), 
                           (1.0/(gfloat)numberof)*range);
  }
  }
}

int ShellWindowDoIt(char** argv,int cont)
{
  int ret;
  int tio;
  char* setpath;
  /*XEvent event;*/
  /*static Atom motif_wm_hints= None;
  MotifWmHints hints;*/
  
  shellexitvar=0;
  signal(SIGCHLD,sigchildren);
  if ((process=fork())==0) {
    if (cont==True) {
      if (IsSubDesktop()==False) {
        setpath=ExpandTilde(GetPath());
        chdir(setpath);
        setenv("PWD",setpath,True);
        free(setpath);
      }
      if (fork()!=0) 
        _exit(0);
    }
    execvp(argv[0],argv);
    _exit(-1);
  } else {
    if (cont==False) {
      if (shellexitvar==0 && numberof!=0) {
        gtk_window_position(GTK_WINDOW(shell_window),GTK_WIN_POS_CENTER);
        gtk_widget_show(shell_table);
        gtk_widget_show(shell_window);
        tio=gtk_timeout_add( 100,(GtkFunction)timeoutcall,NULL);
        while (shellexitvar==0) {
          gtk_main_iteration();
        } 
        gtk_timeout_remove( tio );      
      }
    }
    wait(&ret);
  }
  process=0;
  if (killed==True)
    return BREAK_ERROR;
  else {
    if (ret==0)
      return NO_ERROR;
    else
      return ASK_FOR_DELETE_ERROR;   
  }
}

void ShellWindowDestroy()
{
  gtk_widget_destroy(shell_window);
  while (gtk_events_pending())
    gtk_main_iteration(); 
  if (GetIsDesktop()==True) {
    XLowerWindow(GetDisplay(),GetWindow());
    LowerIcons();
  }
  free(sourcename);
  free(destname);
  numberof=0;
}
