.\" t
.\" @(#)Pager.1		12/10/98
.TH Pager 1.6 "Dec 10 1998" Pager
.UC
.SH NAME
\fBPager\fP \- the Afterstep desktop Pager module

.SH SYNOPSIS
\fBPager\fP is spawned by afterstep, so no command line invocation will
work.
.sp
From within the \fIautoexec\fP file or as a menu option, Pager is spawned as
follows:
.nf
.sp
	Module	"I"	Pager begining_desktop# ending_desktop#
	Wait		"I"	Pager
.sp
.fi
\fIWait\fP can be used as shown above for transparent Eterms.  This will
insure that the \fBPager\fP has set the root background before it starts
any furthur apps (like Eterms).
.sp
or from within an afterstep menu file by 'Pager':
.nf
.sp
% cat "~/GNUstep/Library/AfterStep/start/Modules/Pager"
	Module "Pager" Pager begining_desktop# ending_desktop#
	MiniPixmap "mini-as.xpm"
.fi

To stop the \fBPager\fP module, a menu item can be used:
.nf
.sp
% cat "~/GNUstep/Library/AfterStep/start/Modules/Pager_Stop"
	KillModuleByName "Stop Pager" Pager
	MiniPixmap "mini-as.xpm"
.fi

.SH DESCRIPTION
The \fBPager\fP module shows a miniature view of the Afterstep desktops
which are specified in the command line. This is a useful reminder of
where your active windows are. Windows in the pager are shown in the same
color as their afterstep decorations. 

The \fBPager\fP can be used to change your viewport into the current
desktop, to change desktops, or to move windows around.

Pressing mouse button 1 or 2 in the \fBPager\fP will cause your viewport
to change to the selected page of the selected desk. If you click with
button 1 in the desk-label area, you will switch desks but not
pages within the desk.

Clicking and dragging with mouse button 2 on a miniature window in the
\fBPager\fP will cause that window to be move to the location where you
release the mouse button, but your viewport will not change. If you drag
the window out of the pager and onto your desktop, a full size image of
the window will appear for you to place. There is no way to
pick up a full size image of the window and move it into the \fBPager\fP,
however. Since some mice do not have button 2, provisions have been made to
drag windows in the \fBPager\fP by pressing modifier-1 (usually Alt) and
dragging with button 3.

When iconified, the pager will work as a fully functional current page
only pager. Windows and viewports can be moved within the icon of the
pager. Users will want to make sure that they have no lines similar to
.nf
.sp
	Style	"Pager"	Icon myIcon.[xpm|jpg|png]
.sp
.fi
in their feel files.

.SH INITIALIZATION
During initialization, \fBPager\fP will search for a configuration file
which describes the images, locations and actions to take. The configuration
file is  /usr/local/share/afterstep/pager; but can be overriden by ~/GNUstep/Library/AfterStep/pager .

If the \fBPager\fP executable is linked to another name, ie ln -s
\fBPager\fP \fBOtherPager\fP, then another module called \fBOtherPager\fP
can be started, with a completely different set of configurations than
\fBPager\fP, simply by adding \fI*OtherPager\fP options following the same
\fI*Pager\fP configuration options below to the \fIpager\fP file. This way
multiple Pager programs can be used.

.SH KEYBOARD FOCUS CONTROL
You can direct the keyboard focus to any window on the current desktop
by clicking with button 2 on its image in the pager. The window does
not need to be visible, but it does need to be on the current page.

.SH INVOCATION
\fBPager\fP can be invoked from the \fIautoexec\fP file or from a menu
item as shown in the Synopsis section above.

AfterStep will search through the directories specified in the
\fIModulePath\fP configuration in the \fIbase.#bpp\fP (where # is your
colordepth) to attempt to locate \fBPager\fP.

.SH CONFIGURATION FILES
\fBPager\fP reads the \fIbase.#bpp\fP file and \fIpager\fP file when it
starts up and looks for its configuration options.

.SH CONFIGURATION OPTIONS \- \fIbase.#bpp\fP
The following two configuration options are in the \fIbase.#bpp\fP file:

.IP "*DeskTopSize \fIColumnsxRows\fP
Defines the number of view \fIColumns\fP by the number of view
\fIRows\fP of the desk(s) in proportional units, i.e. 2x1 would show
2 views of one desk, one beside another.

.IP "*DeskTopScale \fInumber\fP"
If the geometry is not specified, then a desktop reduction factor is
used to calculate the pager's size. Things in the pager window
are shown at 1/\fInumber\fP of the actual size.

.SH CONFIGURATION OPTIONS \- \fIpager\fP
The following configuration options are in the \fIpager\fP file:

.IP "Balloons"
Turns on the balloon feature. A "balloon" is displayed showing the name of
the window the pointer is resting on in the \fBPager\fP.
Currently only the window's icon name is shown. Note that balloons are
not shown for the iconified pager.

.IP "BalloonFore \fIcolor\fP"
Specifies the color for text in the balloon window. If omitted it
defaults to the foreground color for the window being described.

.IP "BalloonBack \fIcolor\fP"
Specifies the background color for the balloon window. If omitted it
defaults to the background color for the window being described.

.IP "BalloonFont \fIfont-name\fP"
Specifies a font to use for the balloon text. Defaults to \fIfixed\fP.

.IP "BalloonBorderWidth \fInumber\fP"
Sets the width of the balloon window's border. Defaults to 1.

.IP "BalloonBorderColor \fIcolor\fP"
Sets the color of the balloon window's border. Defaults to black.

.IP "BalloonYOffset \fInumber\fP"
The balloon window is positioned to be horizontally centered against
the application window it is describing. The vertical position may be
set as an offset. Negative offsets of \fI-N\fP are placed \fIN\fP
pixels above the pager window, positive offsets of \fI+N\fP are placed
\fIN\fP pixels below. Defaults to +2.

.IP "BalloonDelay \fInumber\fP"
Specifies the period in milliseconds to delay the appearance of the balloon.

.IP "HiForeColor \fIcolor\fP"
Specifies the color for the text in the focused (hilighted) window. If
omitted, the default is black.

.IP "HiBackColor \fIcolor\fP"
Specifies the background color for the focused (hilighted) window. If
omitted, the default is white.

.IP "MaxBackgroundColors \fInumber\fP"
If specified, the number of colors used for backgounds is limited to
\fInumber\fP. This feature is implemented in the library for the image format used [XPM, JPEG, PNG] and might not always yield the results one would
expected.

.IP StickyPagerIcon
Allows the icons of iconified windows to follow you when switching desks.
Without this option, the icons would stick to the desk the window was
iconified in.

.IP "*PagerFore \fIcolor\fP"
Specifies the color to use to write the desktop labels, and
to draw the page-grid lines.

.IP "*PagerBack \fIcolor\fP"
Specifies the background color for the window and label backgrounds.

.IP "*PagerHilight \fIcolor\fP"
Specifies the hilight color of the active page (view) and desk label.

.IP "*PagerFont \fIfont-name\fP"
Specifies a font to use to label the desktops. If \fIfont-name\fP is
"none" then no desktop labels will be displayed.

.IP "*PagerSmallFont \fIfont-name\fP"
Specifies a font to use to label the window names in the pager. If
\fIfont-name\fP is "none" then the window labels will be omitted.
Window labels seem to be fairly useless for desktop scales of 32
or greater.

.IP "*PagerGeometry \fIgeometry\fP"
Completely or partially specifies the pager windows location and
geometry, in standard X11 notation. In order to maintain an undistorted
aspect ratio, you might want to leave out either the width or height
dimension of the geometry specification.

.IP "*PagerImage \fIdesk image\fP"
Sets the \fIimage\fP to be used for the desk \fIdesk\fP representation
in the \fBPager\fP. Where \fIimage\fP can be of either JPEG, XPM, or PNG
format, and \fIdesk\fP is a number coresponding to the desktop number:
0,1,2,3,N.... Use it if you want to specify a different image for
\fBPager\fP background other than the default; which is the upper left
hand portion of the \fI*PagerDesktopImage\fP.
.sp
.nf
*PagerImage \fIdesk\fP ~/path/my.[xpm|jpg|png]
.sp
.fi
To use the default behavior:
.nf
*PagerImage \fIdesk\fP ~/GNUstep/Library/AfterStep/non-configurable/\fIdesk\fP_background
.sp
.fi

.IP "*PagerDesktopImage \fIdesk image\fP"
Sets the \fIimage\fP to be used for the Root Window background of desk
\fIdesk\fP. Where \fIimage\fP must be either JPEG or XPM format, and
\fIdesk\fP is a number coresponding to the desktop number: 0,1,2,3,N....
The image will be also scaled down and used as background for the Desktop
representation in the Pager window if \fI*PagerImage\fP is not specified.
If image is not XPM or JPEG format, external image loader application will
be used to display it on Root. That application is specified at compilation
time.
.nf
.sp
*PagerDesktopImage \fIdesk\fP ~/GNUstep/Library/AfterStep/non-configurable/\fIdesk\fP_background
for each \fIdesk\fP you use.
.sp
.fi
To use the same image for all desks and improve loading time:
.nf
.sp
*PagerDesktopImage 0 ~/GNUstep/Library/AfterStep/non-configurable/0_background
see also \fI*PagerFastStartup\fP below.
.sp
.fi

.IP "*PagerXImageLoaderArgs \fI[desk] arg1 arg2 ... argN\fP"
This option will let you overide external image loader args specified at
compilation time for desk \fIdesk\fP, or all desks if \fIdesk\fP is ommited.
\fBWarning:\fP
When \fIdesk\fP is used to specify desk - it will also disable internal XPM
and JPEG support for this desk!
.nf
.sp
*PagerXImageLoaderArgs \fIdesk\fP -fillscreen -onroot -quiet
.sp
.fi
The default \fIXImageLoader\fP is xli, check that program's man page for
other options to use aside from those in the above example.

.IP "*PagerFastBackground \fIdesk yes/no [tile_hsize [tile_vsize]]\fP"
This option has only effect, when you are using non-XPM and non-JPEG files
as the root background. When set to 'yes' it will store image, displayed by
external viewer application, in memory, using it later on when you switch
between \fIdesks\fP. That can grately increase speed, but will also result in
more memory used (apprx. 1Mb per desktop ), therefore it is not recommended
on systems with a small amount of RAM. If you are using a small image tiled
on your root, you will want to specify image sizes in \fItile_hsize\fP and
\fItile_vsize\fP to reduce memory used. If you ommit any of these, the
screen dimension will be used. Also, to reduce memory used, you can set
this to 'yes' only for most used desks. By default
\fI*PagerFastBackground\fP is set to No and tile size set to the screen
dimentions.

.IP "*PagerAlign \fILabelPosition\fP"
Sets the alignment of the labels for the desktops. Use 0 for centered,
>0 for left, <0 for right alignment. If <>0 the absolute value of
\fILabelPosition\fP will be the distance between label text and
window border.

.IP "*PagerLabel \fIdesk label\fP"
Assigns the text \fIlabel\fP to desk \fIdesk\fP in the pager window.
Useful for assigning symbolic names to desktops, ie

.IP "*PagerRedrawBg \fInumber\fP"
If 0, will not update background change, use this with xearth or xfishtank.
Default is 1, i.e. update background.

.IP "*PagerRows \fIrows\fP"
Tells afterstep how many rows of desks to use when laying out the pager
window. Set to 1 for horizontal \fBPager\fP and define \fIPagerColumns\fP.

.IP "*PagerColumns \fIcolumns\fP"
Tells afterstep how many columns of desks to use when laying out the pager
window. Set to 1 for vertical \fBPager\fP and define \fIPagerRows\fP.

.IP "*PagerIconGeometry \fIgeometry\fP"
Specifies a size (optional) and location (optional) for the pager's icon 
window. Since there is no easy way for Pager to determine the height of the
icon's label, you will have to make an allowance for the icon  label height
when using negative y-coordinates in the icon location specification (used to
specify a location relative to the bottom instead of the top of the screen).

.IP "*PagerStartIconic"
Causes the pager to start iconified. 

.IP "*PagerFastStartup"
During startup causes Pager to inform AfterStep, that it is already 
started, after loading background for the first desk. The will also 
set global atom for background pixmap, so Eterm can use it to emulate
transparency.  This background will be set to the background of first
desk of starting Pager. In case you have several Pagers starting up (for
different desks), it's wise to start Pager for desk 0, after all other
Pagers, so to get correct value for this background pixmap. 

.SH FILES

.IP \fI/usr/local/share/afterstep/pager\fP
The global configuration file for system wide defaults of all users.

.IP \fI$HOME/GNUstep/Library/AfterStep/pager\fP
This file should be copied from the \fI/usr/local/share/afterstep/pager\fP and edited to suit the user's specific requirements.  This file, if it exists,
will override the system wide default file.

.IP \fI/usr/local/share/afterstep/base.[8|15|16|24|32]bpp\fP
Contains the \fIDeskTopSize\fP & \fIDeskTopScale\fP global settings for the
\fBPager\fP.

.IP \fI$HOME/GNUstep/Library/AfterStep/base.[8|15|16|24|32]bpp\fP
This file should be copied from the
\fI/usr/local/share/afterstep/base.[8|15|16|24|32]bpp\fP and edited to suit the user's specific requirements for the \fIDeskTopSize\fP & \fIDeskTopScale\fP settings of the \fBPager\fP.

.SH EXAMPLES
The \fIpager\fP file shipped contains many examples, refer to the \fBFILES\fP
section above for its configuration options.

To have a \fBPager\fP oriented vertical on the desktop with 2 desks and
1 view for each desk:
.sp
	...the \fIautoexec\fP file would contain \-
.nf
	Module	"I"	Pager 0 1
	Wait		"I"	Pager
.sp
.fi
	...the \fIbase.#bpp\fP file would contain \-
.nf
	DeskTopSize 1x1
.sp
.fi
	...the \fIpager\fP file would contain (this modification) \-
.nf
	*PagerRows	2
	*PagerColumns	1
.sp
.fi
To have the \fBPager\fP swallowed in the \fBWharf\fP on one button, with
only 1 desk and 4 views:
.sp
	...the \fIwharf\fP file would contain \-
.fi
	*Wharf Pager \- SwallowModule "Pager" Pager 0 0
.sp
.fi
	...the \fIbase.#bpp\fP file would contain \-
.nf
	DeskTopSize 2x2
.sp
.fi
	...the \fIpager\fP file would contain (this modification) \-
.nf
	*PagerRows	1
	*PagerColumns	1
.sp
.fi
An example of the \fBPager\fP swallowed in the \fBWharf\fP as a \fIFolder\fP
is an example within the \fIwharf\fP file shipped.

.SH AUTHORS
Robert Nation
.nf
Alfredo Kojima
.nf
Guylhem Aznar
.nf
Ric Lister
.nf
Sasha Vasko
.nf
David Mihm <davemann@ionet.net> [Man page]

.SH SEE ALSO
.BR afterstep (1),
.BR Wharf (1),
.BR xli (1),
.BR X (1)
