#ifndef AFTERSTEP_IMAGE_FORMAT_SUPPORT_HEADER
#define AFTERSTEP_IMAGE_FORMAT_SUPPORT_HEADER

/* all posiible image file formats */
#define F_UNKNOWN      0
#define F_XPM          1
#define F_JPEG         2
#define F_GIF          3 
#define F_PNG          4 
#define F_TIFF         5
#define F_PM           6
#define F_PBMRAW       7
#define F_PBMASCII     8
#define F_XBM          9
#define F_SUNRAS       10
#define F_BMP          11
#define F_PS           12
#define F_IRIS         13
#define F_AUTO         14
#define F_PCX          15
#define F_TARGA        16
#define F_PCD          17

typedef struct load_image_params
{
   Display*         m_dpy;
   Window           m_w ;
   unsigned long    m_max_colors ;
   int              m_max_x, m_max_y ;
   Visual*          m_visual ;
   Colormap         m_colormap ;
   int              m_depth ;
   const char*            m_realfilename ;
   
   /* internal use : that will be initialized by LoadImage */
   XImage*          m_pImage ;  
   XImage*          m_pMaskImage ;  
   int              m_width, m_height ;
   GC               m_gc ;

   /* Output */
   Pixmap          m_Target;
   Pixmap          m_Mask;
 
}LImageParams ;

#define MASK_DEPTH 1

extern int bReportErrorIfTypeUnknown ;

extern int CreateTarget( LImageParams* pParams );
extern int CreateMask( LImageParams* pParams );
extern void XImageToPixmap( LImageParams* pParams, XImage* pImage, Pixmap* pTarget, int depth );

extern Pixmap LoadImageWithMask( Display *dpy, Window w, unsigned long max_colors, const char* realfilename, Pixmap* pMask );
#define LoadImage(dpy,w,max_colors,realfilename) LoadImageWithMask(dpy,w,max_colors,realfilename,NULL)

#endif



