//<copyright>
//
// Copyright (c) 1995-96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>


//<file>
//
//
// Name :       gifimage.h
//
// Purpose :    Interface to class GifImage
//
// Created :    04 Jan 95    Bernhard Marschall
// Modified :   03 Aug 95    Bernhard Marschall
//
// $Id: gifimage.h,v 1.5 1996/02/29 12:42:32 bmarsch Exp $
//
// Description:
//
//</file>
//
// $Log: gifimage.h,v $
// Revision 1.5  1996/02/29 12:42:32  bmarsch
// Always call decodedInterlaced() callback after a pass (also
// in finishDecode())
//


#ifndef harmony_widgets_gifimage_h
#define harmony_widgets_gifimage_h

#include "libwidgets.h"
#include "rimage.h"

class GifImpl;


//<class>
//
// Name:       GifImage
//
// Purpose:    decoding of GIF images
//
//
// Public Interface:
// As in base class RasterImage.
//
//
// Description:
// GifImage decodes GIF images. It uses parts of the IJG's jpeg
// library. (These parts, which Implement the GIF to JPEG conversion.)
// That means, when decoding GIF's we pretend to decode it and
// compress it to JPEG.
//
//</class>


class GifImage : public RasterImage {
public:
  GifImage(FILE*, const char* fname, Raster*& raster,
           HgRasterCallback* = nil, boolean dither = true);
  virtual ~GifImage();

  virtual void decode(int numrows);
  virtual void finishDecode();
  virtual void abortDecode();
  virtual int not_live() const { return 0; }

private:
  GifImpl* impl_;
};

#endif
