// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1994,95,96,97
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        scenewin.h
//
// Purpose:     interface to 3D scene, managed with InterViews
//
// Created:     26 Jan 94   Michael Pichler
//
// Changed:     20 Feb 97   Alexander Nussbaumer (editing)
//
// Changed:     20 Feb 97   Michael Pichler
//
// $Id: scenewin.h,v 1.23 1997/04/30 10:37:05 mpichler Exp $
//
//</file>


#ifndef harmony_scene_scenewin_h
#define harmony_scene_scenewin_h


#include "scene3d.h"

#include <hyperg/utils/str.h>

#include <InterViews/enter-scope.h>
class Allocation;
class ApplicationWindow;
class Event;
class Patch;
class PolyGlyph;
class Session;
class Window;

#include <hyperg/Dispatch/enter-scope.h>
class IOHandler;

class GEContext;
class HG3dInputHandler;
class ProgressIndicator;
class SceneMenus;
class TextBrowser;


// mode enums

class NavMode
{
  public:
    enum { flip_obj, walk_around, fly_1, fly_2, heads_up, num_navmodes };
}; // navigation mode


class FlipMode
{
  public:
    enum { flip_all, flip_translate, flip_rotate, flip_zoom };
}; // submode of flip object (currently unused, may be reactivated in future)


class EditMode
{
  // may move this to Scene3D
  public:
    enum {
      ed_viewer,  // viewer mode (not editing), must be 0
      ed_select,  // selection mode (manipulation)
      ed_camera   // camera mode (during editing)
    };
}; // editing mode (anuss)



// SceneWindow
    

class SceneWindow: public Scene3D
{
  public:
    SceneWindow (Session*,              // create application window
      int wintitlestrid);               //   window title: index into STranslate
    virtual ~SceneWindow ();

    ApplicationWindow* appwin ()        // application window
    { return appwin_; }

    void toolbarLayoutChanged ();       // change in toolbar button allocation

    SceneMenus* menus ()                // menu class
    { return themenus_; }

    void redraw ();                     // redraw GL window

    void reset ();                      // reset scene and redraw

    void setCamera (                    // set a camera (no redraw)
      const point3D& position,
      const point3D& lookat,
      const vector3D* up = 0            // optional up vector
    );

    void drawAll (const Allocation&);   // draw scene and UI atop it

    void updateLanguage ();             // update language dependent components

    // Scene3D
    virtual void clear ();              // clear scene

    int readSceneFILE (FILE* file);     // read scene from file (uncompresses data)
    void progress (float p, int id);    // progress of reading scene
    void showNumFaces ();               // feedback: number of polygons

    void makeTempFileName (             // create a temporary file name
      RString& filename,                //   returned file name in tmpdir
      const char* prefix = 0            //   file name prefix (optional)
    );

    // error messages
    void errorMessage (const char*) const;  // error message (redirected into dialog)

    void loadTextureFile (              // load texture file into SDF material
      Material* mat, const char* file
    );
    int readTextureFile (               // load texture file into VRML texture node
      QvTexture2* node, const char* file
    );                                  //   returns non-zero on success

    int readInlineVRMLFile (            // read inline VRML, uncompress data
      QvWWWInline* node, const char* filename
    );
    int readInlineVRMLFILE (            // read inline VRML, progress feedback
      QvWWWInline* node, FILE* file
    );

    void selectionChanged ();           // for enabling/disabling menu items

    // viewpoint menu
    void registerCamera (               // add camera to viewpoint list
      const RString& truename,
      const RString& nickname,
      QvPerspectiveCamera*,
      QvOrthographicCamera*
    );

    // navigation modes
    void setNavigationMode (int mode);  // set navigation mode
    int navigationMode () const         // get current navigation mode
    { return navmode_; }
    static int modeDrawsUI (int mode)   // are drawings done atop scene
    { return (mode != NavMode::flip_obj); }

    void navigationHint (int);          // not to mix up with NavMode

    // flip object submode (currently unused)
    int flipObjectMode () const
    { return FlipMode::flip_all; }

    int anchorMotion () const           // motion when anchors highlighted
    { return anchormotion_; }           // (replaces AnchorMotion::active)
    void anchorMotion (int flag)
    { anchormotion_ = flag; }

    int velocityControl () const        // drag mouse to control velocity
    { return velocitycontrol_; }        // instead of movements in modes
    void velocityControl (int flag)     // walk and heads-up
    { velocitycontrol_ = flag; }

    int showFramerate () const          // time and framerate feedback
    { return measuretime_; }
    void showFramerate (int flag);
    void toggleShowFramerate ()
    { showFramerate (!measuretime_); }

    int localInlines () const           // load inlines/textures from files
    { return localinlines_; }

    // selection modes
    enum { SelectObject, SelectGroup };
    int selectionMode () const          // replaces Optselection::state
    { return selectionmode_; }
    void selectionMode (int flag)
    { selectionmode_ = flag; }

    // anchor activation
    void activateAnchor ();             // activate currently selected anchor

    virtual void beginFeedback ();      // feedback
    virtual void endFeedback ();        // (on activateAnchor)
    virtual void endFeedback (long, long)  { }  // IO-Callback
    void doEndFeedback (long a, long b)
    { endFeedback (a, b); }             // g++ patch

    // status line
    void statusMessage (const char*);   // give hint in status line (Scene3D)

    void setTitle (const char* title)   // set title/name of scene
    { title_ = title;  showTitle (); }
    void showTitle ();                  // show title in status line
    void showBSPInfo ();                // gmes, 19960529
    void showBSPInfo (
      unsigned long visible_faces,
      unsigned long hidden_faces,
      unsigned long back_faces);        // gmes, 19960529

    void giveNavigationHint ();         // navigation usage hint in status line

    // key handling
    void handleKeystroke (const Event&);  // handle key strokes

    GEContext* gecontext ()         { return gecontext_; }
    HG3dInputHandler* ihandler ()   { return hg3dinput_; }
    ProgressIndicator* progrind ()  { return progrind_; }
    double feedbacktime ()          { return feedbacktime_; }
    IOHandler* feedbackhandler ()   { return feedbackhandler_; }

    // spaceball initialisation
    static int init_spaceball (Window* win);  // returns non-zero if spaceball found

    // remote calls
    virtual void acceptRemoteRequests (Window*, int /*on*/)  { }
    virtual void propertyRemoteRequest (Window*, const Event&)  { }

    // editing (anuss)
    // (could be moved into Scene3D, not platform dependent)
    int getEditMode () const            // get current EditMode
    { return editmode_; }
    virtual void setEditMode (int mode);  // set EditMode
    int manipulationAllowed ()
    { return (editmode_ != EditMode::ed_viewer); }

    void sceneManipulated (int state);

    int continueOnSaveState ();         // from Scene3D
    void setInsertFlag (int flag)       // load: insert file at selected position
    { insertflag_ = flag; }

  private:
    int navmode_;
    SceneMenus* themenus_;
    ProgressIndicator* progrind_;
    RString title_;
    RString tmpdir_;

    int anchormotion_;
    int velocitycontrol_;
    int selectionmode_;
    int measuretime_;
    int localinlines_;

    // anuss
    int editmode_;
    int insertflag_;

    GEContext* gecontext_;
    HG3dInputHandler* hg3dinput_;
    PolyGlyph* mainvbox_;
    Patch* mainwinpatch_;
    ApplicationWindow* appwin_;
    double feedbacktime_;  // ms
    IOHandler* feedbackhandler_;

    void makeappwin (Session*,          // create application window and gecontext
      int wintitlestrid);
    void setdefaults ();                // load Xdefaults

    int readSceneU (FILE*);             // read scene for uncompressed data

    int uploadTexture (                 // read image file, create ge3d texture
      const char* filename, int& alpha);

}; // SceneWindow



#endif
