// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tioinetattr.h
// 
// Purpose:     
// 
// Created:     6 Feb 1997   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tioinetattr.h,v 1.2 1997/02/12 23:13:11 jfasch Exp $
// 
// $Log: tioinetattr.h,v $
// Revision 1.2  1997/02/12 23:13:11  jfasch
// moved from HgDcCommon
//
// 
// </file> 
#ifndef hg_dispatch_tioinetattr_h
#define hg_dispatch_tioinetattr_h

#include <hyperg/utils/inetaddr.h>

class TIOINETAttributes {
public:
   TIOINETAttributes() {}
   TIOINETAttributes (const INETAddress& thisaddr, const INETAddress& thataddr) ;
   TIOINETAttributes& operator = (const TIOINETAttributes&) ;
   const INETAddress& outerThis() const { return outer_this_; }
   const INETAddress& outerThat() const { return outer_that_; }
private:
   INETAddress outer_this_ ;
   INETAddress outer_that_ ;
public:
   static const char* version1 ;
} ;
static const char* TIOINETAttributes_version = TIOINETAttributes::version1 ;
inline TIOINETAttributes :: TIOINETAttributes (const INETAddress& outerthis, 
                                               const INETAddress& outerthat) 
: outer_this_(outerthis),
  outer_that_(outerthat) {}

inline TIOINETAttributes& TIOINETAttributes :: operator = (const TIOINETAttributes& a) {
   outer_this_ = a.outer_this_ ;
   outer_that_ = a.outer_that_ ;
   return *this ;
}


#endif
