##############################################################################  
#   
# Zope Public License (ZPL) Version 0.9.7  
# ---------------------------------------  
#   
# Copyright (c) Digital Creations.  All rights reserved.  
#   
# This license has been certified as Open Source(tm).  
#   
# Redistribution and use in source and binary forms, with or without  
# modification, are permitted provided that the following conditions are  
# met:  
#   
# 1. Redistributions in source code must retain the above copyright  
#    notice, this list of conditions, and the following disclaimer.  
#   
# 2. Redistributions in binary form must reproduce the above copyright  
#    notice, this list of conditions, and the following disclaimer in  
#    the documentation and/or other materials provided with the  
#    distribution.  
#   
# 3. Digital Creations requests that attribution be given to Zope  
#    in any manner possible. Zope includes a "Powered by Zope"  
#    button that is installed by default. While it is not a license  
#    violation to remove this button, it is requested that the  
#    attribution remain. A significant investment has been put  
#    into Zope, and this effort will continue if the Zope community  
#    continues to grow. This is one way to assure that growth.  
#   
# 4. All advertising materials and documentation mentioning  
#    features derived from or use of this software must display  
#    the following acknowledgement:  
#   
#      "This product includes software developed by Digital Creations  
#      for use in the Z Object Publishing Environment  
#      (http://www.zope.org/)."  
#   
#    In the event that the product being advertised includes an  
#    intact Zope distribution (with copyright and license included)  
#    then this clause is waived.  
#   
# 5. Names associated with Zope or Digital Creations must not be used to  
#    endorse or promote products derived from this software without  
#    prior written permission from Digital Creations.  
#   
# 6. Modified redistributions of any form whatsoever must retain  
#    the following acknowledgment:  
#   
#      "This product includes software developed by Digital Creations  
#      for use in the Z Object Publishing Environment  
#      (http://www.zope.org/)."  
#   
#    Intact (re-)distributions of any official Zope release do not  
#    require an external acknowledgement.  
#   
# 7. Modifications are encouraged but must be packaged separately as  
#    patches to official Zope releases.  Distributions that do not  
#    clearly separate the patches from the original work must be clearly  
#    labeled as unofficial distributions.  Modifications which do not  
#    carry the name Zope may be packaged in any form, as long as they  
#    conform to all of the clauses above.  
#   
#   
# Disclaimer  
#   
#   THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS ``AS IS'' AND ANY  
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR  
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL CREATIONS OR ITS  
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,  
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT  
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF  
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND  
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,  
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF  
#   SUCH DAMAGE.  
#   
#   
# This software consists of contributions made by Digital Creations and  
# many individuals on behalf of Digital Creations.  Specific  
# attributions are listed in the accompanying credits file.  
#   
##############################################################################  
#   
# Portions Copyright (c) 1999 by Butch Landingin.  
#   
# Redistribution and use in source and binary forms, with or without  
# modification, are permitted provided that the following conditions  
# are met:  
# 1. Redistributions of source code must retain the above copyright  
#    including the original copyright, this copyright notice, the list of   
#    conditions and the following disclaimer.  
# 2. Redistributions in binary form must reproduce the above copyright  
#    including the original copyright, this copyright notice, the list of   
#    conditions and the following disclaimer in the  
#    documentation and/or other materials provided with the distribution.  
# 3. The name of the author may not be used to endorse or promote products  
#    derived from this software without specific prior written permission  
#  
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR  
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES  
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,  
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT  
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,  
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY  
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT  
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF  
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  
#    
#  In accordance with the license provided for by the software upon  
#  which some of the source code has been derived or used, the following   
#  acknowledgement is hereby provided :  
#  
#      "This product includes software developed by Digital Creations  
#      for use in the Z Object Publishing Environment  
#      (http://www.zope.org/)."  
#   
##############################################################################  
"""Squishdot - a web-based news publishing and discussion system"""
  
__version__='$Revision: 1.6 $'[11:-2]  
  
  
from ImageFile import ImageFile  
from Globals import HTMLFile  
import Squishdot, Squishfile  
  
  
classes=('Squishdot.SquishSite',)  
  
meta_types=({'name':'Squishdot Site',  
             'action':'manage_addSquishdotForm'  
            },  
           )  
  
methods={'manage_addSquishdotForm':  
          HTMLFile('addSquishdotForm', globals()),  
         'manage_addSquishdot':  
          Squishdot.manage_addSquishdot,  
         'mailhost_list': Squishdot.SquishSite.mailhost_list,  
        }  
  
_squishdot_img = ImageFile('squishdot.gif',globals()) 
_posting_img = ImageFile('posting.gif',globals()) 
_comment_img = ImageFile('comment.gif',globals()) 
_squishfile_img = ImageFile('squishfile.gif',globals()) 
_squishlogo = ImageFile('squishlogo.gif',globals()) 
_squishdot_img.content_type = 'image/gif' 
_posting_img.content_type = 'image/gif' 
_comment_img.content_type = 'image/gif'  
_squishfile_img.content_type = 'image/gif' 
_squishlogo.content_type = 'image/gif'  
  
misc_={'squishdot_img':  _squishdot_img,  
       'posting_img':    _posting_img,  
       'comment_img':    _comment_img,  
       'squishfile_img': _squishfile_img,  
       'squishlogo':     _squishlogo  
      }  
  
  
__ac_permissions__=(('Add Squishdot Sites',  
                     ('manage_addSquishdot',   
                      'manage_addSquishdotForm'),  
                    ),  
                    ('Add postings', ()),  
                    ('Manage postings', ()),  
                   )  
  
__module_aliases__=(  
     ('Products.Discussion.Discussion', Squishdot),  
     ('Products.Discussion.FileObject', Squishfile),  
    )