#ifndef _NEW_SITE_H_
#define _NEW_SITE_H_

#include <gtk/gtk.h>

struct create_site_widget_set {
     GtkWidget *name;
     GtkWidget *hostname_choice;
     GtkWidget *username_choice;
   
     GtkWidget *checkdelete_choice;
     GtkWidget *checkmove_choice;
     GtkWidget *passiveftp_choice;
     GtkWidget *deletefirst_choice;
   
     GtkWidget *protocol_choice;
     GtkWidget *protocol_choice_menu;
     GtkWidget *password_choice;
     GtkWidget *local_choice;
     GtkWidget *remotedir_choice;
     GtkWidget *url_choice;
   
     GtkWidget *init_choice;
     GtkWidget *catchup_choice;

  /* private stuff */
     GtkWidget *sym_choice;
     GtkWidget *sym_choice_menu;
     GtkWidget *perms_choice;
     GtkWidget *perms_choice_menu;
};

/*
 * This function returns a widget in a component created by Glade.
 * Call it with the toplevel widget in the component (i.e. a window/dialog),
 * or alternatively any widget in the component, and the name of the widget
 * you want returned.
 */
GtkWidget*
get_widget                             (GtkWidget       *widget,
                                        gchar           *widget_name);


/* This is an internally used function to check if a pixmap file exists. */
gchar*
check_file_exists                      (gchar           *directory,
                                        gchar           *filename);
/* Use this function to set the directory containing installed pixmaps. */
void
add_pixmap_directory                   (gchar           *directory);

/* This is an internally used function to create pixmaps. */
GtkWidget*
create_pixmap                          (GtkWidget       *widget,
                                        gchar           *filename);

void set_proto (GtkWidget *menu_item, gpointer data);
void set_perms (GtkWidget *menu_item, gpointer data);
void set_sym (GtkWidget *menu_item, gpointer data);
GtkWidget* create_new_wiz_book (void);
void start_new_site_wizard(void);

#endif /* _NEW_SITE_H_ */







