/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    static Hashtable nullHashtable = new Hashtable();

    public static Hashtable parseQueryString(String string) {
        String[] stringArray = null;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            String string3 = HttpUtils.parseName(string2.substring(0, n), stringBuffer);
            String string4 = HttpUtils.parseName(string2.substring(n + 1, string2.length()), stringBuffer);
            if (hashtable.containsKey(string3)) {
                String[] stringArray2 = (String[])hashtable.get(string3);
                stringArray = new String[stringArray2.length + 1];
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    stringArray[n2] = stringArray2[n2];
                    ++n2;
                }
                stringArray[stringArray2.length] = string4;
            } else {
                stringArray = new String[]{string4};
            }
            hashtable.put(string3, stringArray);
        }
        return hashtable;
    }

    public static Hashtable parsePostData(int n, ServletInputStream servletInputStream) {
        byte[] byArray = null;
        if (n <= 0) {
            return null;
        }
        try {
            int n2;
            byArray = new byte[n];
            int n3 = 0;
            do {
                if ((n2 = servletInputStream.read(byArray, n3, n - n3)) > 0) continue;
                throw new IOException("short read");
            } while (n - (n3 += n2) > 0);
        }
        catch (IOException iOException) {
            return nullHashtable;
        }
        String string = new String(byArray, 0, 0, n);
        return HttpUtils.parseQueryString(string);
    }

    private static String parseName(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    n += 2;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static StringBuffer getRequestURL(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = httpServletRequest.getScheme();
        int n = httpServletRequest.getServerPort();
        String string2 = httpServletRequest.getServletPath();
        String string3 = httpServletRequest.getPathInfo();
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(httpServletRequest.getServerPort());
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        return stringBuffer;
    }
}

