package HNS::Template;
################################################################
# HNS::Template : template expander
#
# parameters : %[A-Za-z0-9_]+
#
# usage:
#   use HNS::Template;
#   use $templ = new HNS::Template;
#   $cmd_name = "NEW";
#   print $templ->Expand("command is %c.", {c=>$cmd_name});
#       or
#   $templ->SetTemplate("command is %c.");
#   $templ->SetParamValues(c=>$cmd_name);
#   print $templ->Expand;
#   exit;
#
# result:
#   command is NEW.
#
# $Id: Template.pm,v 1.2 1999/04/17 16:26:21 kenji Exp $
################################################################
use strict;
use ObjectTemplate;
$HNS::Template::ISA = qw(ObjectTemplate);

attributes qw(content template);

sub initialize($)
{
    my $self = shift;
    $self->content({});
}
sub SetTemplate($$)
{
    my ($self, $template) = @_;
    $self->template($template);
}
sub SetParamValues($%)
{
    my ($self, %parameters) = @_;

    while (my ($k, $v) = each(%parameters)){
	$self->content->{$k} = $v;
    }
}
sub Expand($;$$)
{
    my ($self, $template, $params) = @_;
    $template ||= $self->template;
    $params ||= $self->content;

    $template =~ s/%%/\34/g;
    $template =~ s/%{?([A-Za-z0-9_]+)}?/$$params{$1}/g;
    $template =~ s/\34/%/g;
    return $template;
}
1;
