<?php 
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: user.php3,v 1.8 1999/05/31 20:30:00 prenagha Exp $
# ---------------------------------------------------------------
include("bkprepend.php3");
page_open(array( "sess" => "bk_sess"
							,"auth" => "bk_cr_auth"
		          ,"perm" => "bk_perm"
		          ,"user" => "bk_user"));

$tpl->define(array(
  standard   => "common.standard.tpl",
  msg        => "common.message.tpl",
  error_msg  => "common.error_message.tpl",
  user_list  => "user.userlist.tpl",
  select_form  => "user.select.tpl",
  update_form  => "user.update.tpl",
  create_form  => "user.create.tpl",
  delete_form  => "user.delete.tpl"
));

set_standard("users", &$tpl);

### Get a database connection
$db   = new bk_db;

## Check if there was a submission
while ( is_array($HTTP_POST_VARS) 
     && list($key, $val) = each($HTTP_POST_VARS)) {
  switch ($key) {

  ## update canceled
  case "bk_cancel_update":
    $mode = "S";
	break;

  ## create canceled
  case "bk_cancel_create":
    $mode = "S";
	break;

  ## delete canceled
  case "bk_cancel_delete":
    $mode = "S";
	break;

  ## maintain user
  case "bk_user_update":
    ## Do we have permission to do so?
    if (!$perm->have_perm("admin")) {
      $error_msg = "You do not have permission to update users.";
      break;
    }

    ## trim form fields
		$perms = trim($perms);
		$name = trim($name);
		$email = $validate->strip_space($email);
		    
    ## Do we have all necessary data?
    if (empty($password) || empty($perms) || empty($name) || empty ($email)) {
      $error_msg = "Please fill out <B>Name</B>, <B>Email Address</B>, <B>Password</B> and <B>Permissions</B>!";
      break;
    }

	## Is email address in the proper format?
    if (!$validate->is_email($email))  { 
      $error_msg = "From address invalid. Format must be <strong>user@domain</strong> and domain must exist!<br><small> $validate->ERROR </small>";
      break;
	  }
    
    ## Update information
    $query = sprintf("update auth_user set password='%s', perms='%s', name='%s', email='%s' where username='%s'", md5($password), $perms, addslashes($name), $email, $username);
	
    $db->query($query);
    if ($db->affected_rows() == 0) {
      $error_msg = "<b>Update failed:</b> $query";
      break;
    }
    $mode = "S";
    $msg = "User &quot;$username&quot; changed.<BR>";
  break;

  ## Delete the user
  case "bk_user_delete":
    ## Do we have permission to do so?
    if (!$perm->have_perm("admin")) {
      $error_msg = "You do not have permission to delete users.";
      break;
    }
    
    ## Delete that user
    $query = sprintf("delete from auth_user where username='%s'", $username);
    $db->query($query);
    if ($db->affected_rows() == 0) {
      $error_msg =  "<b>Delete failed:</b> $query";
      break;
    }
    $mode = "S";
    $msg = "User &quot;$username&quot; deleted.<BR>";
  break;

  ## Create a new bookmark
  case "bk_user_create":

    ## Do we have permission to do so?
    if (!$perm->have_perm("admin")) {
      $error_msg = "You do not have permission to create users.";
      break;
    }

    ## trim form fields
		$perms = trim($perms);
		$name = trim($name);
		$email = $validate->strip_space($email);
    $username = trim($username);
		    
    ## Do we have all necessary data?
    if (empty($password) || empty($perms) || empty($username) || empty($name) || empty($email)) {
      $error_msg = "Please fill out <B>User Name</B>, <B>Name</B>, <B>E-Mail</B>, <B>Password<B>, and <B>Permissions</B>!";
      break;
    }

	## Is email address in the proper format?
    if (!$validate->is_email($email))  { 
      $error_msg = "From address invalid. Format must be <strong>user@domain</strong> and domain must exist!<br><small> $validate->ERROR </small>";
      break;
	  }
    
    ## Does the user already exist?
    $query = sprintf("select username from auth_user where username = '%s'", $username);
    $db->query($query);
    if ($db->nf()>0) {
      $error_msg = "User <B>$username</B> already exists!";
      break;
    }

    ## Insert the user
	  $unique_uid = MD5(uniqid($user->user["magic"]));
    $query = sprintf("insert into auth_user (uid, username, password, perms, name, email) values('%s', '%s', '%s', '%s', '%s', '%s')", $unique_uid, $username, md5($password), $perms, addslashes($name), $email);
    $db->query($query);
    if ($db->affected_rows() == 0) {
      $error_msg = "<b>Insert failed:</b> $query";
      break;
    }
    $mode = "S";
    $msg = "User &quot;$username&quot; created.<BR>";
		
		## insert default rows for codes tables for this user.
		## we don't really care if the inserts fail or not, so
		## don't bother checking the return codes
 		$query = "insert into category (id, name, username) values(0, 'unassigned', '$username')";
    $db->query($query);
		$query = "insert into subcategory (id, name, username) values(0, 'unassigned', '$username')";
    $db->query($query);
		$query = "insert into rating (id, name, username) values(0, 'not rated', '$username')";
    $db->query($query);
    $query = "insert into bookmark (url, name, ldesc, category_id, subcategory_id, rating_id, username) values('http://renaghan.com/bookmarker/', 'bookmarker home', 'bookmarker home page',0,0,0, '$username')";
    $db->query($query);
		break;
  
  default:
    break;
 } /* end switch */
} /* end while */
if (isset ($error_msg)) {
  $tpl->assign(ERROR_MSG_TEXT, $error_msg);
  $tpl->parse(ERROR_MSG, "error_msg");
}

if (isset ($msg)) {
  $tpl->assign(MSG_TEXT, $msg);
  $tpl->parse(MSG, "msg");
}

# if no mode specified, or mode is S (Select)
# then print html to allow user to select from
# the possible options and data on this page.
$tpl->assign(FORM_ACTION, $sess->self_url());

if (!isset($mode) || $mode=="S") {

  ## get records to update and delete
  $query = "select username from auth_user order by username";
  $db->query($query);
  while ($db->next_record()) {
    $url = $sess->url(sprintf("user.php3?mode=U&username=%s", $db->f("username")));
    $tpl->assign(URL, $url);
		$tpl->assign(NAME, $db->f("username"));
    $tpl->parse(UPDATE_USER_LIST, ".user_list");

    $url = $sess->url( sprintf("user.php3?mode=D&username=%s", $db->f("username")));
    $tpl->assign(URL, $url);
    $tpl->parse(DELETE_USER_LIST, ".user_list");
  }

  $tpl->parse(BODY, "select_form");


# if mode is U, present the update form
} elseif ($mode=="U") {
  ## get record to update
  $query = sprintf("select * from auth_user where username='%s'", $username);
  $db->query($query);
  if ($db->next_record()) {
    $tpl->assign(array(
      USERNAME       => $db->f("username"),
      NAME           => htmlspecialchars(stripslashes($db->f("name"))),
      EMAIL          => $db->f("email"),
			PERMS          => $db->f("perms")
    ));
    $tpl->parse(BODY, "update_form");
  } 
 
# if mode is C, present the create form
} elseif ($mode=="C") {
  $tpl->assign(array(
      USERNAME       => $username,
      NAME           => $name,
      EMAIL          => $email,
			PERMS          => $perms
    ));
  $tpl->parse(BODY, "create_form");

# if mode is D, present the are you sure delete form
} elseif ($mode=="D") {
  $tpl->assign(USERNAME , $username);
  $tpl->parse(BODY, "delete_form");
}
  
$tpl->parse(MAIN, "standard");
$tpl->FastPrint();

page_close();
?>
