<?php 
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: codes.php3,v 1.6 1999/05/31 20:30:00 prenagha Exp $
# $Log: codes.php3,v $
# Revision 1.6  1999/05/31 20:30:00  prenagha
# fixed bug 71.
# changed all htmlentities calls to htmlspecialchars calls
# so that bk works better for other languages.
#
# Revision 1.5  1999/04/22 03:07:08  prenagha
# changed to trim name, and make sure ID is a number
#
# Revision 1.4  1999/04/17 19:42:34  prenagha
# change to use cr auth
#
# Revision 1.3  1999/04/16 03:44:18  prenagha
# fixed special char handling with add/strip slashes.
#
# Revision 1.2  1999/04/11 00:06:01  prenagha
# sgVersion 1.1 pre-release testing
#
# Revision 1.1  1999/04/03 22:14:25  prenagha
# page to maintain category, subcategory, and ratings codes. release 1.0.
#
# ---------------------------------------------------------------
  include("bkprepend.php3");
  page_open(array( "sess" => "bk_sess"
							,"auth" => "bk_cr_auth"
		          ,"perm" => "bk_perm"
		          ,"user" => "bk_user"));

$tpl->define(array(
  standard   => "common.standard.tpl",
  msg        => "common.message.tpl",
  error_msg  => "common.error_message.tpl",
  code_list  => "codes.codelist.tpl",
  select_form  => "codes.select.tpl",
  update_form  => "codes.update.tpl",
  create_form  => "codes.create.tpl",
  delete_form  => "codes.delete.tpl"
));

set_standard("code tables", &$tpl);

$username = $auth->auth["uname"];

### Get a database connection
$db   = new bk_db;

## Check if there was a submission
while ( is_array($HTTP_POST_VARS) 
     && list($key, $val) = each($HTTP_POST_VARS)) {
  switch ($key) {

  ## update canceled
  case "bk_cancel_update":
    $mode = "S";
	break;

  ## create canceled
  case "bk_cancel_create":
    $mode = "S";
	break;

  ## delete canceled
  case "bk_cancel_delete":
    $mode = "S";
	break;

  ## maintain code table
  case "bk_code_update":
    ## Do we have permission to do so?
    if (!$perm->have_perm("editor")) {
      $error_msg = "You do not have permission to update code tables.";
      break;
    }

    ## Trim space from begining and end of fields
		$name = trim($name);

    ## Do we have all necessary data?
    if (empty($name)) {
      $error_msg = "Please fill out <B>Name</B>!";
      break;
    }
    
    ## Update information
    $query = sprintf("update %s set name='%s' where id=%s and username='%s'", $codetable, addslashes($name), $id, $username);
	
    $db->query($query);
    if ($db->affected_rows() == 0) {
      $error_msg = "<b>Update failed:</b> $query";
      break;
    }
    $mode = "S";
    $msg = sprintf("%s %s (%s) changed.<BR>", $codetable, htmlspecialchars(stripslashes($name)), $id) ;
  break;

  ## Delete the codes
  case "bk_code_delete":
    ## Do we have permission to do so?
    if (!$perm->have_perm("editor")) {
      $error_msg = "You do not have permission to delete codes.";
      break;
    }
    
    ## Delete that code
    $query = sprintf("delete from %s where id=%s and username='%s'", $codetable, $id, $username);
    $db->query($query);
    if ($db->affected_rows() == 0) {
      $error_msg = "<b>Delete failed:</b> $query";
      break;
    }
    $mode = "S";
    $msg = "$codetable $id deleted.<BR>";
  break;

  ## Create a code
  case "bk_code_create":

    ## Do we have permission to do so?
    if (!$perm->have_perm("editor")) {
      $error_msg = "You do not have permission to create codes.";
      break;
    }

    ## Trim space from begining and end of fields
		$name = trim($name);
    
    ## Do we have all necessary data?
    if (empty($id) || empty($name)) {
      $error_msg = "Please fill out <B>ID</B>, and <B>Name</B>!";
      break;
    }

    ## make sure ID is a number
		if (! $validate->is_allnumbers($id)) {
		  $error_msg = "ID must be a number!<br><small> $validate->ERROR </small>";
			break;
		}
		    
    ## Does the code already exist?
    $query = sprintf("select id from %s where id=%s and username='%s'", $codetable, $id, $username);
    $db->query($query);
    if ($db->nf()>0) {
      $error_msg = "$codetable <B>$id</B> already exists!";
      break;
    }

    ## Insert the code
    $query = sprintf("insert into %s (id, name, username) values(%s, '%s', '%s')", $codetable, $id, addslashes($name), $username);
    $db->query($query);
    if ($db->affected_rows() == 0) {
      $error_msg = "<b>Insert failed:</b> $query";
      break;
    }
    $mode = "S";
    $msg = sprintf("%s %s (%s) created.<BR>", $codetable, htmlspecialchars(stripslashes($name)), $id);
  break;
  
  default:
  break;
 } /* end switch */
} /* end while */

if (isset ($error_msg)) {
  $tpl->assign(ERROR_MSG_TEXT, $error_msg);
  $tpl->parse(ERROR_MSG, "error_msg");
}

if (isset ($msg)) {
  $tpl->assign(MSG_TEXT, $msg);
  $tpl->parse(MSG, "msg");
}
$tpl->assign(CODETABLE, $codetable);
$tpl->assign(FORM_ACTION, $sess->self_url());

# if no mode specified, or mode is S (Select)
# then print html to allow user to select from
# the possible options and data on this page.

if (!isset($mode) || $mode=="S") {

  ## get records to update
  $query = "select id, name from $codetable where username='$username' order by name";
  $db->query($query);
  while ($db->next_record()) {
    $url = $sess->url(sprintf("codes.php3?codetable=%s&mode=U&id=%s", $codetable, $db->f("id")));

    $tpl->assign(URL, $url);
		$tpl->assign(NAME, htmlspecialchars(stripslashes($db->f("name"))));
		$tpl->assign(ID, $db->f("id"));
    $tpl->parse(UPDATE_CODE_LIST, ".code_list");

    $url = $sess->url(sprintf("codes.php3?codetable=%s&mode=D&id=%s", $codetable, $db->f("id")));
    $tpl->assign(URL, $url);
    $tpl->parse(DELETE_CODE_LIST, ".code_list");

  }
  $tpl->parse(BODY, "select_form");

# if mode is U, present the update form
} elseif ($mode=="U") {
  ## get record to update
  $query = sprintf("select * from %s where id=%s and username='%s'", $codetable, $id, $username);
  $db->query($query);
  if ($db->next_record()) {
    $tpl->assign(array(
      ID       => $db->f("id"),
			NAME     => htmlspecialchars(stripslashes($db->f("name")))
    ));
    $tpl->parse(BODY, "update_form");
   } /* end fetch if */
 
# if mode is C, present the create form
} elseif ($mode=="C") {
	## get the max used ID so that we can default for the new row
	$query = sprintf("select max(id) as max_id from %s where username='%s'", $codetable, $username);
  $db->query($query);
  if ($db->next_record()) {
		$default_id = $db->f("max_id") + 1;
	} else {
	  $default_id = 0;
	}
  $tpl->assign(DEFAULT_ID, $default_id);
  $tpl->parse(BODY, "create_form");

# if mode is D, present the are you sure delete form
} elseif ($mode=="D") {

  $tpl->assign(ID, $id);
  $tpl->parse(BODY, "delete_form");
}

$tpl->parse(MAIN, "standard");
$tpl->FastPrint();

page_close();
?>
