#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>

#include "bridge.h"
#include "display.h"
#include "html.h"
#include "main.h"
#include "parsehtml.h"
#include "status.h"
#include "style.h"
#include "util.h"


void ShowLink(GC theGC, ViewWindow theViewWindow, int x, int y)
{
 int tag, end;
 Byte *element;
 char *c, *anchor_start, *anchor_end;
 int dx, dy;
 char *href, *name, *class,*ref;
 int hreflen, namelen;
 int class_len;
 XEvent e;


 ParseAnchorAttrs(&href, &hreflen, &name, &namelen, &class, &class_len);
 anchor_start = anchor_end = 0;
 tag = 0;

 if (!DocHTML(CurrentDoc)) return;
 if (CurrentDoc->show_raw) return;

 element = WhichObject(theGC, theViewWindow,
		       BUTTONDOWN,
		       x, y,
		       &tag, &anchor_start, &anchor_end,
		       &dx, &dy);

 if (tag == TAG_ANCHOR)
   {
    bufptr = anchor_start;
    ParseAnchorAttrs(&href, &hreflen, &name, &namelen, &class, &class_len);
    ref = HTAnchor_address(anchorExpandnHref(href, hreflen));
    if (ref)
      {
       c = (char *)Arena_CAlloc(Arena_StrLen(ref)+7, sizeof(char), False);
       strcpy(c, "Link: ");
       strcpy(c+6, ref);
       Announce(c);
       Free(c);
       end = 0;
       while (!end)
	 {
	  XNextEvent(display, &e);
	  switch(e.type)
	    {
	     case Expose:
	       while (XCheckTypedEvent(display, Expose, &e));
	       break;

	     case ButtonRelease:
	       end = True;
	       Announce(CurrentDoc->url);
	       break;

	     default:
	       break;
	    }
	 }
       Free(ref);
      }
   }
}
