#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <limits.h>     /* definition of OPEN_MAX */

#include <X11/Intrinsic.h>


#include "arena.h"

#include JPEGLIB_HEADER_FILE_FOR_INCLUSION_IN_ARENA
#include  JERROR_HEADER_FILE_FOR_INCLUSION_IN_ARENA

#include "types.h"
#include "colour.h"
#ifdef ARENA_DEBUG
#  include "debug.h"
# else
#  include "error.h"
#endif
#include "dither.h"
#include "image.h"
#include "jpeg_arena.h"
#include "main.h"
#include "util.h"

#include "HTUtils.h"	/* WWW general purpose macros */
#include "HTList.h"
#include "HTAccess.h"

#ifdef JPEG


JSAMPLE* image_buffer;	/* Points to large array of R,G,B-order data */
int image_width;	/* Number of columns in image */
int image_height;	/* Number of rows in image */

#define MAX_BUFFER 10000
#define MAX_ROWS   16 /* matches one or two MCU rows in most images */
#define SIZEOF(object)  ((size_t) sizeof(object))   /* from jinclude.h */

typedef struct {
   unsigned char	*buffer;
   int			filled;
   } buffer_struct;

typedef struct {
  struct jpeg_source_mgr pub;	/* public fields */

  buffer_struct			*buffer;
  int				state;
  JOCTET			terminal[2];
} my_source_mgr;

typedef my_source_mgr * my_src_ptr;

#define	IMAGE_COLOUR_SPACE_UNKNOWN	0
#define	IMAGE_COLOUR_SPACE_GREYSCALE	1
#define	IMAGE_COLOUR_SPACE_RGB		2




static void my_input_manager(j_decompress_ptr cinfo, buffer_struct* buffer);

int image_transform_jpeg (void *buffer_data, 
			  int buffer_size,
			  int      declare_data_frame(void *userdata,
						      image_data* data),
			  int put_scanline_someplace (void *userdata,
						      image_data* data),
			  void *userdata);

int ImageOutputInit     (void *output, image_data* data);
int ImageOutputScanlines(void *output, image_data* data);


static int ImageOutputScanlines_1_2_4 (output_image_data* output,
				       image_data* idata)
{
#ifdef ARENA_DEBUG
 char Iam[] = "ImageOutputScanlines_1_2_4";
#endif

 if (depth == 1 || depth == 2 || depth == 4)
   {
    int v;
    int xpos = 0, ypos = 0, yindex;
    unsigned char *dp, *scan_buffer;
    int cr = 0, cg = 0, cb = 0, r, g, b, row, col; /* 12-Mar-96 <herman@htbrug.hobby.nl> */
    int ppb, bpl, shift = 0;
    int newbyte;


    ppb = 8/depth;                /* pixels per byte */
    bpl = output->bytes_per_row;  /* bytes  per line */
    newbyte = 1;

    dp = output->data + output->row * output->bytes_per_row;
    for (yindex = 0; yindex < idata->rows; yindex++)
      {
       ypos = yindex + output->row;
       scan_buffer = idata->buffer + (yindex * output->width * 3);

       col = ypos & 0x0F;

       for (xpos = 0; xpos < idata->width; ++xpos)
	{
	 row = xpos & 0x0F;

	 if (newbyte)
	   {
	    *dp = 0;
	    newbyte = 0;
	   }

	 if (imaging == COLOUR232)
	   {
	   /* do we have to do grayscale like in ImageOutputScanlines_8 ?? */

	    switch (idata->components)
	      {
	       case 1:
		 cr = cg = cb = Voltage2Brightness(scan_buffer[xpos]);
#if 0
		 cr = cg = cb = gamma_table[scan_buffer[xpos]];
#endif
		 break;

	       case 3:
		 cr = Voltage2Brightness(scan_buffer[0+(xpos * 3)]);
		 cg = Voltage2Brightness(scan_buffer[1+(xpos * 3)]);
		 cb = Voltage2Brightness(scan_buffer[2+(xpos * 3)]);
		 break;

	       default:
#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
		 if (IMAGE_TRACE && VERBOSE_TRACE)
		   Arena_TracePrint(Iam,
				    " components = %d\n", idata->components);
#endif
		 break;
	      }

	    r = cr & 0xC0;
	    g = cg & 0xE0;
	    b = cb & 0xC0;

	    v = (row << 4) + col;

	    if (cr - r > Magic64[v]) r += 64;
	    if (cg - g > Magic32[v]) g += 32;
	    if (cb - b > Magic64[v]) b += 64;

	    /* clamp error to keep colour in range 0 to 255 */

	    r = min(r, 255) & 0xC0;
	    g = min(g, 255) & 0xE0;
	    b = min(b, 255) & 0xC0;


	    /* howcome added support for <8 bits 25/1/95 */

	    shift = (((xpos % 8) % ppb) * depth);
	    *dp |= (stdcmap[(r >> 6) | (g >> 3) | (b >> 1)]) << shift;
	    if ((shift + depth) == 8)
	      {
	       dp++;
	       newbyte = 1;
	      }
	   }

	  else
	   if (imaging == MONO)
	     {
	      switch (idata->components)
		{
		 case 1:
		   cg = Voltage2Brightness(scan_buffer[xpos]);
#if 0
		   cg = gamma_table[scan_buffer[xpos]];
#endif
		   break;

		 case 3:
		   cg = Voltage2Brightness((0.59*scan_buffer[0+(xpos * 3)]) +
					   (0.20*scan_buffer[1+(xpos * 3)]) +
					   (0.11*scan_buffer[2+(xpos * 3)]));
		   break;

		 default:
#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
		   if (IMAGE_TRACE && VERBOSE_TRACE)
		     Arena_TracePrint(Iam,
				      " components = %d\n",
				      idata->components);
#endif
		   break;
		}

	      shift = (((xpos % 8) % ppb) * depth);

	      if (cg < Magic256[(row << 4) + col])
		*dp |= greymap[0] << shift;   /* was *dp++ 17-jan-96 */
	       else
		*dp |= greymap[15] << shift;  /* idem */

	      if ((shift + depth) == 8)
		{
		 dp++;
		 newbyte = 1;
		}
	     }
	    else
	     {
	      cg = Voltage2Brightness((0.59*scan_buffer[0+(xpos * 3)]) +
				      (0.20*scan_buffer[1+(xpos * 3)]) +
				      (0.11*scan_buffer[2+(xpos * 3)]));
	      g = cg & 0xF0;

	      if (cg - g > Magic16[(row << 4) + col])
		{
		 g += 16;
		}

	      g = min(g, 0xF0);

	      shift = (((xpos % 8) % ppb) * depth);

	      *dp++ |= greymap[g >> 4] << shift;

	      if ((shift + depth) == 8)
		{
		 dp++;
		 newbyte = 1;
		}
	     }
	}

      if (shift)
	{
	 dp++;   /* make sure we start on a new byte for the next line */
	 newbyte = 1;
	}

    }

    return True;
   }
  else
   {
#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
    Arena_TracePrint(Iam,
		     "\n\tsorry, images are not supported for depth %d\n",
		     depth);
# else
    Arena_PrintError(_("Sorry, images are not supported for depth %d\n"),
		     depth);
#endif
    return False;
   }
}


static int ImageOutputScanlines_8 (output_image_data *output,
				   image_data *idata)
{
 int             v;
 int             xpos = 0, ypos = 0,  yindex;
 unsigned char   *dp, *scan_buffer;
 int             cr = 0, cg = 0, cb = 0, r, g, b, row, col;


 if (True)
   {
    dp = output->data + output->row * output->bytes_per_row;

#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
    if (IMAGE_TRACE)
      Arena_TracePrint("ImageOutputScanlines_8",
		       " %d %d\n", output->row, output->bytes_per_row);
#endif
    for (yindex = 0; yindex < idata->rows; yindex++)
      {
       ypos = yindex + output->row;
       scan_buffer = idata->buffer + (yindex * output->width * idata->components); /* howcome 19/2/95: 3 -> idata->components */

#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
       if (IMAGE_TRACE)
	 Arena_TracePrint("ImageOutputScanlines_8",
			  " y %d scanbuffer "POINTER_FORMAT"\n",
			  yindex, scan_buffer);
#endif
       col = ypos & 0x0F;

       for (xpos = 0; xpos < idata->width; ++xpos)
	 {
	  row = xpos & 0x0F;

	  if (imaging == COLOUR232)
	    {
	     switch (idata->components)
	       {
	       /* do grayscale */

	        case 1:
		  cr = cg = cb = Voltage2Brightness(scan_buffer[xpos]);
#if 0
		  cr = cg = cb = gamma_table[scan_buffer[xpos]];
#endif
		  g = cg & 0xF0;
		  if (cg - g > Magic16[(row << 4) + col]) g += 16;
		  g = min(g, 0xF0);
		  *dp++ = greymap[g >> 4];
		  break;

	        case 3:
		  cr = Voltage2Brightness(scan_buffer[0+(xpos * 3)]);
		  cg = Voltage2Brightness(scan_buffer[1+(xpos * 3)]);
		  cb = Voltage2Brightness(scan_buffer[2+(xpos * 3)]);

		  r = cr & 0xC0;
		  g = cg & 0xE0;
		  b = cb & 0xC0;

		  v = (row << 4) + col;

		  if (cr - r > Magic64[v]) r += 64;
		  if (cg - g > Magic32[v]) g += 32;
		  if (cb - b > Magic64[v]) b += 64;

		  /* clamp error to keep colour in range 0 to 255 */

		  r = min(r, 255) & 0xC0;
		  g = min(g, 255) & 0xE0;
		  b = min(b, 255) & 0xC0;

		  *dp++ = stdcmap[(r >> 6) | (g >> 3) | (b >> 1)];

		  break;

	        default:
#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
		  if (IMAGE_TRACE && VERBOSE_TRACE)
		    Arena_TracePrint("ImageOutputScanlines_8",
				     " components = %d\n",
				     idata->components);
#endif
		  break;
	       }
	    }
	   else
	    if (imaging == MONO)
	      {
	       switch (idata->components)
		 {
		  case 1:
		    cg = Voltage2Brightness(scan_buffer[xpos]);
		    cg = gamma_table[scan_buffer[xpos]];
		    break;

		 case 3:
		   cg = Voltage2Brightness((0.59*scan_buffer[0+(xpos * 3)]) +
					   (0.20*scan_buffer[1+(xpos * 3)]) +
					   (0.11*scan_buffer[2+(xpos * 3)]));
		   break;

		  default:
#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
		    if (IMAGE_TRACE && VERBOSE_TRACE)
		      Arena_TracePrint("ImageOutputScanlines_8",
				       " components = %d\n",
				       idata->components);
#endif
		    break;
		 }

	       if (cg < Magic256[(row << 4) + col])
		 *dp++ = greymap[0];
	        else
		 *dp++ = greymap[15];
	      }
	     else
	      {
	       switch (idata->components)
		 {
		  case 1:
		    cg = Voltage2Brightness(scan_buffer[xpos]);
		    break;

		  case 3:
		    cg = Voltage2Brightness((0.59*scan_buffer[0+(xpos * 3)]) +
					    (0.20*scan_buffer[1+(xpos * 3)]) +
					    (0.11*scan_buffer[2+(xpos * 3)]));
		    break;

		  default:
#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
		    if (IMAGE_TRACE && VERBOSE_TRACE)
		      Arena_TracePrint("ImageOutputScanlines_8",
				       " components = %d\n",
				       idata->components);
#endif
		    break;
		 }

	       g = cg & 0xF0;

	       if (cg - g > Magic16[(row << 4) + col]) g += 16;
	       g = min(g, 0xF0);
	       *dp++ = greymap[g >> 4];
	      }
	 }
      }
   }

 return True; 	/* janet: added. should it return other value? */
}


static int ImageOutputScanlines_24 (output_image_data *output, 
				    image_data *idata)
{
 int             xpos = 0, ypos = 0, yindex;
 unsigned char   *dp, *scan_buffer;
 int             row, col;


 if (True)
   {	
    dp = output->data + output->row * output->bytes_per_row;

#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
    if (IMAGE_TRACE)
      Arena_TracePrint("ImageOutputScanlines_24",
		       " %d %d\n", output->row, output->bytes_per_row);
#endif

    for (yindex = 0; yindex < idata->rows; yindex++)
      {
       ypos = yindex + output->row;
       scan_buffer = idata->buffer + (yindex * output->width * 3);

#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
       if (IMAGE_TRACE)
	 Arena_TracePrint("ImageOutputScanlines_24",
			  " y %d scanbuffer "POINTER_FORMAT"\n",
			  yindex, scan_buffer);
#endif
       col = ypos & 0x0F;

       for (xpos = 0; xpos < idata->width; ++xpos)
	 {
	  row = xpos & 0x0F;

	  *dp++ = '\0';

	  switch (idata->components)
	    {
	     case 1:
	       *dp++ = scan_buffer[xpos];
	       *dp++ = scan_buffer[xpos];
	       *dp++ = scan_buffer[xpos];
	       break;

	     case 3:
	       *dp++ = scan_buffer[((RPixelShift) ? 2 : 0)+(xpos*3)];
	       *dp++ = scan_buffer[1+(xpos*3)];
	       *dp++ = scan_buffer[((RPixelShift) ? 0 : 2)+(xpos*3)];
	       break;

	     default:
#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
	       if (IMAGE_TRACE && VERBOSE_TRACE)
		 Arena_TracePrint("ImageOutputScanlines_24",
				  " components = %d\n",
				  idata->components);
#endif
	       break;
	    }
	 }
      }
   }

 return True;	/* janet 1/8/95: added. should it return other value? */
}


static int ImageOutputScanlines_16 (output_image_data *output, 
				    image_data *idata)
{
 int             xpos = 0, ypos = 0, yindex;
 unsigned char   *dp, *scan_buffer;
 int             row, col, cr, cg, cb; 
 long            ulp;

 
 if (True)
   {
    dp = output->data + output->row * output->bytes_per_row;

#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
    if (IMAGE_TRACE)
      Arena_TracePrint("ImageOutputScanlines_16",
		       " %d %d\n", output->row, output->bytes_per_row);
#endif

    for (yindex = 0; yindex < idata->rows; yindex++)
      {
       ypos = yindex + output->row;
       scan_buffer = idata->buffer + (yindex * output->width * 3);

#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
       if (IMAGE_TRACE)
	 Arena_TracePrint("ImageOutputScanlines_16",
			  " y %d scanbuffer "POINTER_FORMAT"\n",
			  yindex, scan_buffer);
#endif
       col = ypos & 0x0F;

       for (xpos = 0; xpos < idata->width; ++xpos)
	 {
	  row = xpos & 0x0F;

	  switch (idata->components)
	    {
	     case 1:
	       cr = cg = cb = scan_buffer[xpos];
	       GetColour(cr, cg, cb, &ulp);
	       *dp++ = ((char*)&ulp)[0];   /* LSB first! */
	       *dp++ = ((char*)&ulp)[1];
	       break;

	     case 3:
	       cr = scan_buffer[0+(xpos * 3)];
	       cg = scan_buffer[1+(xpos * 3)];
	       cb = scan_buffer[2+(xpos * 3)];
	       GetColour(cr, cg, cb, &ulp);
	       *dp++ = ((char*)&ulp)[0];   /* LSB first! */
	       *dp++ = ((char*)&ulp)[1];
	       break;

	     default:
#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
	       if (IMAGE_TRACE && VERBOSE_TRACE)
		 Arena_TracePrint("ImageOutputScanlines_16",
				  "components = %d\n",
				  idata->components);
#endif
	       break;
	    }
	 }
      }
   }

 return True;
} 


int ImageOutputInit(void* output_in, image_data* data)
{
 output_image_data *output = (output_image_data *) output_in;
 int blocksize;


 output->row = 0;
 output->width  = data->width;
 output->height = data->height;

 if ((output->depth == 1) || (output->depth == 2) || (output->depth == 4))
   {
    int ppb = 8/output->depth;   /* pixels per byte */

    output->bytes_per_row = data->width/ppb + (data->width%ppb ? 1 : 0); 
   }
  else
   if (output->depth == 8)
     {
      output->bytes_per_row = 1 * data->width;
     }
    else
     if (output->depth == 16)
       {
        output->bytes_per_row = 2 * data->width;
       }
      else
       if (output->depth == 24)
	 {
	  output->bytes_per_row = 4 * data->width;  /* 4 ???? */
	 }
        else
	 {
#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
	  Arena_TracePrint("ImageOutputInit",
			   "\n\tsorry, images are not supported"
			   " for depth %d (%d)\n",
			   depth, output->depth);
# else
	  Arena_PrintError(_("Sorry, images are not supported for depth %d (%d)\n"),
			   depth, output->depth);
#endif
	  output->data = NULL;
	  return False;
	 }

 blocksize = output->bytes_per_row * data->height;
 output->data = Arena_MAlloc(blocksize, False);

 return True;
}


int ImageOutputScanlines (void* output_in, image_data* data)
{ 
 output_image_data *output = (output_image_data *) output_in;


 if (output->data == NULL)
   {
    return False;
   }
  else
   if ((output->depth == 1) || (output->depth == 2) || (output->depth == 4))
     {
      ImageOutputScanlines_1_2_4 (output, data);
      output->row = output->row + data->rows;
     }
    else
     if (output->depth == 8)
       {
	ImageOutputScanlines_8 (output, data);
        output->row = output->row + data->rows;
       }    
      else
       if (output->depth == 24)
	 {
	  ImageOutputScanlines_24 (output, data);
	  output->row = output->row + data->rows; /* howcome 9/2/94:
						     phill forgot this one */
	 }
        else
	 if (output->depth == 16)
	   {
	    ImageOutputScanlines_16 (output, data);
	    output->row = output->row + data->rows;
	   }
	  else
	   {
#ifdef ARENA_DEBUG	/* QingLong.25-01-97 */
	    Arena_TracePrint("ImageOutputScanlines",
			     "\n\tsorry, images are not supported for depth %d\n",
			     depth);
# else
	    Arena_PrintError(_("Sorry, images are not supported for depth %d\n"),
			     depth);
#endif
	    return False;
	   }

 return True; 	/* janet 1/8/95: added. */
}


ImageXyoke* LoadJPEGimage(Block* bp, unsigned int depth)
{
 output_image_data _output_data, *output_data;
 ImageXyoke* theImageXcouple;
 unsigned int imageWidth, imageHeight;
#ifdef ARENA_DEBUG
 char Iam[] = "LoadJPEGimage";
#endif

 output_data = &_output_data;

 output_data->depth = depth;
 image_transform_jpeg ((void*)bp->buffer,
		       bp->size, 
		       ImageOutputInit,
		       ImageOutputScanlines, 
		       output_data);

 imageWidth  = output_data->width;
 imageHeight = output_data->height;

 if (output_data->depth == 24)
   {
    unsigned char *dp, *scan;
    int i,j;

    dp = output_data->data;
    scan = dp;
    for (i = 0; i < imageWidth; i++)
      for(j = 0; j < imageHeight; j++)
	{
	 *dp++ = gamma_table[*scan++];
	 *dp++ = gamma_table[*scan++];
	 *dp++ = gamma_table[*scan++];
	 *dp++ = gamma_table[*scan++];
	}
   }

 {
  ImageData* theImageData;

  if ((theImageData = NewImageData(0, 0)) == NULL)
    {
#ifdef ARENA_DEBUG
     if (IMAGE_TRACE)
       Arena_TracePrint(Iam, " no space available for image data struct.\n");
#endif
     return NULL;
    }

  theImageData->image = output_data->data;

  theImageXcouple = processImage_data2image(theImageData,
					    imageWidth, imageHeight, depth);

  /* The `image' and `mask' fields should be cut off before freeing.
   * The cut should be performed within the `processImage_data2image()'.
   */
  FreeImageData(theImageData);
 }

 return theImageXcouple;
}


struct my_error_mgr
{
 struct jpeg_error_mgr pub;             /* "public" fields */
 jmp_buf               setjmp_buffer;   /* for return to caller */
};

typedef struct my_error_mgr * my_error_ptr;

static void my_error_exit (j_common_ptr cinfo)
{
 my_error_ptr myerr = (my_error_ptr) cinfo->err;

 longjmp(myerr->setjmp_buffer, 1);
}


int image_transform_jpeg(void *buffer_data, 
			 int buffer_size,
			 int     declare_data_frame(void *userdata,
						    image_data *data),
			 int put_scanline_someplace(void *userdata,
						    image_data *data),
			 void *userdata)
{
 struct jpeg_decompress_struct cinfo;
 struct my_error_mgr jerr;
 JSAMPARRAY buffer;		/* Output row buffer */
 int row_stride;		/* physical row width in output buffer */
 int	rows;

 image_data	_idata, *idata;

 buffer_struct	_buffer_in, *buffer_in;


 buffer_in = &_buffer_in;
 idata = &_idata;

 buffer_in->buffer = buffer_data;
 buffer_in->filled = buffer_size;

 cinfo.err = jpeg_std_error(&jerr.pub);
 jerr.pub.error_exit = my_error_exit;

 if (setjmp(jerr.setjmp_buffer))
   {
    jpeg_destroy_decompress(&cinfo);
    return 0;
   }

 jpeg_create_decompress(&cinfo);
 my_input_manager (&cinfo, buffer_in);

 jpeg_read_header(&cinfo, True);
 jpeg_start_decompress(&cinfo);

 idata->width  = cinfo.output_width;
 idata->height = cinfo.output_height;
 idata->components = cinfo.output_components;

 if (cinfo.out_color_space == JCS_GRAYSCALE)
   {
    idata->colour_space = IMAGE_COLOUR_SPACE_GREYSCALE;
   }
  else
   if (cinfo.out_color_space == JCS_RGB)
     {
      idata->colour_space = IMAGE_COLOUR_SPACE_RGB;
     }
    else
      {
      idata->colour_space = IMAGE_COLOUR_SPACE_UNKNOWN;
      }

 idata->row_interlace = 1;

 declare_data_frame (userdata, idata);


 row_stride = cinfo.output_width * cinfo.output_components;
 buffer = (*cinfo.mem->alloc_sarray)((j_common_ptr)&cinfo,
				     JPOOL_IMAGE, row_stride, MAX_ROWS);

 idata->buffer = (unsigned char*)buffer[0];

 while (cinfo.output_scanline < cinfo.output_height)
   {
    rows = jpeg_read_scanlines(&cinfo, buffer, MAX_ROWS);
    idata->rows = rows;
    put_scanline_someplace(userdata, idata);
   }

 jpeg_finish_decompress(&cinfo);
 jpeg_destroy_decompress(&cinfo);

 return 1;
}


static void init_source(j_decompress_ptr cinfo)
{
 my_src_ptr src = (my_src_ptr) cinfo->src;

 src->state = 0;
}


static boolean fill_input_buffer(j_decompress_ptr cinfo)
{
 my_src_ptr src = (my_src_ptr) cinfo->src;


 /* Since we have given all we have got already
  * we simply fake an end of file
  */
 WARNMS(cinfo, JWRN_JPEG_EOF);
 src->pub.next_input_byte = src->terminal;
 src->pub.bytes_in_buffer = 2;
 src->terminal[0] = (JOCTET) 0xFF;
 src->terminal[0] = (JOCTET) JPEG_EOI;

 return True;
}


static void skip_input_data(j_decompress_ptr cinfo, long num_bytes)
{
 my_src_ptr src = (my_src_ptr) cinfo->src;

 src->pub.next_input_byte = src->pub.next_input_byte + num_bytes;
}


static void term_source(j_decompress_ptr cinfo)
{
}


static void my_input_manager(j_decompress_ptr cinfo, buffer_struct *buffer)
{
 my_src_ptr src;


 if (cinfo->src == NULL)
   {	/* first time for this JPEG object? */
    cinfo->src = (struct jpeg_source_mgr *)(*cinfo->mem->alloc_small)
                                        ((j_common_ptr) cinfo, JPOOL_PERMANENT,
					 SIZEOF(my_source_mgr));
   }

 src = (my_src_ptr) cinfo->src;
 src->pub.init_source 		= init_source;
 src->pub.fill_input_buffer 	= fill_input_buffer;
 src->pub.skip_input_data 	= skip_input_data;
 src->pub.resync_to_restart 	= jpeg_resync_to_restart; 
 src->pub.term_source 		= term_source;

 src->pub.bytes_in_buffer 	= buffer->filled;
 src->pub.next_input_byte 	= buffer->buffer;

 src->buffer = buffer;
}


#  ifdef STANDALONE_TEST

int     declare_data_frame(void *userdata, image_data *data);
int put_scanline_someplace(void *userdata, image_data *data);

int main(int argc, char *argv[], char *envp[])
{
 char 		*filename = argv[1];
 int 		file;
 int		status;
 unsigned char	buffer [MAX_BUFFER];
 void 		*userdata;


 printf("Process file %s\n", filename);

 file = open(filename, O_RDONLY, 0);
 status = read(file, buffer, MAX_BUFFER);
 close(file);

 printf("file read %d\n", status);

 image_transform_jpeg((void*)buffer, status, 
		      declare_data_frame,
		      put_scanline_someplace, 
		      userdata);

 printf("finished :-)\n");
}


int declare_data_frame(void *userdata, image_data *data)
{
 printf("The picture size is %d, %d components %d\n", 
	data->height, data->width, data->components);
}


int put_scanline_someplace(void *userdata, image_data *data)
{
 int	count;
 int	total = 0;
 unsigned char *buffer = data->buffer;


 for (count = 0;
      count < (data->components*data->width*data->rows);
      count++)
   {
    total += buffer[count];
   }

 printf ("[%d=%d]", data->rows, total);

 return (1);
}
#  endif	/* STANDALONE_TEST */
#endif /* JPEG */
