#ifndef ___ARENA_COLOUR_H___
#  define ___ARENA_COLOUR_H___


#include "defs.h"
#include "types.h"
#include "colour_types.h"


#define MAXCOLOURMAPSIZE 256


#define CM_RED          0
#define CM_GREEN        1
#define CM_BLUE         2

#define INTERLACE       0x40
#define LOCALCOLOURMAP  0x80


#define BitSet(byte, bit) (((byte) & (bit)) == (bit))
#define LM_to_uint(a,b)   (((b)<<8)|(a))


/*
 * Global variables. :(
 */
extern int ColourStyle;
extern InstallOwnColourMap OwnColourMap;

extern Colormap colourmap;

extern double Gamma;
extern unsigned char *gamma_table;

extern int RPixelShift, BPixelShift, GPixelShift;
extern int RPixelMask,  BPixelMask,  GPixelMask;

extern unsigned long textColour, labelColour, flybyColour,
                     windowColour, strikeColour, statusColour,
                     windowTopShadow, windowBottomShadow, windowShadow,
                     transparent;

extern ArenaImageingCapability imaging;

extern unsigned long greymap[16];   /* for mixing with unsaturated colours */
extern unsigned long stdcmap[128];  /* 2/3/2 colour maps for gifs etc */
extern unsigned long  mycmap[256];


/*
 * Functions.
 */
extern int InitImaging(int ColourStyle);

extern void CalcPixelShift(void);

extern int    GetColour(int red, int green, int blue, unsigned long *pix);
extern int GetPNGcolour(int red, int green, int blue, unsigned long *pix);
extern int GetNamedColour(char *name, unsigned long *pix);

extern void ReportStandardColourMaps(Atom which_map);
extern void ReportVisuals(void);

extern unsigned short Voltage2Brightness(unsigned short);
extern unsigned short Brightness2Voltage(unsigned short);

extern Bool VoltageVector2BrightnessVector(unsigned short   red,
					   unsigned short green,
					   unsigned short  blue,
					   unsigned int depth,
					   unsigned short* colour_red,
					   unsigned short* colour_green,
					   unsigned short* colour_blue,
					   unsigned short* colour_grey);

unsigned long magic2colour(Byte ix);
long ix2colour(int ix);

Byte rgb2magic(int r, int g, int b);
Byte rgb2ix(int status, int r, int g, int b, Bool rw);
long rgb2colour(int status, int r, int g, int b, Bool rw);

void rgbClear(void);

Bool ArenaExactColour(unsigned long colour);

Bool ArenaPackColour_to_chars(unsigned long colour,
			      unsigned int depth,
			      ArenaImageingCapability imageing,
			      unsigned char* colour_chars_pack);


#endif	/* ifndef ___ARENA_COLOUR_H___ */
