/* java(tm) applets for Arena.  Contributed by Greg Kaup 15.08.97
 */

/* applet.c  
 * Initial implementation of java(tm) applets for the Arena browser.
 * Please understand, I DON'T KNOW if this will actually be used for ANYTHING!
 * This has been created only from the information required to parse an
 * <applet...> </applet> HTML tag.  I have NOT even written the parser yet!
 *
 * At this time, this is really only a beginning!
 * Here we define the basic data elements, and their creation and destruction.
 * We will probably have to add MANY things to this structure to hold the
 * info necessary to communicate with the java virtual machine and the applet
 * itself!
 */

/* System stuff */
#include <stdio.h>
#include <stdarg.h>

/* Arena Stuff  */
#include "arena.h"
#ifdef ARENA_DEBUG
#  include "debug.h"
#endif
#include "applet.h"
#include "main.h"


/* Sloppy macro to help with null pointer to _TracePrint
 * This is mostly so I wouldn't have to try and fix vfprintf
 * to handle NULL pointers.  Some implementations just DIE, others give
 * "(null)".... very nice feature!
 */
#define spOK(a) ( (a != 0) ? (a) : ("(null)") )


/* Alloc a structure for a new applet.
 * At the moment, I'm assuming that we will allocate a new structure
 * immediately upon encountering the <applet... HTML tag.  Then fill it in
 * as we parsehtml?  Therefore...
 * Initialize all elements of an applet to 0 except the document!
 * ASSUME: zero parameters will be required.
 */
APPLET *NewApplet(void)
{
 APPLET *app = NULL;

 app = (APPLET *)malloc(sizeof(APPLET));
 if (!app) return app;

 app->doc = CurrentDoc;
 app->codebase = NULL;
 app->code = NULL;
 app->alt = NULL;
 app->instance_name = NULL;
 app->width = 0;
 app->height = 0;
 app->align = NULL;
 app->vspace = 0;
 app->hspace = 0;
 app->nparams = 0;
 app->params = NULL;
 app->ignoretext = NULL;
 return app;
}

/* Allocate structure of a new applet paramter.
 * The structure will store only the char* of the name and its value.
 */
APPLETParam *_NewAppletParam(APPLET *applet, char *nam, char *val)
{
 APPLETParam *param = NULL;

 param = (APPLETParam *)malloc(sizeof(APPLETParam));
 if (param)
   {
    param->name = nam;
    param->value = val;
   }
 return param;
}

/* Add a new applet parameter structure to the specified applet structure.
 * If this is the first parameter, the params array will be created...
 * otherwise, realloc for each new parameter?
 */
int AddAppletParam(APPLET *applet, char *nam, char *val)
{
 APPLETParam *p = NULL;

 if (!applet || !nam || !val) return EXIT_FAILURE;

 /* Create the pointer to our new parameter */
 p = _NewAppletParam(applet, nam, val);
 if (!p) return EXIT_FAILURE;

 /* Now create (or recreate) the array holding the pointers to the parameter
  * pointers!
  */
 if (applet->nparams == 0)
   {
    applet->params = (APPLETParam **)malloc(sizeof(APPLETParam *));
   }
 else
   {
    applet->params = (APPLETParam **)realloc(applet->params,
			      sizeof(APPLETParam *) * (applet->nparams + 1));
   }
 if (applet->params == NULL) return EXIT_FAILURE;

 /* now put our new parameter pointer into the new spot in the array! */
 applet->params[applet->nparams] = p;
 applet->nparams++;
 return EXIT_SUCCESS;
}

/* Free up the allocated space taken by one applet parameter structure.
 * This is kind of dumb right now... but maybe? we'll need to do more
 * stuff to free it in the future?!
 */
void _FreeAppletParam(APPLETParam *param)
{
 Free(param);
 return;
}

/* free up the allocated space taken by one applet...
 * including each of the parameters.
 */
void FreeApplet(APPLET *applet)
{
 if (!applet) return;

 /* free each of the param structures */
 if (applet->nparams > 0)
   {
    int i;
    for (i = 0; i < applet->nparams; i++)
      {
       _FreeAppletParam(applet->params[i]);
      }
   }
 applet->nparams = 0;

 /* now we can free the applet structure */
 Free(applet);
 return;
}

/* Ok, for future use...
 * let's be able to display ALL the applet info
 */
void DumpApplet(APPLET *a)
{
#ifdef ARENA_DEBUG
 int i;
 char Iam[] = "DumpApplet";

 if (!a) 
   {
    Arena_TracePrint(Iam, " APPLET is NULL\n");
    return;
   }
 Arena_TracePrint(Iam, " ------------------------------------\n");
 Arena_TracePrint(Iam, " Applet @" POINTER_FORMAT "...\n", a);
 if (!a->doc)
   Arena_TracePrint(Iam, " Doc is @" POINTER_FORMAT "\n", a->doc);
 Arena_TracePrint(Iam, " Codebase %s\n", spOK(a->codebase));
 Arena_TracePrint(Iam, " Code %s\n", spOK(a->code));
 Arena_TracePrint(Iam, " Alt  %s\n", spOK(a->alt));
 Arena_TracePrint(Iam, " Instance_name  %s\n", spOK(a->instance_name));
 Arena_TracePrint(Iam, " WxH %d %d\n", a->width, a->height);
 Arena_TracePrint(Iam, " Align  %s\n", spOK(a->align));
 Arena_TracePrint(Iam, " VxH %d %d\n", a->vspace, a->hspace);

 if (a->nparams > 0)
   {
    Arena_TracePrint(Iam, " Nparams %d\n", a->nparams);
    Arena_TracePrint(Iam, " Params @" POINTER_FORMAT "...\n", a->params);
    for (i = 0; i < a->nparams; i++)
      {
       Arena_TracePrint(Iam, " Name [%d] %s\n", i, spOK(a->params[i]->name));
       Arena_TracePrint(Iam, " Value[%d] %s\n",	i, spOK(a->params[i]->value));
      }
   }
 Arena_TracePrint(Iam, " Align  %s\n", spOK(a->ignoretext));
 Arena_TracePrint(Iam, " ------------------------------------\n");
#endif
}
