
# $Header: /cvsroot/aolserver/aolserver3/scripts/nsd.tcl,v 1.11 2000/04/07 15:59:41 kriston Exp $

#
# nsd.tcl --  The AOLserver Startup Script
#
#      This is a Tcl script that is sourced when AOLserver starts up.
#      A detailed reference is in "doc/config.txt".
#
#      Note:  Some modules are commented-out in this file because
#             they require configuration and/or passwords changed
#             before using.  They are nsssl, nscp, and nsperm.
#

ns_log notice "nsd.tcl: begin reading config file."


#
# Set some Tcl variables that are commonly used throughout this file.
#
set home                   [ns_info home]
set host                   [ns_info hostname]
set address                [ns_info address]
set httpport               8000
set httpsport              8443
set server                 "server1"
set servername             "Server Name"
set pageroot               ${home}/servers/${server}/pages
set directoryfile          index.adp,index.html,index.htm


#
# Global server parameters
#
ns_section "ns/parameters"
ns_param   home            $home
#ns_param   debug           true


#
# Thread library (nsthread) parameters
#
ns_section "ns/threads"
ns_param   mutexmeter      true      ;# measure lock contention
#ns_param   stacksize [expr 128*1024] ;# Per-thread stack size (bigger=better)

#
# MIME types.
#
#  Note: AOLserver already has an exhaustive list of MIME types, but in
#  case something is missing you can add it here.
#
ns_section "ns/mimetypes"
ns_param   default         "*/*"     ;# MIME type for unknown extension
ns_param   noextension     "*/*"     ;# MIME type for missing extension
#ns_param   ".xls"          "application/vnd.ms-excel"


############################################################
#
# Server-level configuration
#
#  There is only one server in AOLserver, but this is helpful when multiple
#  servers share the same configuration file.  This file assumes that only
#  one server is in use so it is set at the top in the "server" Tcl variable.
#  Other host-specific values are set up above as Tcl variables, too.
#

ns_section "ns/servers"
ns_param   $server         $servername


#
# Server parameters
#
ns_section "ns/server/${server}"
ns_param   directoryfile   $directoryfile
ns_param   pageroot        $pageroot
ns_param   globalstats     true      ;# Enable built-in statistics
ns_param   urlstats        true      ;# Enable URL statistics
ns_param   maxurlstats     1000      ;# Max number of URL's to do stats on
ns_param   enabletclpages  false     ;# Parse tcl files in pageroot (dangerous)

# Directory listings -- use an ADP or a Tcl proc to generate them.
#ns_param   directoryadp    $pageroot/dirlist.adp ;# Choose one or the other
#ns_param   directoryproc   _ns_dirlist           ;#  ...but not both!
#ns_param   directorylisting simple               ;# Can be simple or fancy


#
# ADP (AOLserver Dynamic Page) configuration
#
ns_section "ns/server/${server}/adp"
ns_param   map             "/*.adp"  ;# Extensions to parse as ADP's
#ns_param   map             "/*.html" ;# Any extension can be mapped
#ns_param   enableexpire    true      ;# Set "Expires: now" on all ADP's
#ns_param   enabledebug     true      ;# Allow Tclpro debugging with "?debug"

# ADP special pages
#ns_param   errorpage      ${pageroot}/errorpage.adp ;# Pretty-print errors


#
# ADP custom parsers -- see adp.c and adpfancy.c
#
ns_section "ns/server/${server}/adp/parsers"
ns_param   adp             ".adp"
#ns_param   fancy           ".adp"


#
# Socket driver module (HTTP)  -- nssock
#
ns_section "ns/server/${server}/module/nssock"
ns_param   port            $httpport
ns_param   hostname        $host
ns_param   address         $address


#
# Socket driver module (HTTPS) -- nsssl
#
ns_section "ns/server/${server}/module/nsssl"
ns_param   port            $httpsport
ns_param   hostname        $host
ns_param   address         $address
ns_param   keyfile         ${home}/servers/${server}/modules/nsssl/keyfile.pem
ns_param   certfile        ${home}/servers/${server}/modules/nsssl/certfile.pem


#
# Control port -- nscp
#
ns_section "ns/server/${server}/module/nscp"
ns_param   port            9999
ns_param   address         "127.0.0.1" ;# LOOPBACK IS RECOMMENDED


# Control port users
ns_section "ns/server/${server}/module/nscp/users"
# The default password for nsadmin is "x". You should change it.
ns_param   user            "nsadmin:t2GqvvaiIUbF2:"


#
# Access log -- nslog
#
ns_section "ns/server/${server}/module/nslog"
ns_param   maxbackup       5         ;# Max number to keep around when rolling
ns_param   rollhour        0         ;# Time to roll log
ns_param   rolllog         true      ;# Should we roll log?
ns_param   rollonsignal    true      ;# Roll log on SIGHUP


#
# CGI interface -- nscgi
#
ns_section "ns/server/${server}/module/nscgi"
#ns_param   map "GET  /cgi /usr/local/cgi"
#ns_param   map "POST /cgi /usr/local/cgi"


#
# Modules to load
#
ns_section "ns/server/${server}/modules"
ns_param   nssock          nssock.so
#ns_param   nsssl          nsssle.so  ;# needs key and certificate first!
#ns_param   nscp           nscp.so    ;# change password up above first!
ns_param   nslog           nslog.so
ns_param   nscgi           nscgi.so
#ns_param   nsperm          nsperm.so ;# change nsadmin password first!


ns_log notice "nsd.tcl: done reading config file."

