#!/usr/local/bin/jperl
open(IN, "step1") || die "step1 : $!";

$KANA = "[-]";
$KANJI = "[^-]";

$| = 1;

print "ñ -> ɤ ɽ";

sub add_sokuon {
    local($yomi) = @_;
    local($org_yomi) = $yomi;
    $yomi =~ s/$//;
    $yomi =~ s/$//;
    $YOMI{$k} .= "@$yomi";
}
while (<IN>) {
    chop;
    print "." if ($n++ % 100 == 0);
    local($yomi, $kanji) = split(/:/);
    if ($kanji =~ /^($KANA*)($KANJI)($KANA*)$/o) {
	local($header, $k, $trailer) = ($1, $2, $3);
	unless ($yomi =~ /^$header(.*)$trailer$/) {
	    warn "ɤ($yomi)ȴ($kanji)פƤޤ";
	    next;
	}
	$this_yomi = $1;
	$YOMI{$k} .= "@$this_yomi";
	
	&add_sokuon($this_yomi);
	
	# طϿ롣
	$first_yomi = substr($this_yomi, 0, 2);
	$first_yomi =~ tr///;
	$first_yomi =~ tr///;
	$first_yomi =~ tr/ĤƤ/¤ŤǤ/;
	$first_yomi =~ tr/ϤҤդؤ/ФӤ֤٤/;
	$alternative_yomi = $first_yomi . substr($this_yomi, 2);
	$YOMI{$k} .= "@$alternative_yomi";
	&add_sokuon($alternative_yomi);
	
	$first_yomi =~ tr/ФӤ֤٤/ѤԤפڤ/;
	$alternative_yomi = $first_yomi . substr($this_yomi, 2);
	$YOMI{$k} .= "@$alternative_yomi";
	&add_sokuon($alternative_yomi);
	$first_yomi =~ tr///;
	$alternative_yomi = $first_yomi . substr($this_yomi, 2);
	$YOMI{$k} .= "@$alternative_yomi";
	&add_sokuon($alternative_yomi);
    }
}
for $kanji (keys %YOMI) {
    %yomis = undef;
    for (split(/@/, $YOMI{$kanji})) {
	$yomis{$_} = 1 if ($_ ne "");
    }
    $YOMI{$kanji} = join("@", keys %yomis);
}
close IN;

print "..\n";
print "";
open(IN, "step1") || die "step1 : $!";
open(OUT, ">pd_kihon.yom") || die "pd_kihon.yom : $!";
open(JUKUJIKU, ">jukujiku.maz") || die "jukujiku.maz : $!";

$i = 0;
while (<IN>) {
    chop;
    print "." if ($n++ % 100 == 0);
    local($yomi, $kanji, $type) = split(/:/);
    next if ($type == 2);
    if (length($kanji) == 2) {
	print OUT "$kanji<$yomi>\n";
    } else {
	$output = &match_itr($yomi, $kanji);
	#print "$kanji : output = $output\n";
	if (!$output) {
	    warn "$kanji($yomi) ɤߤ";
	    print JUKUJIKU "$yomi $kanji\n";
	} else {
	    print OUT "$output\n";
	}
    }
    #last if ($i >= 3000);
    $i++;
}

print "ɤߤʬʤϸϡjukujuku.mazϿޤ.\n";

sub match_itr {
    local($yomi, $kanji) = @_;
    local($output, $kanji_head, $yomi_head, $rest_yomi, $new_output, $orig_kanji_head);
    #print "TRYING-head $yomi, $kanji\n";
    while ($kanji) {
	$kanji_head = substr($kanji, 0, 2);
	$kanji = substr($kanji, 2);
	if ($kanji_head =~ /^[-]$/) {
	    $yomi_head = substr($yomi, 0, 2);
	    $yomi = substr($yomi, 2);
	    if ($yomi_head ne $kanji_head) {
		return undef;
	    }
	    $output .= $kanji_head;
	} else {
 	    $orig_kanji_head = $kanji_head;
 	    if ($kanji_head eq "") {
 		$kanji_head = $last_kanji_head;
 	    }
	    unless (defined $YOMI{$kanji_head}) {
		warn "$kanji_head ɤߤϿƤޤ";
		last;
	    }
	    #print "TRYING $kanji_head, $YOMI{$kanji_head}\n";
	    for $kanji_yomi (split(/@/, $YOMI{$kanji_head})) {
		if (index($yomi, $kanji_yomi) == 0) {
		    #local($output);
		    $rest_yomi = substr($yomi, length($kanji_yomi));
		    if ($rest_yomi ne "") {
			$last_kanji_head = $kanji_head;
			
			if ($new_output = &match_itr($rest_yomi, $kanji)) {
			    $output .= "$orig_kanji_head<$kanji_yomi>" . $new_output;
			    return $output;
			}
		    } else {
			$output = "$orig_kanji_head<$kanji_yomi>";
			return $output;
		    }
		}
	    }
	    return undef;
	}
    }
    return $output;
}
