/*
 * Hardware tuning for the VIA 82C597_0 Host bridge
 *
 * Dave Jones		:	Initial VP3 support
 * Richard Pruen	:	MVP3 changes.
 */

#include "82C597_0_VP3.h"
#include "82C597_0_MVP3.h"

#define VIA_82C597_0_ID 0x11060597

void tune_VIA_597_0(struct pci_dev *current_dev)
{
	unsigned char dummy, option, current_val;
	word revision_id;

	revision_id = (pci_read_word (current_dev, PCI_REVISION_ID));

	switch (revision_id) {

		/* VP3 ? */
		case 0 ... 3:
			if (tune_device(VIA_82C597_0_Tweaks, current_dev)==1)
				goto VIA_597_0_out;
			break;

		/* MVP3 ? */
		case 4:
		/* Some BIOSes program the rev 4+ 82C598 so that it returns
		 * an ID the same as an 82C597 */
		
			if (tune_device(VIA_82C597_0_MVP3_Tweaks, current_dev)==1)
				goto VIA_597_0_out;
			break;

		default:
			/* Who knows what other combo's of this chip exist!
				If we get here, we don't know what the hell the chipset is,
				so we abort this tweak-set safely. */

// FIXME: The following commented out until further investigation.
// Possible compiler bug.

/*
			if (open_log_file(&logfile)==TRUE) {
				fprintf(logfile, "Unknown VIA 82C597 detected, please report this as a bug. Revision ID= %d",
					revision_id);
				close_log_file(&logfile);
			}
*/
			printf("Unknown VIA 82C597 detected, please report. Revision ID= %d", revision_id);
			goto VIA_597_0_out;
    }
    
	/*
	 * Tune memory timings.
	 * Registers 64h, 65h & 66h can take on two forms depending on the type of
	 * RAM that is installed. We need to test the DRAM type regiser at 60h
	 */

	/***** Bank 1/0 *******/
	dummy = pci_read_byte (current_dev, 0x60);
	switch (dummy & (1<<1|1<<0)) {

		case 0:		// Fast page mode
		case 1:		// EDO
				if (tune_device (VIA_82C597_0_EDOFPM_B1_Tweaks, current_dev)==1)
					goto VIA_597_0_out;
				break;

		case 2:		// DDR SDRAM-II
				if (tune_device (VIA_82C597_0_SDRAM_B1_Tweaks, current_dev)==1)
					goto VIA_597_0_out;
				if (tune_device (VIA_82C597_0_SDRAM2_B1_Tweaks, current_dev)==1)
					goto VIA_597_0_out;
				break;

		case 3:		// SDRAM
				if (tune_device (VIA_82C597_0_SDRAM_B1_Tweaks, current_dev)==1)
					goto VIA_597_0_out;
    	}

	/***** Bank 3/2 *******/
	dummy = pci_read_byte (current_dev, 0x60);
	switch (dummy & ((1<<3|1<<2)>>2)) {

		case 0:		// Fast page mode
		case 1:		// EDO
				if (tune_device (VIA_82C597_0_EDOFPM_B2_Tweaks, current_dev)==1)
					goto VIA_597_0_out;
				break;

		case 2:		// DDR SDRAM-II
				if (tune_device (VIA_82C597_0_SDRAM_B2_Tweaks, current_dev)==1)
					goto VIA_597_0_out;
				if (tune_device (VIA_82C597_0_SDRAM2_B2_Tweaks, current_dev)==1)
					goto VIA_597_0_out;
				break;

		case 3:		// SDRAM
				if (tune_device (VIA_82C597_0_SDRAM_B2_Tweaks, current_dev)==1)
					goto VIA_597_0_out;
				break;
	}

	/***** Bank 5/4 *******/
	dummy = pci_read_byte (current_dev, 0x60);
	switch (dummy & ((1<<5|1<<4)>>4)) {

		case 0:		// Fast page mode
		case 1:		// EDO
				if (tune_device (VIA_82C597_0_EDOFPM_B3_Tweaks, current_dev)==1)
					goto VIA_597_0_out;
				break;

		case 2:		// DDR SDRAM-II
				if (tune_device (VIA_82C597_0_SDRAM_B3_Tweaks, current_dev)==1)
					goto VIA_597_0_out;
				if (tune_device (VIA_82C597_0_SDRAM2_B3_Tweaks, current_dev)==1)
					goto VIA_597_0_out;
				break;

		case 3:		// SDRAM
				if (tune_device (VIA_82C597_0_SDRAM_B3_Tweaks, current_dev)==1)
					goto VIA_597_0_out;
				break;
	}



/******************************************
 Tune the AGP settings.
 ******************************************/

	/* FIXME: This implementation is broken.
	 If someone has a chipset capable of AGP x2, they can't select AGP_X1
	 (why they'd want to is irrelevant, they should still be able to) */

	dummy = pci_read_byte (current_dev, 0xa4);
	switch (dummy & (1<<1|1<<0)) {
		case 3:
		case 2:
			if (find_PCI_tag(VIA_82C597_0_ID, "AGP_X2", &option)==TRUE) {
				current_val = pci_read_byte (current_dev, 0xa9);
				pci_write_byte(current_dev, 0xa9, current_val & 0xfe);	// disable AGP

				current_val = pci_read_byte (current_dev, 0xa8);
				pci_write_byte(current_dev, 0xa8, current_val|(1<<1 | 1<<0));	// 1X & 2X Enable

				current_val = pci_read_byte (current_dev, 0xa9);
				pci_write_byte(current_dev, 0xa9, current_val | 1<<0);	// enable AGP
	    		}
			break;
	
		case 1:	/* AGP X1 supported */
			if (find_PCI_tag(VIA_82C597_0_ID, "AGP_X1", &option)==TRUE) {
				current_val = pci_read_byte (current_dev, 0xa9);
				pci_write_byte(current_dev, 0xa9, current_val & 0xfe);	// disable AGP

				current_val = pci_read_byte (current_dev, 0xa8);
				pci_write_byte(current_dev, 0xa8, current_val | 1<<0);	// 1X Enable

				current_val = pci_read_byte (current_dev, 0xa9);
				pci_write_byte(current_dev, 0xa9, current_val | 1<<0);	// enable AGP
			}
			break;
		case 0:
			break;
	}

	dummy = pci_read_byte (current_dev, 0xa5);
	if (dummy & (1<<1)==1) {
		if (find_PCI_tag(VIA_82C597_0_ID, "SIDEBAND_AGP", &option)==TRUE) {
			current_val = pci_read_byte (current_dev, 0xa9);
			pci_write_byte(current_dev, 0xa9, current_val & 0xfe);	// disable AGP

			current_val = pci_read_byte (current_dev, 0xa9);
			pci_write_byte(current_dev, 0xa8, current_val | 1<<1);	// Enable sideband addressing

			current_val = pci_read_byte (current_dev, 0xa9);
			pci_write_byte(current_dev, 0xa9, current_val | 1<<0);	// enable AGP
		}
	}

VIA_597_0_out:
}
