/*
 * Hardware tuning for the Intel 82443BX/GX/ZX bridge
 * This chipset can take on two forms, depending upon whether or not
 * AGP is enabled. Currently, both forms use the same tweakset.
 */

#define PCI_DEVICE_ID_Intel_82443BX_ZX 0x7190
#define PCI_DEVICE_ID_Intel_82443BX_ZX_NOAGP 0x7192

// FIXME: If we decide to add AGP tweaks, we should split these tweaks
// into two seperate lists, and have the AGP enabled version of this
// chipset use the AGP list. [Though it probably wouldn't do any harm]

static Tweaks_t Intel_82443BX_ZXTweaks[] = {
	/* Tagname						Reg		Mask	Bit		Description	*/
	{ "HOST_FAST_DATA_READY",		0x52,	1<<2,	1<<2,	"Host bus fast data ready" },
	{ "USWC_WRITE_POST_IO_ACCESS",	0x50,	1<<3,	1<<3,	"USWC Write post during IO bridge access" },
	{ "IN_ORDER_QUEUE_DEPTH",		0x50,	1<<2,	1<<2,	"Maximum in-order queue depth" },
// FIXME: The following 9 tweaks are probably largely unnecessary.
// Can someone with a BX chipset find the optimal value, so we can delete the others?
	{ "DRAM_IDLE_TIMER_0",			0x78,	0xf,	0,		"DRAM Idle timer = 0 clocks" },
	{ "DRAM_IDLE_TIMER_2",			0x78,	0xf,	1,		"DRAM Idle timer = 2 clocks" },
	{ "DRAM_IDLE_TIMER_4",			0x78,	0xf,	2,		"DRAM Idle timer = 4 clocks" },
	{ "DRAM_IDLE_TIMER_8",			0x78,	0xf,	3,		"DRAM Idle timer = 8 clocks" },
	{ "DRAM_IDLE_TIMER_10",			0x78,	0xf,	4,		"DRAM Idle timer = 10 clocks" },
	{ "DRAM_IDLE_TIMER_12",			0x78,	0xf,	5,		"DRAM Idle timer = 12 clocks" },
	{ "DRAM_IDLE_TIMER_16",			0x78,	0xf,	6,		"DRAM Idle timer = 16 clocks" },
	{ "DRAM_IDLE_TIMER_32",			0x78,	0xf,	7,		"DRAM Idle timer = 32 clocks" },
	{ "DRAM_IDLE_TIMER_INF",		0x78,	0xf,	8,		"DRAM pages not closed for idle contention" },
	{ "POWER_DOWN_SDRAM",			0x7a,	1<<7,	1<<7,	"Power down SDRAM when idle" },
	{ 0, 0, 0, 0, 0 }
};
