/*
 * Hardware tuning for the VIA 82C586_0 PCI-to-ISA bridge
 */

#define PCI_DEVICE_ID_VIA_586_0 0x0586

static Tweaks_t VIA_82C586_0_Tweaks[] = {
	{ "ISA_COMMAND_DELAY",
		0x40,
		1<<7,
		0<<7,
		"ISA command delay",
		"0",
		0, 0 },

	{ "EXTENDED_ISA_READY",
		0x40,
		1<<6,
		0<<6,
		"Extended ISA bus ready",
		"1",
		0, 0 },

	{ "ISA_SLAVE_WS",
		0x40,
		1<<5,
		0<<5,
		"ISA Slave 4WS",
		"Use 4 waitstates instead of 5",
		0, 0 },

	{ "CHIPSET_IO_WS",
		0x40,
		1<<4,
		0<<4,
		"Chipset I/O 2WS",
		"Use 2 waitstates instead of 4",
		0, 0 },

	{ "IO_RECOVERY",
		0x40,
		1<<3,
		0<<3,
		"IO Recovery time",
		"Disables extended recovery time",
		0, 0 },

	{ "EXTEND_ALE",
		0x40,
		1<<2,
		1<<2,
		"Extend ALE",
		"?",
		0, 0 },

	{ "ROM_WS",
		0x40,
		1<<1,
		1<<1,
		"ROM 0WS",
		"Use no waitstates instead of 1",
		0, 0 },

	{ "PCI_BURST_INTERRUPTING",
		0x46,
		1<<1,
		1<<1,
		"PCI burst interrupting",
		"Don't allow PCI burst reads to be interrupted",
		0, 0 },

	{ "POST_MEM_WRITE",
		0x46,
		1<<0,
		1<<0,
		"Post memory write enable",
		"1",
		0, 0 },

	{ "PCI_DELAY_TRANSACTION",
		0x47,
		1<<6,
		1<<6,
		"PCI delayed transactions",
		"1",
		0, 0 },

	{ "WR_DELAY_TRANSACTION_TO",
		0x47,
		1<<2,
		1<<2,
		"Write delay transaction timeout timer enable",
		"Disable write delay transaction timeout timer",
		0, 0 },

	{ "RD_DELAY_TRANSACTION_TO",0x47,
		1<<1,
		1<<1,
		"Read delay transaction timeout timer enable",
		"Disable read delay transaction timeout timer",
		0, 0 },

	{ 0, 0, 0, 0, 0, 0, 0, 0 }
};
